/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.security.users;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.security.auth.Subject;
import org.apache.jetspeed.portlets.security.SecurityUtil;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.apache.portals.gems.browser.BrowserIterator;
import org.apache.portals.gems.browser.BrowserPortlet;
import org.apache.portals.gems.browser.DatabaseBrowserIterator;
import org.apache.portals.gems.util.StatusMessage;
import org.apache.portals.messaging.PortletMessaging;
import org.apache.velocity.context.Context;

/*
 * Exception performing whole class analysis ignored.
 */
public class UserBrowser
extends BrowserPortlet {
    protected UserManager userManager;
    public static final String STATUS = "statusMsg";
    public static final String SELECTED = "selected";
    static /* synthetic */ Class class$org$apache$jetspeed$security$UserPrincipal;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.userManager = (UserManager)this.getPortletContext().getAttribute("cps:UserManager");
        if (null == this.userManager) {
            throw new PortletException("Failed to find the User Manager on portlet initialization");
        }
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        ArrayList errorMessages;
        String filtered;
        String refresh;
        StatusMessage msg;
        String selected = (String)PortletMessaging.receive((PortletRequest)request, (String)"users", (String)"selected");
        if (selected != null) {
            Context context = this.getContext(request);
            context.put("selected", (Object)selected);
        }
        if ((msg = (StatusMessage)PortletMessaging.consume((PortletRequest)request, (String)"users", (String)"status")) != null) {
            this.getContext(request).put("statusMsg", (Object)msg);
        }
        if ((refresh = (String)PortletMessaging.consume((PortletRequest)request, (String)"users", (String)"refresh")) != null) {
            this.clearBrowserIterator((PortletRequest)request);
        }
        if ((filtered = (String)PortletMessaging.receive((PortletRequest)request, (String)"users", (String)"filtered")) != null) {
            this.getContext(request).put("filtered", (Object)"on");
        }
        if ((errorMessages = (ArrayList)PortletMessaging.consume((PortletRequest)request, (String)"users", (String)"errorMessages")) != null) {
            this.getContext(request).put("errorMessages", (Object)errorMessages);
        }
        super.doView(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        String filtered;
        String selected;
        if (request.getPortletMode() == PortletMode.VIEW && (selected = request.getParameter("user")) != null) {
            PortletMessaging.publish((PortletRequest)request, (String)"users", (String)"selected", (Object)selected);
        }
        if ((filtered = request.getParameter("filtered")) != null) {
            PortletMessaging.publish((PortletRequest)request, (String)"users", (String)"filtered", (Object)"on");
        } else {
            PortletMessaging.cancel((PortletRequest)request, (String)"users", (String)"filtered");
        }
        super.processAction(request, response);
    }

    public void getRows(RenderRequest request, String sql, int windowSize) {
        this.getRows(request, sql, windowSize, "");
    }

    public void getRows(RenderRequest request, String sql, int windowSize, String filter) {
        String roleFilter = request.getPreferences().getValue("FilterByRole", "");
        if (roleFilter == null) {
            roleFilter = "";
        }
        boolean filterByRole = !roleFilter.equals("") || roleFilter.equalsIgnoreCase("false");
        ArrayList<String> resultSetTitleList = new ArrayList<String>();
        ArrayList<String> resultSetTypeList = new ArrayList<String>();
        resultSetTypeList.add(String.valueOf(12));
        resultSetTitleList.add("user");
        ArrayList<String> list = new ArrayList<String>();
        try {
            Iterator users;
            if (filterByRole) {
                users = this.userManager.getUsersInRole(roleFilter).iterator();
                while (users.hasNext()) {
                    User user = (User)users.next();
                    Principal pr = UserBrowser.getBestPrincipal((Subject)user.getSubject(), (Class)(class$org$apache$jetspeed$security$UserPrincipal == null ? UserBrowser.class$((String)"org.apache.jetspeed.security.UserPrincipal") : class$org$apache$jetspeed$security$UserPrincipal));
                    list.add(pr.getName());
                }
            } else {
                users = this.userManager.getUserNames(filter);
                while (users.hasNext()) {
                    list.add((String)users.next());
                }
            }
        }
        catch (SecurityException sex) {
            SecurityUtil.publishErrorMessage((PortletRequest)request, (String)"users", (String)sex.getMessage());
        }
        DatabaseBrowserIterator iterator = new DatabaseBrowserIterator(list, resultSetTitleList, resultSetTypeList, windowSize);
        this.setBrowserIterator(request, (BrowserIterator)iterator);
        iterator.sort("user");
    }

    public static Principal getBestPrincipal(Subject subject, Class classe) {
        Principal principal = null;
        Iterator<Principal> principals = subject.getPrincipals().iterator();
        while (principals.hasNext()) {
            Principal p = principals.next();
            if (classe.isInstance(p)) {
                principal = p;
                break;
            }
            if (principal != null) continue;
            principal = p;
        }
        return principal;
    }
}

