/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.security.users;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import org.apache.jetspeed.security.Role;
import org.apache.jetspeed.security.RoleManager;
import org.apache.portals.gems.browser.BrowserIterator;
import org.apache.portals.gems.browser.BrowserPortlet;
import org.apache.portals.gems.browser.DatabaseBrowserIterator;

public class RoleChooserPortlet
extends BrowserPortlet {
    private RoleManager roleManager;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.roleManager = (RoleManager)this.getPortletContext().getAttribute("cps:GroupManager");
        if (null == this.roleManager) {
            throw new PortletException("Failed to find the User Manager on portlet initialization");
        }
    }

    public void getRows(RenderRequest request, String sql, int windowSize) throws Exception {
        ArrayList<String> resultSetTitleList = new ArrayList<String>();
        ArrayList<String> resultSetTypeList = new ArrayList<String>();
        try {
            Iterator roles = this.roleManager.getRoles("");
            resultSetTypeList.add(String.valueOf(12));
            resultSetTitleList.add("Role");
            ArrayList<String> list = new ArrayList<String>();
            while (roles.hasNext()) {
                Role role = (Role)roles.next();
                Principal principal = role.getPrincipal();
                list.add(principal.getName());
            }
            DatabaseBrowserIterator iterator = new DatabaseBrowserIterator(list, resultSetTitleList, resultSetTypeList, windowSize);
            this.setBrowserIterator(request, (BrowserIterator)iterator);
            iterator.sort("Role");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }
}

