/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.security.users;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import org.apache.jetspeed.security.Group;
import org.apache.jetspeed.security.GroupManager;
import org.apache.portals.gems.browser.BrowserIterator;
import org.apache.portals.gems.browser.BrowserPortlet;
import org.apache.portals.gems.browser.DatabaseBrowserIterator;

public class GroupChooserPortlet
extends BrowserPortlet {
    private GroupManager groupManager;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.groupManager = (GroupManager)this.getPortletContext().getAttribute("cps:GroupManager");
        if (null == this.groupManager) {
            throw new PortletException("Failed to find the User Manager on portlet initialization");
        }
    }

    public void getRows(RenderRequest request, String sql, int windowSize) throws Exception {
        ArrayList<String> resultSetTitleList = new ArrayList<String>();
        ArrayList<String> resultSetTypeList = new ArrayList<String>();
        try {
            Iterator groups = this.groupManager.getGroups("");
            resultSetTypeList.add(String.valueOf(12));
            resultSetTitleList.add("Group");
            ArrayList<String> list = new ArrayList<String>();
            while (groups.hasNext()) {
                Group group = (Group)groups.next();
                Principal principal = group.getPrincipal();
                list.add(principal.getName());
            }
            DatabaseBrowserIterator iterator = new DatabaseBrowserIterator(list, resultSetTitleList, resultSetTypeList, windowSize);
            this.setBrowserIterator(request, (BrowserIterator)iterator);
            iterator.sort("Group");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }
}

