/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.security.sso;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.security.auth.Subject;
import org.apache.jetspeed.portlets.security.SecurityUtil;
import org.apache.jetspeed.security.GroupManager;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.sso.SSOException;
import org.apache.jetspeed.sso.SSOProvider;
import org.apache.jetspeed.sso.SSOSite;
import org.apache.portals.gems.browser.BrowserIterator;
import org.apache.portals.gems.browser.BrowserPortlet;
import org.apache.portals.gems.browser.DatabaseBrowserIterator;
import org.apache.portals.gems.util.StatusMessage;
import org.apache.portals.messaging.PortletMessaging;
import org.apache.velocity.context.Context;

public class SSODetails
extends BrowserPortlet {
    private SSOProvider sso;
    private UserManager userManager;
    private GroupManager groupManager;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.sso = (SSOProvider)this.getPortletContext().getAttribute("cps:SSO");
        if (null == this.sso) {
            throw new PortletException("Failed to find the SSO Provider on portlet initialization");
        }
        this.userManager = (UserManager)this.getPortletContext().getAttribute("cps:UserManager");
        if (null == this.userManager) {
            throw new PortletException("Failed to find the User Manager on portlet initialization");
        }
        this.groupManager = (GroupManager)this.getPortletContext().getAttribute("cps:GroupManager");
        if (null == this.groupManager) {
            throw new PortletException("Failed to find the Group Manager on portlet initialization");
        }
    }

    public void getRows(RenderRequest request, String sql, int windowSize) throws Exception {
        ArrayList<String> resultSetTitleList = new ArrayList<String>();
        ArrayList<String> resultSetTypeList = new ArrayList<String>();
        try {
            SSOSite site = null;
            List list = null;
            resultSetTypeList.add(String.valueOf(12));
            resultSetTitleList.add("Principal");
            resultSetTypeList.add(String.valueOf(12));
            resultSetTitleList.add("Remote");
            String selectedSite = (String)PortletMessaging.receive((PortletRequest)request, (String)"site", (String)"selectedUrl");
            if (selectedSite != null) {
                site = this.sso.getSite(selectedSite);
                list = this.sso.getPrincipalsForSite(site);
            } else {
                list = new ArrayList();
            }
            DatabaseBrowserIterator iterator = new DatabaseBrowserIterator(list, resultSetTitleList, resultSetTypeList, windowSize);
            this.setBrowserIterator(request, (BrowserIterator)iterator);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String change = (String)PortletMessaging.consume((PortletRequest)request, (String)"site", (String)"change");
        if (change != null) {
            this.clearBrowserIterator((PortletRequest)request);
        }
        Context context = this.getContext(request);
        String selectedSite = (String)PortletMessaging.receive((PortletRequest)request, (String)"site", (String)"selectedUrl");
        if (selectedSite != null) {
            context.put("currentSite", (Object)selectedSite);
        }
        String userChooser = SecurityUtil.getAbsoluteUrl((RenderRequest)request, (String)"/Administrative/choosers/users.psml");
        String groupChooser = SecurityUtil.getAbsoluteUrl((RenderRequest)request, (String)"/Administrative/choosers/groups.psml");
        context.put("userChooser", (Object)userChooser);
        context.put("groupChooser", (Object)groupChooser);
        StatusMessage msg = (StatusMessage)PortletMessaging.consume((PortletRequest)request, (String)"SSODetails", (String)"status");
        if (msg != null) {
            this.getContext(request).put("statusMsg", (Object)msg);
        }
        super.doView(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        block21: {
            if (request.getPortletMode() == PortletMode.VIEW) {
                String refresh = request.getParameter("sso.refresh");
                String add = request.getParameter("sso.add");
                String delete = request.getParameter("ssoDelete");
                if (refresh != null) {
                    this.clearBrowserIterator((PortletRequest)request);
                } else if (delete != null && !this.isEmpty(delete)) {
                    try {
                        String siteName = (String)PortletMessaging.receive((PortletRequest)request, (String)"site", (String)"selectedUrl");
                        SSOSite site = this.sso.getSite(siteName);
                        User user = null;
                        try {
                            user = this.userManager.getUser(delete);
                        }
                        catch (SecurityException se) {
                            user = null;
                        }
                        if (site == null) break block21;
                        if (user != null) {
                            Subject subject = user.getSubject();
                            this.sso.removeCredentialsForSite(subject, site.getSiteURL());
                            this.clearBrowserIterator((PortletRequest)request);
                            break block21;
                        }
                        String fullPath = "/group/" + delete;
                        this.sso.removeCredentialsForSite(fullPath, site.getSiteURL());
                        this.clearBrowserIterator((PortletRequest)request);
                    }
                    catch (SSOException e) {
                        this.publishStatusMessage((PortletRequest)request, "SSODetails", "status", (Throwable)e, "Could not remove credentials");
                    }
                } else if (add != null) {
                    String principalType = request.getParameter("principal.type");
                    String portalPrincipal = request.getParameter("portal.principal");
                    String remotePrincipal = request.getParameter("remote.principal");
                    String remoteCredential = request.getParameter("remote.credential");
                    if (principalType == null || principalType.length() == 0) {
                        principalType = "user";
                    }
                    if (!(this.isEmpty(remotePrincipal) || this.isEmpty(remotePrincipal) || this.isEmpty(remoteCredential))) {
                        try {
                            String siteName = (String)PortletMessaging.receive((PortletRequest)request, (String)"site", (String)"selectedUrl");
                            SSOSite site = this.sso.getSite(siteName);
                            Subject subject = null;
                            String groupFullPath = null;
                            if (principalType.compareTo("user") == 0) {
                                User user = this.userManager.getUser(portalPrincipal);
                                subject = user.getSubject();
                            } else {
                                groupFullPath = "/group/" + portalPrincipal;
                            }
                            if (site != null && (subject != null || groupFullPath != null)) {
                                if (subject != null) {
                                    this.sso.addCredentialsForSite(subject, remotePrincipal, site.getSiteURL(), remoteCredential);
                                } else {
                                    this.sso.addCredentialsForSite(groupFullPath, remotePrincipal, site.getSiteURL(), remoteCredential);
                                }
                                this.clearBrowserIterator((PortletRequest)request);
                            }
                        }
                        catch (SSOException e) {
                            this.publishStatusMessage((PortletRequest)request, "SSODetails", "status", (Throwable)e, "Could not add credentials");
                        }
                        catch (SecurityException se) {
                            this.publishStatusMessage((PortletRequest)request, "SSODetails", "status", (Throwable)se, "Could not add credentials");
                        }
                    }
                }
            }
        }
        super.processAction(request, response);
    }

    private boolean isEmpty(String s) {
        if (s == null) {
            return true;
        }
        return s.trim().equals("");
    }
}

