/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.security.sso;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.jetspeed.sso.SSOException;
import org.apache.jetspeed.sso.SSOProvider;
import org.apache.jetspeed.sso.SSOSite;
import org.apache.portals.gems.browser.BrowserIterator;
import org.apache.portals.gems.browser.BrowserPortlet;
import org.apache.portals.gems.browser.DatabaseBrowserIterator;
import org.apache.portals.gems.util.StatusMessage;
import org.apache.portals.messaging.PortletMessaging;
import org.apache.velocity.context.Context;

public class SSOBrowser
extends BrowserPortlet {
    private SSOProvider sso;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.sso = (SSOProvider)this.getPortletContext().getAttribute("cps:SSO");
        if (null == this.sso) {
            throw new PortletException("Failed to find the SSO Provider on portlet initialization");
        }
    }

    public void getRows(RenderRequest request, String sql, int windowSize) throws Exception {
        ArrayList<String> resultSetTitleList = new ArrayList<String>();
        ArrayList<String> resultSetTypeList = new ArrayList<String>();
        try {
            Iterator sites = this.sso.getSites("");
            resultSetTypeList.add(String.valueOf(12));
            resultSetTypeList.add(String.valueOf(12));
            resultSetTitleList.add(0, "Url");
            resultSetTitleList.add(1, "Site");
            ArrayList list = new ArrayList();
            while (sites.hasNext()) {
                ArrayList<String> row = new ArrayList<String>(2);
                SSOSite site = (SSOSite)sites.next();
                row.add(0, site.getSiteURL());
                row.add(1, site.getName());
                list.add(row);
            }
            DatabaseBrowserIterator iterator = new DatabaseBrowserIterator(list, resultSetTitleList, resultSetTypeList, windowSize);
            this.setBrowserIterator(request, (BrowserIterator)iterator);
            iterator.sort("Site");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        StatusMessage msg;
        String selectedSite = (String)PortletMessaging.receive((PortletRequest)request, (String)"site", (String)"selectedUrl");
        if (selectedSite != null) {
            Context context = this.getContext(request);
            context.put("currentUrl", (Object)selectedSite);
            String selectedName = (String)PortletMessaging.receive((PortletRequest)request, (String)"site", (String)"selectedName");
            context.put("currentName", (Object)selectedName);
            String realm = (String)PortletMessaging.receive((PortletRequest)request, (String)"site", (String)"realm");
            context.put("currentRealm", (Object)realm);
            String userField = (String)PortletMessaging.receive((PortletRequest)request, (String)"site", (String)"idField");
            context.put("currentFFID", (Object)userField);
            String pwdFiled = (String)PortletMessaging.receive((PortletRequest)request, (String)"site", (String)"pwdField");
            context.put("currentFFPWD", (Object)pwdFiled);
        }
        if ((msg = (StatusMessage)PortletMessaging.consume((PortletRequest)request, (String)"SSOBrowser", (String)"status")) != null) {
            this.getContext(request).put("statusMsg", (Object)msg);
        }
        super.doView(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        if (request.getPortletMode() == PortletMode.VIEW) {
            SSOSite site;
            String selectedSite = request.getParameter("ssoSite");
            if (selectedSite != null && (site = this.sso.getSite(selectedSite)) != null) {
                PortletMessaging.publish((PortletRequest)request, (String)"site", (String)"selectedUrl", (Object)selectedSite);
                PortletMessaging.publish((PortletRequest)request, (String)"site", (String)"selectedName", (Object)site.getName());
                PortletMessaging.publish((PortletRequest)request, (String)"site", (String)"change", (Object)selectedSite);
                PortletMessaging.publish((PortletRequest)request, (String)"site", (String)"realm", (Object)site.getRealm());
                PortletMessaging.publish((PortletRequest)request, (String)"site", (String)"idField", (Object)site.getFormUserField());
                PortletMessaging.publish((PortletRequest)request, (String)"site", (String)"pwdField", (Object)site.getFormPwdField());
            }
            String refresh = request.getParameter("sso.refresh");
            String save = request.getParameter("sso.save");
            String neue = request.getParameter("sso.new");
            String delete = request.getParameter("ssoDelete");
            if (refresh != null) {
                this.clearBrowserIterator((PortletRequest)request);
            } else if (neue != null) {
                PortletMessaging.cancel((PortletRequest)request, (String)"site", (String)"selected");
                PortletMessaging.cancel((PortletRequest)request, (String)"site", (String)"selectedUrl");
                PortletMessaging.cancel((PortletRequest)request, (String)"site", (String)"realm");
                PortletMessaging.cancel((PortletRequest)request, (String)"site", (String)"idField");
                PortletMessaging.cancel((PortletRequest)request, (String)"site", (String)"pwdField");
            } else if (delete != null && !this.isEmpty(delete)) {
                try {
                    SSOSite site2 = null;
                    site2 = this.sso.getSite(delete);
                    if (site2 != null) {
                        this.sso.removeSite(site2);
                        this.clearBrowserIterator((PortletRequest)request);
                        PortletMessaging.cancel((PortletRequest)request, (String)"site", (String)"selected");
                        PortletMessaging.cancel((PortletRequest)request, (String)"site", (String)"selectedUrl");
                        PortletMessaging.cancel((PortletRequest)request, (String)"site", (String)"realm");
                        PortletMessaging.cancel((PortletRequest)request, (String)"site", (String)"idField");
                        PortletMessaging.cancel((PortletRequest)request, (String)"site", (String)"pwdField");
                    }
                }
                catch (SSOException e) {
                    this.publishStatusMessage((PortletRequest)request, "SSOBrowser", "status", (Throwable)e, "Could not remove site");
                }
            } else if (save != null) {
                String siteName = request.getParameter("site.name");
                String siteUrl = request.getParameter("site.url");
                String siteRealm = request.getParameter("site.realm");
                String siteFormID = request.getParameter("site.form_field_ID");
                String siteFormPWD = request.getParameter("site.form_field_PWD");
                if (!this.isEmpty(siteName) && !this.isEmpty(siteUrl)) {
                    try {
                        SSOSite site3 = null;
                        String old = (String)PortletMessaging.receive((PortletRequest)request, (String)"site", (String)"selectedUrl");
                        site3 = old != null ? this.sso.getSite(old) : this.sso.getSite(siteUrl);
                        if (site3 != null) {
                            site3.setName(siteName);
                            site3.setSiteURL(siteUrl);
                            site3.setRealm(siteRealm);
                            if (siteFormID != null && siteFormID.length() > 0 && siteFormPWD != null && siteFormPWD.length() > 0) {
                                site3.setFormAuthentication(true);
                                site3.setFormUserField(siteFormID);
                                site3.setFormPwdField(siteFormPWD);
                            } else {
                                site3.setChallengeResponseAuthentication(true);
                            }
                            this.sso.updateSite(site3);
                            this.clearBrowserIterator((PortletRequest)request);
                            PortletMessaging.publish((PortletRequest)request, (String)"site", (String)"selectedName", (Object)siteName);
                            PortletMessaging.publish((PortletRequest)request, (String)"site", (String)"selectedUrl", (Object)siteUrl);
                            PortletMessaging.publish((PortletRequest)request, (String)"site", (String)"realm", (Object)siteRealm);
                            PortletMessaging.publish((PortletRequest)request, (String)"site", (String)"idField", (Object)siteFormID);
                            PortletMessaging.publish((PortletRequest)request, (String)"site", (String)"pwdField", (Object)siteFormPWD);
                        } else {
                            if (siteFormID != null && siteFormID.length() > 0 && siteFormPWD != null && siteFormPWD.length() > 0) {
                                this.sso.addSiteFormAuthenticated(siteName, siteUrl, siteRealm, siteFormID, siteFormPWD);
                            } else {
                                this.sso.addSiteChallengeResponse(siteName, siteUrl, siteRealm);
                            }
                            this.clearBrowserIterator((PortletRequest)request);
                        }
                    }
                    catch (SSOException e) {
                        this.publishStatusMessage((PortletRequest)request, "SSOBrowser", "status", (Throwable)e, "Could not store site");
                    }
                }
            }
        }
        super.processAction(request, response);
    }

    private boolean isEmpty(String s) {
        if (s == null) {
            return true;
        }
        return s.trim().equals("");
    }
}

