/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.security.roles;

import java.io.IOException;
import java.io.NotSerializableException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.security.auth.Subject;
import org.apache.jetspeed.portlets.security.SecurityUtil;
import org.apache.jetspeed.security.RoleManager;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.apache.portals.gems.browser.BrowserIterator;
import org.apache.portals.gems.browser.BrowserPortlet;
import org.apache.portals.gems.browser.DatabaseBrowserIterator;
import org.apache.portals.gems.util.StatusMessage;
import org.apache.portals.messaging.PortletMessaging;
import org.apache.velocity.context.Context;

/*
 * Exception performing whole class analysis ignored.
 */
public class RoleDetails
extends BrowserPortlet {
    private UserManager userManager;
    private RoleManager roleManager;
    static /* synthetic */ Class class$org$apache$jetspeed$security$UserPrincipal;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.userManager = (UserManager)this.getPortletContext().getAttribute("cps:UserManager");
        if (null == this.userManager) {
            throw new PortletException("Failed to find the User Manager on portlet initialization");
        }
        this.roleManager = (RoleManager)this.getPortletContext().getAttribute("cps:RoleManager");
        if (null == this.roleManager) {
            throw new PortletException("Failed to find the Role Manager on portlet initialization");
        }
    }

    public void getRows(RenderRequest request, String sql, int windowSize) {
        this.getRows(request, sql, windowSize, null);
    }

    public void getRows(RenderRequest request, String sql, int windowSize, String filter) {
        ArrayList<String> resultSetTitleList = new ArrayList<String>();
        ArrayList<String> resultSetTypeList = new ArrayList<String>();
        if (filter != null) {
            filter = filter.length() == 0 ? null : filter.toLowerCase();
        }
        ArrayList<String> list = new ArrayList<String>();
        resultSetTypeList.add(String.valueOf(12));
        resultSetTitleList.add("usersinrole");
        String selectedRole = (String)PortletMessaging.receive((PortletRequest)request, (String)"roles", (String)"selected");
        if (selectedRole != null) {
            try {
                Iterator users = this.userManager.getUsersInRole(selectedRole).iterator();
                while (users.hasNext()) {
                    User user = (User)users.next();
                    Principal principal = SecurityUtil.getPrincipal((Subject)user.getSubject(), (Class)(class$org$apache$jetspeed$security$UserPrincipal == null ? RoleDetails.class$((String)"org.apache.jetspeed.security.UserPrincipal") : class$org$apache$jetspeed$security$UserPrincipal));
                    if (filter != null && !principal.getName().toLowerCase().startsWith(filter)) continue;
                    list.add(principal.getName());
                }
            }
            catch (SecurityException sex) {
                SecurityUtil.publishErrorMessage((PortletRequest)request, (String)"role", (String)sex.getMessage());
            }
        }
        DatabaseBrowserIterator iterator = new DatabaseBrowserIterator(list, resultSetTitleList, resultSetTypeList, windowSize);
        this.setBrowserIterator(request, (BrowserIterator)iterator);
        iterator.sort("usersinrole");
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        ArrayList errorMessages;
        String refresh;
        String filtered;
        String change = (String)PortletMessaging.consume((PortletRequest)request, (String)"roles", (String)"changed");
        if (change != null) {
            this.clearBrowserIterator((PortletRequest)request);
        }
        Context context = this.getContext(request);
        String selectedRole = (String)PortletMessaging.receive((PortletRequest)request, (String)"roles", (String)"selected");
        if (selectedRole != null) {
            context.put("role", (Object)selectedRole);
        }
        String userChooser = SecurityUtil.getAbsoluteUrl((RenderRequest)request, (String)"/Administrative/choosers/multiusers.psml");
        context.put("userChooser", (Object)userChooser);
        StatusMessage msg = (StatusMessage)PortletMessaging.consume((PortletRequest)request, (String)"role", (String)"status");
        if (msg != null) {
            this.getContext(request).put("statusMsg", (Object)msg);
        }
        if ((filtered = (String)PortletMessaging.receive((PortletRequest)request, (String)"role", (String)"filtered")) != null) {
            this.getContext(request).put("filtered", (Object)"on");
        }
        if ((refresh = (String)PortletMessaging.consume((PortletRequest)request, (String)"role", (String)"refresh")) != null) {
            this.clearBrowserIterator((PortletRequest)request);
        }
        if ((errorMessages = (ArrayList)PortletMessaging.consume((PortletRequest)request, (String)"role", (String)"errorMessages")) != null) {
            this.getContext(request).put("errorMessages", (Object)errorMessages);
        }
        super.doView(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        if (request.getPortletMode() == PortletMode.VIEW) {
            String users = request.getParameter("users");
            if (users != null && users.length() > 0) {
                this.addUsersToRole(request, users);
            } else if (request.getParameter("role.action.Add_New_Role") != null) {
                PortletMessaging.cancel((PortletRequest)request, (String)"roles", (String)"selected");
            } else if (request.getParameter("role.action.Remove_Checked_Users") != null) {
                this.removeUsersFromRole(request);
            } else if (request.getParameter("role.action.Remove_Role") != null) {
                this.removeRole(request);
            } else if (request.getParameter("role.action.Save") != null) {
                this.addRole(request);
            }
            if (request.getParameter("filtered") != null) {
                PortletMessaging.publish((PortletRequest)request, (String)"role", (String)"filtered", (Object)"on");
            } else {
                PortletMessaging.cancel((PortletRequest)request, (String)"role", (String)"filtered");
            }
        }
        super.processAction(request, response);
    }

    protected void addRole(ActionRequest actionRequest) {
        String role = actionRequest.getParameter("role");
        if (!SecurityUtil.isEmpty((String)role)) {
            try {
                this.roleManager.addRole(role);
                PortletMessaging.publish((PortletRequest)actionRequest, (String)"roles", (String)"refresh", (Object)"true");
                PortletMessaging.publish((PortletRequest)actionRequest, (String)"roles", (String)"selected", (Object)role);
                PortletMessaging.publish((PortletRequest)actionRequest, (String)"roles", (String)"changed", (Object)role);
                PortletMessaging.publish((PortletRequest)actionRequest, (String)"users", (String)"refresh.roles", (Object)"true");
                PortletMessaging.publish((PortletRequest)actionRequest, (String)"groups", (String)"refresh.roles", (Object)"true");
            }
            catch (SecurityException sex) {
                SecurityUtil.publishErrorMessage((PortletRequest)actionRequest, (String)"role", (String)sex.getMessage());
            }
            catch (NotSerializableException e) {
                e.printStackTrace();
            }
        }
    }

    protected void removeRole(ActionRequest actionRequest) {
        String role = actionRequest.getParameter("role");
        if (!SecurityUtil.isEmpty((String)role)) {
            try {
                this.roleManager.removeRole(role);
                try {
                    PortletMessaging.publish((PortletRequest)actionRequest, (String)"roles", (String)"refresh", (Object)"true");
                    PortletMessaging.publish((PortletRequest)actionRequest, (String)"users", (String)"refresh.roles", (Object)"true");
                    PortletMessaging.publish((PortletRequest)actionRequest, (String)"groups", (String)"refresh.roles", (Object)"true");
                }
                catch (NotSerializableException e) {
                    e.printStackTrace();
                }
                PortletMessaging.cancel((PortletRequest)actionRequest, (String)"roles", (String)"selected");
            }
            catch (SecurityException sex) {
                SecurityUtil.publishErrorMessage((PortletRequest)actionRequest, (String)"role", (String)sex.getMessage());
            }
        }
    }

    protected void addUsersToRole(ActionRequest request, String users) {
        String role = request.getParameter("role");
        if (role != null) {
            int count = 0;
            StringTokenizer tokenizer = new StringTokenizer(users, ",");
            while (tokenizer.hasMoreTokens()) {
                String user = tokenizer.nextToken();
                try {
                    if (!user.startsWith("box_")) continue;
                    user = user.substring("box_".length());
                    this.roleManager.addRoleToUser(user, role);
                    ++count;
                }
                catch (SecurityException sex) {
                    SecurityUtil.publishErrorMessage((PortletRequest)request, (String)"role", (String)sex.getMessage());
                }
            }
            if (count > 0) {
                try {
                    PortletMessaging.publish((PortletRequest)request, (String)"role", (String)"refresh", (Object)"true");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void removeUsersFromRole(ActionRequest request) {
        String role = request.getParameter("role");
        if (role != null) {
            int count = 0;
            Enumeration e = request.getParameterNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (!name.startsWith("box_")) continue;
                String user = name.substring("box_".length());
                try {
                    this.roleManager.removeRoleFromUser(user, role);
                    ++count;
                }
                catch (SecurityException sex) {
                    SecurityUtil.publishErrorMessage((PortletRequest)request, (String)"role", (String)sex.getMessage());
                }
            }
            if (count > 0) {
                try {
                    PortletMessaging.publish((PortletRequest)request, (String)"role", (String)"refresh", (Object)"true");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

