/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.security.roles;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.jetspeed.portlets.security.SecurityUtil;
import org.apache.jetspeed.security.Role;
import org.apache.jetspeed.security.RoleManager;
import org.apache.jetspeed.security.SecurityException;
import org.apache.portals.gems.browser.BrowserIterator;
import org.apache.portals.gems.browser.BrowserPortlet;
import org.apache.portals.gems.browser.DatabaseBrowserIterator;
import org.apache.portals.gems.util.StatusMessage;
import org.apache.portals.messaging.PortletMessaging;
import org.apache.velocity.context.Context;

public class RoleBrowser
extends BrowserPortlet {
    private RoleManager roleManager;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.roleManager = (RoleManager)this.getPortletContext().getAttribute("cps:RoleManager");
        if (null == this.roleManager) {
            throw new PortletException("Failed to find the Role Manager on portlet initialization");
        }
    }

    public void getRows(RenderRequest request, String sql, int windowSize) {
        this.getRows(request, sql, windowSize, "");
    }

    public void getRows(RenderRequest request, String sql, int windowSize, String filter) {
        ArrayList<String> resultSetTitleList = new ArrayList<String>();
        ArrayList<String> resultSetTypeList = new ArrayList<String>();
        resultSetTypeList.add(String.valueOf(12));
        resultSetTitleList.add("role");
        ArrayList<String> list = new ArrayList<String>();
        try {
            Iterator roles = this.roleManager.getRoles(filter);
            while (roles.hasNext()) {
                Role role = (Role)roles.next();
                Principal principal = role.getPrincipal();
                list.add(principal.getName());
            }
        }
        catch (SecurityException sex) {
            SecurityUtil.publishErrorMessage((PortletRequest)request, (String)"roles", (String)sex.getMessage());
        }
        DatabaseBrowserIterator iterator = new DatabaseBrowserIterator(list, resultSetTitleList, resultSetTypeList, windowSize);
        this.setBrowserIterator(request, (BrowserIterator)iterator);
        iterator.sort("role");
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        ArrayList errorMessages;
        String refresh;
        String filtered;
        StatusMessage msg;
        String selected = (String)PortletMessaging.receive((PortletRequest)request, (String)"roles", (String)"selected");
        if (selected != null) {
            Context context = this.getContext(request);
            context.put("selected", (Object)selected);
        }
        if ((msg = (StatusMessage)PortletMessaging.consume((PortletRequest)request, (String)"roles", (String)"status")) != null) {
            this.getContext(request).put("statusMsg", (Object)msg);
        }
        if ((filtered = (String)PortletMessaging.receive((PortletRequest)request, (String)"roles", (String)"filtered")) != null) {
            this.getContext(request).put("filtered", (Object)"on");
        }
        if ((refresh = (String)PortletMessaging.consume((PortletRequest)request, (String)"roles", (String)"refresh")) != null) {
            this.clearBrowserIterator((PortletRequest)request);
        }
        if ((errorMessages = (ArrayList)PortletMessaging.consume((PortletRequest)request, (String)"roles", (String)"errorMessages")) != null) {
            this.getContext(request).put("errorMessages", (Object)errorMessages);
        }
        super.doView(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        String filtered;
        Role role;
        String selected;
        if (request.getPortletMode() == PortletMode.VIEW && (selected = request.getParameter("role")) != null && (role = this.lookupRole(request, selected)) != null) {
            PortletMessaging.publish((PortletRequest)request, (String)"roles", (String)"selected", (Object)selected);
            PortletMessaging.publish((PortletRequest)request, (String)"roles", (String)"changed", (Object)selected);
        }
        if ((filtered = request.getParameter("filtered")) != null) {
            PortletMessaging.publish((PortletRequest)request, (String)"roles", (String)"filtered", (Object)"on");
        } else {
            PortletMessaging.cancel((PortletRequest)request, (String)"roles", (String)"filtered");
        }
        super.processAction(request, response);
    }

    private Role lookupRole(ActionRequest actionRequest, String roleName) {
        try {
            return this.roleManager.getRole(roleName);
        }
        catch (SecurityException sex) {
            SecurityUtil.publishErrorMessage((PortletRequest)actionRequest, (String)"roles", (String)sex.getMessage());
            return null;
        }
    }
}

