/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.security.permissions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.headerresource.HeaderResource;
import org.apache.jetspeed.portlets.security.permissions.SecurityPermissionsPortlet;
import org.apache.jetspeed.security.PermissionManager;
import org.apache.jetspeed.security.RoleManager;
import org.apache.jetspeed.security.om.InternalPermission;
import org.apache.portals.gems.dojo.AbstractDojoVelocityPortlet;
import org.apache.velocity.context.Context;

public class SecurityPermissionsPortlet
extends AbstractDojoVelocityPortlet {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected PermissionManager pm = null;
    protected RoleManager rm = null;
    static final String[] CLASSNAMES = new String[]{"org.apache.jetspeed.security.FolderPermission", "org.apache.jetspeed.security.PagePermission", "org.apache.jetspeed.security.PortletPermission"};
    static final String[] TITLES = new String[]{"Folders", "Pages", "Portlets"};

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        PortletContext context = this.getPortletContext();
        this.pm = (PermissionManager)context.getAttribute("cps:PermissionManager");
        if (this.pm == null) {
            throw new PortletException("Could not get instance of portal permission manager component");
        }
        this.rm = (RoleManager)context.getAttribute("cps:RoleManager");
        if (this.rm == null) {
            throw new PortletException("Could not get instance of portal role manager component");
        }
    }

    protected void includeHeaderContent(HeaderResource headerResource) {
        headerResource.dojoAddCoreLibraryRequire("dojo.lang.*");
        headerResource.dojoAddCoreLibraryRequire("dojo.event.*");
        headerResource.dojoAddCoreLibraryRequire("dojo.io.*");
        headerResource.dojoAddCoreLibraryRequire("dojo.widget.*");
        headerResource.dojoAddCoreLibraryRequire("dojo.widget.LayoutContainer");
        headerResource.dojoAddCoreLibraryRequire("dojo.widget.ContentPane");
        headerResource.dojoAddCoreLibraryRequire("dojo.widget.SplitContainer");
        headerResource.dojoAddCoreLibraryRequire("dojo.widget.TabContainer");
        headerResource.dojoAddCoreLibraryRequire("dojo.widget.Checkbox");
        headerResource.dojoAddCoreLibraryRequire("dojo.widget.Dialog");
        headerResource.dojoAddCoreLibraryRequire("dojo.widget.Button");
        headerResource.dojoAddCoreLibraryRequire("dojo.widget.Menu2");
        headerResource.dojoAddModuleLibraryRequire("jetspeed.widget.EditorTable");
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.retrievePermissions(request.getPortletSession(), this.getContext(request));
        super.doView(request, response);
    }

    public void retrievePermissions(PortletSession session, Context context) {
        Iterator folderPermissions = (Iterator)session.getAttribute("folderPermissions", 2);
        Iterator pagePermissions = (Iterator)session.getAttribute("pagePermissions", 2);
        Iterator portletPermissions = (Iterator)session.getAttribute("portletPermissions", 2);
        Iterator roles = (Iterator)session.getAttribute("roles", 2);
        if (portletPermissions == null) {
            LinkedList<PermissionData> folders = new LinkedList<PermissionData>();
            LinkedList<PermissionData> pages = new LinkedList<PermissionData>();
            LinkedList<PermissionData> portlets = new LinkedList<PermissionData>();
            Iterator all = this.pm.getPermissions().iterator();
            while (all.hasNext()) {
                InternalPermission permission = (InternalPermission)all.next();
                if (permission.getClassname().equals(CLASSNAMES[0])) {
                    folders.add(new PermissionData(this, permission));
                    continue;
                }
                if (permission.getClassname().equals(CLASSNAMES[1])) {
                    pages.add(new PermissionData(this, permission));
                    continue;
                }
                if (!permission.getClassname().equals(CLASSNAMES[2])) continue;
                portlets.add(new PermissionData(this, permission));
            }
            folderPermissions = folders.iterator();
            pagePermissions = pages.iterator();
            portletPermissions = portlets.iterator();
            try {
                roles = this.rm.getRoles("");
            }
            catch (Exception e) {
                this.logger.error((Object)e);
            }
        }
        context.put("folderPermissions", (Object)folderPermissions);
        context.put("pagePermissions", (Object)pagePermissions);
        context.put("portletPermissions", (Object)portletPermissions);
        ArrayList rolesList = new ArrayList();
        if (roles != null) {
            while (roles.hasNext()) {
                rolesList.add(roles.next());
            }
        }
        context.put("roles", rolesList);
    }

    public void processAction(ActionRequest request, ActionResponse actionResponse) throws PortletException, IOException {
    }
}

