/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.security.groups;

import java.io.IOException;
import java.io.NotSerializableException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.security.auth.Subject;
import org.apache.jetspeed.portlets.security.SecurityUtil;
import org.apache.jetspeed.security.GroupManager;
import org.apache.jetspeed.security.Role;
import org.apache.jetspeed.security.RoleManager;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.apache.portals.gems.browser.BrowserIterator;
import org.apache.portals.gems.browser.BrowserPortlet;
import org.apache.portals.gems.browser.DatabaseBrowserIterator;
import org.apache.portals.gems.util.StatusMessage;
import org.apache.portals.messaging.PortletMessaging;
import org.apache.velocity.context.Context;

/*
 * Exception performing whole class analysis ignored.
 */
public class GroupDetails
extends BrowserPortlet {
    private UserManager userManager;
    private RoleManager roleManager;
    private GroupManager groupManager;
    static /* synthetic */ Class class$org$apache$jetspeed$security$UserPrincipal;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.userManager = (UserManager)this.getPortletContext().getAttribute("cps:UserManager");
        if (null == this.userManager) {
            throw new PortletException("Failed to find the User Manager on portlet initialization");
        }
        this.roleManager = (RoleManager)this.getPortletContext().getAttribute("cps:RoleManager");
        if (null == this.roleManager) {
            throw new PortletException("Failed to find the Role Manager on portlet initialization");
        }
        this.groupManager = (GroupManager)this.getPortletContext().getAttribute("cps:GroupManager");
        if (null == this.groupManager) {
            throw new PortletException("Failed to find the Group Manager on portlet initialization");
        }
    }

    public void getRows(RenderRequest request, String sql, int windowSize) {
        this.getRows(request, sql, windowSize, null);
    }

    public void getRows(RenderRequest request, String sql, int windowSize, String filter) {
        ArrayList<String> resultSetTitleList = new ArrayList<String>();
        ArrayList<String> resultSetTypeList = new ArrayList<String>();
        if (filter != null) {
            filter = filter.length() == 0 ? null : filter.toLowerCase();
        }
        ArrayList<String> list = new ArrayList<String>();
        resultSetTypeList.add(String.valueOf(12));
        String groupTab = request.getParameter("groupTab");
        if (groupTab == null) {
            groupTab = "users";
        }
        if ("users".equals(groupTab)) {
            resultSetTitleList.add("usersingroup");
            String selectedGroup = (String)PortletMessaging.receive((PortletRequest)request, (String)"groups", (String)"selected");
            if (selectedGroup != null) {
                try {
                    Iterator users = this.userManager.getUsersInGroup(selectedGroup).iterator();
                    while (users.hasNext()) {
                        User user = (User)users.next();
                        Principal principal = SecurityUtil.getPrincipal((Subject)user.getSubject(), (Class)(class$org$apache$jetspeed$security$UserPrincipal == null ? GroupDetails.class$((String)"org.apache.jetspeed.security.UserPrincipal") : class$org$apache$jetspeed$security$UserPrincipal));
                        if (filter != null && !principal.getName().toLowerCase().startsWith(filter)) continue;
                        list.add(principal.getName());
                    }
                }
                catch (SecurityException sex) {
                    SecurityUtil.publishErrorMessage((PortletRequest)request, (String)"group", (String)sex.getMessage());
                }
            }
            DatabaseBrowserIterator iterator = new DatabaseBrowserIterator(list, resultSetTitleList, resultSetTypeList, windowSize);
            this.setBrowserIterator(request, (BrowserIterator)iterator);
            iterator.sort("usersingroup");
        } else {
            resultSetTitleList.add("rolesingroup");
            String selectedGroup = (String)PortletMessaging.receive((PortletRequest)request, (String)"groups", (String)"selected");
            if (selectedGroup != null) {
                try {
                    Iterator roles = this.roleManager.getRolesInGroup(selectedGroup).iterator();
                    while (roles.hasNext()) {
                        String roleName = ((Role)roles.next()).getPrincipal().getName();
                        if (filter != null && !roleName.toLowerCase().startsWith(filter)) continue;
                        list.add(roleName);
                    }
                }
                catch (SecurityException sex) {
                    SecurityUtil.publishErrorMessage((PortletRequest)request, (String)"group", (String)sex.getMessage());
                }
            }
            DatabaseBrowserIterator iterator = new DatabaseBrowserIterator(list, resultSetTitleList, resultSetTypeList, windowSize);
            this.setBrowserIterator(request, (BrowserIterator)iterator);
            iterator.sort("usersingroup");
        }
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        ArrayList errorMessages;
        String refresh;
        String filtered;
        String popupChooser;
        String groupTab;
        String change = (String)PortletMessaging.consume((PortletRequest)request, (String)"groups", (String)"changed");
        if (change != null) {
            this.clearBrowserIterator((PortletRequest)request);
            PortletMessaging.cancel((PortletRequest)request, (String)"group", (String)"filtered");
        }
        Context context = this.getContext(request);
        String selectedGroup = (String)PortletMessaging.receive((PortletRequest)request, (String)"groups", (String)"selected");
        if (selectedGroup != null) {
            context.put("group", (Object)selectedGroup);
        }
        if ((groupTab = request.getParameter("groupTab")) == null) {
            groupTab = "users";
        }
        context.put("groupTab", (Object)groupTab);
        if ("users".equals(groupTab)) {
            popupChooser = SecurityUtil.getAbsoluteUrl((RenderRequest)request, (String)"/Administrative/choosers/multiusers.psml");
            context.put("popupChooser", (Object)popupChooser);
        } else {
            popupChooser = SecurityUtil.getAbsoluteUrl((RenderRequest)request, (String)"/Administrative/choosers/multiroles.psml");
            context.put("popupChooser", (Object)popupChooser);
        }
        StatusMessage msg = (StatusMessage)PortletMessaging.consume((PortletRequest)request, (String)"group", (String)"status");
        if (msg != null) {
            this.getContext(request).put("statusMsg", (Object)msg);
        }
        if ((filtered = (String)PortletMessaging.receive((PortletRequest)request, (String)"group", (String)"filtered")) != null) {
            this.getContext(request).put("filtered", (Object)"on");
        }
        if ((refresh = (String)PortletMessaging.consume((PortletRequest)request, (String)"group", (String)"refresh")) != null) {
            this.clearBrowserIterator((PortletRequest)request);
        }
        if ((errorMessages = (ArrayList)PortletMessaging.consume((PortletRequest)request, (String)"group", (String)"errorMessages")) != null) {
            this.getContext(request).put("errorMessages", (Object)errorMessages);
        }
        super.doView(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        if (request.getPortletMode() == PortletMode.VIEW) {
            String groupTab = request.getParameter("groupTab");
            if (groupTab == null) {
                PortletMessaging.publish((PortletRequest)request, (String)"group", (String)"refresh", (Object)"true");
                PortletMessaging.cancel((PortletRequest)request, (String)"group", (String)"filtered");
                groupTab = request.getParameter("switchTab");
                if (groupTab == null) {
                    groupTab = "users";
                }
            }
            response.setRenderParameter("groupTab", groupTab);
            if (request.getParameter("group.action.Save") != null) {
                this.addGroup(request);
            } else if (request.getParameter("group.action.Add_New_Group") != null) {
                PortletMessaging.cancel((PortletRequest)request, (String)"groups", (String)"selected");
            } else if (request.getParameter("group.action.Remove_Group") != null) {
                this.removeGroup(request);
            } else if ("users".equals(groupTab)) {
                String users = request.getParameter("users");
                if (users != null && users.length() > 0) {
                    this.addUsersToGroup(request, users);
                } else if (request.getParameter("group.action.Remove_Checked_Users") != null) {
                    this.removeUsersFromGroup(request);
                }
            } else {
                String roles = request.getParameter("roles");
                if (roles != null && roles.length() > 0) {
                    this.addRolesToGroup(request, roles);
                } else if (request.getParameter("group.action.Remove_Checked_Roles") != null) {
                    this.removeRolesFromGroup(request);
                }
            }
            if (request.getParameter("filtered") != null) {
                PortletMessaging.publish((PortletRequest)request, (String)"group", (String)"filtered", (Object)"on");
            } else {
                PortletMessaging.cancel((PortletRequest)request, (String)"group", (String)"filtered");
            }
        }
        super.processAction(request, response);
    }

    protected void addGroup(ActionRequest actionRequest) {
        String group = actionRequest.getParameter("group");
        if (!SecurityUtil.isEmpty((String)group)) {
            try {
                this.groupManager.addGroup(group);
                PortletMessaging.publish((PortletRequest)actionRequest, (String)"groups", (String)"refresh", (Object)"true");
                PortletMessaging.publish((PortletRequest)actionRequest, (String)"groups", (String)"selected", (Object)group);
                PortletMessaging.publish((PortletRequest)actionRequest, (String)"groups", (String)"changed", (Object)group);
                PortletMessaging.publish((PortletRequest)actionRequest, (String)"users", (String)"refresh.groups", (Object)"true");
            }
            catch (NotSerializableException e) {
                e.printStackTrace();
            }
            catch (SecurityException sex) {
                SecurityUtil.publishErrorMessage((PortletRequest)actionRequest, (String)"group", (String)sex.getMessage());
            }
        }
    }

    protected void removeGroup(ActionRequest actionRequest) {
        String group = actionRequest.getParameter("group");
        if (!SecurityUtil.isEmpty((String)group)) {
            try {
                this.groupManager.removeGroup(group);
                try {
                    PortletMessaging.publish((PortletRequest)actionRequest, (String)"groups", (String)"refresh", (Object)"true");
                    PortletMessaging.publish((PortletRequest)actionRequest, (String)"users", (String)"refresh.groups", (Object)"true");
                }
                catch (NotSerializableException e) {
                    e.printStackTrace();
                }
                PortletMessaging.cancel((PortletRequest)actionRequest, (String)"groups", (String)"selected");
            }
            catch (SecurityException sex) {
                SecurityUtil.publishErrorMessage((PortletRequest)actionRequest, (String)"group", (String)sex.getMessage());
            }
        }
    }

    protected void addUsersToGroup(ActionRequest request, String users) {
        String group = request.getParameter("group");
        if (group != null) {
            int count = 0;
            StringTokenizer tokenizer = new StringTokenizer(users, ",");
            while (tokenizer.hasMoreTokens()) {
                String user = tokenizer.nextToken();
                try {
                    if (!user.startsWith("box_")) continue;
                    user = user.substring("box_".length());
                    this.groupManager.addUserToGroup(user, group);
                    ++count;
                }
                catch (SecurityException sex) {
                    SecurityUtil.publishErrorMessage((PortletRequest)request, (String)"group", (String)sex.getMessage());
                }
            }
            if (count > 0) {
                try {
                    PortletMessaging.publish((PortletRequest)request, (String)"group", (String)"refresh", (Object)"true");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void removeUsersFromGroup(ActionRequest request) {
        String group = request.getParameter("group");
        if (group != null) {
            int count = 0;
            Enumeration e = request.getParameterNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (!name.startsWith("box_")) continue;
                String user = name.substring("box_".length());
                try {
                    this.groupManager.removeUserFromGroup(user, group);
                    ++count;
                }
                catch (SecurityException sex) {
                    SecurityUtil.publishErrorMessage((PortletRequest)request, (String)"group", (String)sex.getMessage());
                }
            }
            if (count > 0) {
                try {
                    PortletMessaging.publish((PortletRequest)request, (String)"group", (String)"refresh", (Object)"true");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    protected void addRolesToGroup(ActionRequest request, String roles) {
        String group = request.getParameter("group");
        if (group != null) {
            int count = 0;
            StringTokenizer tokenizer = new StringTokenizer(roles, ",");
            while (tokenizer.hasMoreTokens()) {
                String role = tokenizer.nextToken();
                try {
                    if (!role.startsWith("box_")) continue;
                    role = role.substring("box_".length());
                    this.roleManager.addRoleToGroup(role, group);
                    ++count;
                }
                catch (SecurityException sex) {
                    SecurityUtil.publishErrorMessage((PortletRequest)request, (String)"group", (String)sex.getMessage());
                }
            }
            if (count > 0) {
                try {
                    PortletMessaging.publish((PortletRequest)request, (String)"group", (String)"refresh", (Object)"true");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void removeRolesFromGroup(ActionRequest request) {
        String group = request.getParameter("group");
        if (group != null) {
            int count = 0;
            Enumeration e = request.getParameterNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (!name.startsWith("box_")) continue;
                String role = name.substring("box_".length());
                try {
                    this.roleManager.removeRoleFromGroup(role, group);
                    ++count;
                }
                catch (SecurityException sex) {
                    SecurityUtil.publishErrorMessage((PortletRequest)request, (String)"group", (String)sex.getMessage());
                }
            }
            if (count > 0) {
                try {
                    PortletMessaging.publish((PortletRequest)request, (String)"group", (String)"refresh", (Object)"true");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

