/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.security.groups;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.jetspeed.portlets.security.SecurityUtil;
import org.apache.jetspeed.security.Group;
import org.apache.jetspeed.security.GroupManager;
import org.apache.jetspeed.security.SecurityException;
import org.apache.portals.gems.browser.BrowserIterator;
import org.apache.portals.gems.browser.BrowserPortlet;
import org.apache.portals.gems.browser.DatabaseBrowserIterator;
import org.apache.portals.gems.util.StatusMessage;
import org.apache.portals.messaging.PortletMessaging;
import org.apache.velocity.context.Context;

public class GroupBrowser
extends BrowserPortlet {
    private GroupManager groupManager;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.groupManager = (GroupManager)this.getPortletContext().getAttribute("cps:GroupManager");
        if (null == this.groupManager) {
            throw new PortletException("Failed to find the Group Manager on portlet initialization");
        }
    }

    public void getRows(RenderRequest request, String sql, int windowSize) {
        this.getRows(request, sql, windowSize, "");
    }

    public void getRows(RenderRequest request, String sql, int windowSize, String filter) {
        ArrayList<String> resultSetTitleList = new ArrayList<String>();
        ArrayList<String> resultSetTypeList = new ArrayList<String>();
        resultSetTypeList.add(String.valueOf(12));
        resultSetTitleList.add("group");
        ArrayList<String> list = new ArrayList<String>();
        try {
            Iterator groups = this.groupManager.getGroups(filter);
            while (groups.hasNext()) {
                Group group = (Group)groups.next();
                Principal principal = group.getPrincipal();
                list.add(principal.getName());
            }
        }
        catch (SecurityException sex) {
            SecurityUtil.publishErrorMessage((PortletRequest)request, (String)"groups", (String)sex.getMessage());
        }
        DatabaseBrowserIterator iterator = new DatabaseBrowserIterator(list, resultSetTitleList, resultSetTypeList, windowSize);
        this.setBrowserIterator(request, (BrowserIterator)iterator);
        iterator.sort("group");
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        ArrayList errorMessages;
        String refresh;
        String filtered;
        StatusMessage msg;
        String selected = (String)PortletMessaging.receive((PortletRequest)request, (String)"groups", (String)"selected");
        if (selected != null) {
            Context context = this.getContext(request);
            context.put("selected", (Object)selected);
        }
        if ((msg = (StatusMessage)PortletMessaging.consume((PortletRequest)request, (String)"groups", (String)"status")) != null) {
            this.getContext(request).put("statusMsg", (Object)msg);
        }
        if ((filtered = (String)PortletMessaging.receive((PortletRequest)request, (String)"groups", (String)"filtered")) != null) {
            this.getContext(request).put("filtered", (Object)"on");
        }
        if ((refresh = (String)PortletMessaging.consume((PortletRequest)request, (String)"groups", (String)"refresh")) != null) {
            this.clearBrowserIterator((PortletRequest)request);
        }
        if ((errorMessages = (ArrayList)PortletMessaging.consume((PortletRequest)request, (String)"groups", (String)"errorMessages")) != null) {
            this.getContext(request).put("errorMessages", (Object)errorMessages);
        }
        super.doView(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        String filtered;
        Group group;
        String selected;
        if (request.getPortletMode() == PortletMode.VIEW && (selected = request.getParameter("group")) != null && (group = this.lookupGroup(request, selected)) != null) {
            PortletMessaging.publish((PortletRequest)request, (String)"groups", (String)"selected", (Object)selected);
            PortletMessaging.publish((PortletRequest)request, (String)"groups", (String)"changed", (Object)selected);
        }
        if ((filtered = request.getParameter("filtered")) != null) {
            PortletMessaging.publish((PortletRequest)request, (String)"groups", (String)"filtered", (Object)"on");
        } else {
            PortletMessaging.cancel((PortletRequest)request, (String)"groups", (String)"filtered");
        }
        super.processAction(request, response);
    }

    private Group lookupGroup(ActionRequest actionRequest, String groupName) {
        try {
            return this.groupManager.getGroup(groupName);
        }
        catch (SecurityException sex) {
            SecurityUtil.publishErrorMessage((PortletRequest)actionRequest, (String)"groups", (String)sex.getMessage());
            return null;
        }
    }
}

