/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.security;

import java.io.NotSerializableException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import org.apache.jetspeed.request.RequestContext;
import org.apache.portals.gems.browser.BrowserPortlet;
import org.apache.portals.messaging.PortletMessaging;

public abstract class SecurityUtil
extends BrowserPortlet {
    public static Principal getPrincipal(Subject subject, Class classe) {
        Principal principal = null;
        Iterator<Principal> principals = subject.getPrincipals().iterator();
        while (principals.hasNext()) {
            Principal p = principals.next();
            if (!classe.isInstance(p)) continue;
            principal = p;
            break;
        }
        return principal;
    }

    public static boolean isEmpty(String s) {
        if (s == null) {
            return true;
        }
        return s.trim().equals("");
    }

    public static String getAbsoluteUrl(RenderRequest renderRequest, String relativePath) {
        RequestContext requestContext = (RequestContext)renderRequest.getAttribute("org.apache.jetspeed.request.RequestContext");
        HttpServletRequest request = requestContext.getRequest();
        StringBuffer path = new StringBuffer();
        if (!requestContext.getPortalURL().isRelativeOnly()) {
            path.append(request.getScheme()).append("://").append(request.getServerName()).append(":").append(request.getServerPort());
        }
        return requestContext.getResponse().encodeURL(path.append(request.getContextPath()).append(request.getServletPath()).append(relativePath).toString());
    }

    public static void publishErrorMessage(PortletRequest request, String message) {
        try {
            ArrayList<String> errors = (ArrayList<String>)PortletMessaging.receive((PortletRequest)request, (String)"errorMessages");
            if (errors == null) {
                errors = new ArrayList<String>();
            }
            errors.add(message);
            PortletMessaging.publish((PortletRequest)request, (String)"errorMessages", errors);
        }
        catch (NotSerializableException e) {
            e.printStackTrace();
        }
    }

    public static void publishErrorMessage(PortletRequest request, String topic, String message) {
        try {
            ArrayList<String> errors = (ArrayList<String>)PortletMessaging.receive((PortletRequest)request, (String)topic, (String)"errorMessages");
            if (errors == null) {
                errors = new ArrayList<String>();
            }
            errors.add(message);
            PortletMessaging.publish((PortletRequest)request, (String)topic, (String)"errorMessages", errors);
        }
        catch (NotSerializableException e) {
            e.printStackTrace();
        }
    }
}

