/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.security;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.security.auth.Subject;
import org.apache.jetspeed.audit.AuditActivity;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.InvalidNewPasswordException;
import org.apache.jetspeed.security.InvalidPasswordException;
import org.apache.jetspeed.security.PasswordAlreadyUsedException;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.UserManager;
import org.apache.portals.bridges.common.GenericServletPortlet;

public class ChangePasswordPortlet
extends GenericServletPortlet {
    private UserManager manager;
    private AuditActivity audit;
    public static final String CURRENT_PASSWORD = "currentPassword";
    public static final String NEW_PASSWORD = "newPassword";
    public static final String NEW_PASSWORD_AGAIN = "newPasswordAgain";
    public static final String ERROR_MESSAGES = "errorMessages";
    public static final String PASSWORD_CHANGED = "passwordChanged";
    public static final String WHY = "why";
    public static final String REQUIRED = "required";
    public static final String CANCELLED = "cancelled";

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.manager = (UserManager)this.getPortletContext().getAttribute("cps:UserManager");
        if (null == this.manager) {
            throw new PortletException("Failed to find the User Manager on portlet initialization");
        }
        this.audit = (AuditActivity)this.getPortletContext().getAttribute("cps:AuditActivity");
        if (null == this.audit) {
            throw new PortletException("Failed to find the Audit Activity on portlet initialization");
        }
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        if (request.getUserPrincipal() != null) {
            ArrayList errorMessages;
            RequestContext requestContext = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
            Integer passwordDaysValid = (Integer)requestContext.getAttribute(PasswordCredential.PASSWORD_CREDENTIAL_DAYS_VALID_REQUEST_ATTR_KEY);
            if (passwordDaysValid != null) {
                ResourceBundle bundle = ResourceBundle.getBundle("org.apache.jetspeed.portlets.security.resources.ChgPwdResources", request.getLocale());
                if (passwordDaysValid < 1) {
                    request.setAttribute(WHY, (Object)bundle.getString("chgpwd.message.change.required"));
                    request.setAttribute(REQUIRED, (Object)Boolean.TRUE);
                } else if (passwordDaysValid == 1) {
                    request.setAttribute(WHY, (Object)bundle.getString("chgpwd.message.expires.today"));
                    request.setAttribute(REQUIRED, (Object)Boolean.TRUE);
                } else {
                    MessageFormat mf = new MessageFormat(bundle.getString("chgpwd.message.expires.in.days"));
                    request.setAttribute(WHY, (Object)mf.format(new Integer[]{passwordDaysValid}));
                }
            }
            if ((errorMessages = (ArrayList)request.getPortletSession().getAttribute(ERROR_MESSAGES)) != null) {
                request.getPortletSession().removeAttribute(ERROR_MESSAGES);
                request.setAttribute(ERROR_MESSAGES, (Object)errorMessages);
            } else {
                Boolean password_changed = (Boolean)request.getPortletSession().getAttribute(PASSWORD_CHANGED);
                if (password_changed != null) {
                    request.getPortletSession().removeAttribute(PASSWORD_CHANGED);
                    request.setAttribute(PASSWORD_CHANGED, (Object)password_changed);
                }
            }
        }
        super.doView(request, response);
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        if (actionRequest.getUserPrincipal() != null) {
            ResourceBundle bundle = ResourceBundle.getBundle("org.apache.jetspeed.portlets.security.resources.ChgPwdResources", actionRequest.getLocale());
            ArrayList<String> errorMessages = new ArrayList<String>();
            String cancelled = actionRequest.getParameter(CANCELLED);
            if (cancelled == null) {
                String currPassword = actionRequest.getParameter(CURRENT_PASSWORD);
                String newPassword = actionRequest.getParameter(NEW_PASSWORD);
                String newPasswordAgain = actionRequest.getParameter(NEW_PASSWORD_AGAIN);
                String userName = actionRequest.getUserPrincipal().getName();
                if (currPassword == null || currPassword.length() == 0) {
                    errorMessages.add(bundle.getString("chgpwd.error.currentPasswordNull"));
                    currPassword = null;
                }
                if (newPassword == null || newPassword.length() == 0) {
                    errorMessages.add(bundle.getString("chgpwd.error.newPasswordNull"));
                    newPassword = null;
                }
                if (newPassword != null && newPassword.length() == 0) {
                    newPassword = null;
                }
                if (newPassword != null && (newPasswordAgain == null || newPasswordAgain != null && !newPassword.equals(newPasswordAgain))) {
                    errorMessages.add(bundle.getString("chgpwd.error.newPasswordsDoNotMatch"));
                }
                if (errorMessages.size() == 0) {
                    try {
                        this.manager.setPassword(userName, currPassword, newPassword);
                        this.audit.logUserActivity(userName, this.getIPAddress((PortletRequest)actionRequest), "password-success", "J2 User Administration");
                        Subject subject = this.manager.getUser(userName).getSubject();
                        RequestContext requestContext = (RequestContext)actionRequest.getAttribute("org.apache.jetspeed.request.RequestContext");
                        requestContext.setSessionAttribute("org.apache.jetspeed.security.subject", (Object)subject);
                    }
                    catch (InvalidPasswordException ipe) {
                        errorMessages.add(bundle.getString("chgpwd.error.invalidPassword"));
                    }
                    catch (InvalidNewPasswordException inpe) {
                        errorMessages.add(bundle.getString("chgpwd.error.invalidNewPassword"));
                    }
                    catch (PasswordAlreadyUsedException paue) {
                        errorMessages.add(bundle.getString("chgpwd.error.passwordAlreadyUsed"));
                    }
                    catch (SecurityException e) {
                        errorMessages.add(e.getMessage());
                    }
                }
                if (errorMessages.size() > 0) {
                    actionRequest.getPortletSession().setAttribute(ERROR_MESSAGES, errorMessages);
                    this.audit.logUserActivity(userName, this.getIPAddress((PortletRequest)actionRequest), "password-failure", errorMessages.toString());
                } else {
                    actionRequest.getPortletSession().setAttribute(PASSWORD_CHANGED, (Object)Boolean.TRUE);
                }
            }
        }
    }

    protected String getIPAddress(PortletRequest request) {
        RequestContext context = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
        if (context == null) {
            return "";
        }
        return context.getRequest().getRemoteAddr();
    }
}

