/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.rpad.portlet.web.deployer;

import java.util.Map;
import javax.faces.context.FacesContext;
import org.apache.jetspeed.portlets.rpad.RPADException;
import org.apache.jetspeed.portlets.rpad.Repository;
import org.apache.jetspeed.portlets.rpad.RepositoryManager;
import org.apache.jetspeed.portlets.rpad.portlet.util.FacesMessageUtil;
import org.apache.jetspeed.portlets.rpad.simple.SimpleRepository;

public class EditRepositoryPage {
    private RepositoryManager repositoryManager = null;
    private boolean newRepository;
    private String name;
    private String path;

    public EditRepositoryPage() {
        Map sessionMap = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
        Repository repo = (Repository)sessionMap.get("org.apache.jetspeed.portlets.rpad.Repository");
        if (repo != null) {
            if (repo instanceof SimpleRepository) {
                SimpleRepository simpleRepo = (SimpleRepository)repo;
                this.newRepository = false;
                this.setName(simpleRepo.getName());
                this.setPath(simpleRepo.getConfigPath());
            } else {
                this.newRepository = true;
                sessionMap.remove("org.apache.jetspeed.portlets.rpad.Repository");
            }
        } else {
            this.newRepository = true;
        }
    }

    public RepositoryManager getRepositoryManager() {
        if (this.repositoryManager == null) {
            this.repositoryManager = RepositoryManager.getInstance();
        }
        return this.repositoryManager;
    }

    public String jumpDisplayRepositories() {
        return "deployer_displayRepositories";
    }

    public String doCreateRepository() {
        if (this.getRepositoryManager().getRepository(this.getName()) == null) {
            SimpleRepository repo = new SimpleRepository();
            repo.setName(this.getName());
            repo.setConfigPath(this.getPath());
            repo.init();
            try {
                this.getRepositoryManager().addRepository(this.getName(), (Repository)repo);
                this.getRepositoryManager().reload();
                FacesMessageUtil.addInfoMessage((String)(this.getName() + " exits."));
                return "deployer_displayRepositories";
            }
            catch (RPADException e) {
                FacesMessageUtil.addErrorMessage((String)("Could not add a repository: " + this.getName()));
            }
        } else {
            FacesMessageUtil.addWarnMessage((String)(this.getName() + " exits."));
        }
        return null;
    }

    public String doUpdateRepository() {
        Map sessionMap = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
        Repository repo = (Repository)sessionMap.get("org.apache.jetspeed.portlets.rpad.Repository");
        if (repo != null) {
            Repository r = this.getRepositoryManager().getRepository(repo.getName());
            if (r instanceof SimpleRepository) {
                SimpleRepository simpleRepo = (SimpleRepository)r;
                simpleRepo.setName(this.getName());
                simpleRepo.setConfigPath(this.getPath());
            } else {
                FacesMessageUtil.addWarnMessage((String)"Could not get the proper repository.");
            }
            try {
                this.getRepositoryManager().store();
                this.getRepositoryManager().reload();
                FacesMessageUtil.addWarnMessage((String)"Could not get the proper repository.");
                return null;
            }
            catch (RPADException e) {
                FacesMessageUtil.addErrorMessage((String)"Could not update the target repository.");
            }
        } else {
            FacesMessageUtil.addWarnMessage((String)"Your session might be expired.");
        }
        return "deployer_displayRepositories";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isNewRepository() {
        return this.newRepository;
    }

    public void setNewRepository(boolean newRepository) {
        this.newRepository = newRepository;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

