/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.rpad.portlet.web.deployer;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.jetspeed.portlets.rpad.PortletApplication;
import org.apache.jetspeed.portlets.rpad.Repository;
import org.apache.jetspeed.portlets.rpad.RepositoryManager;
import org.apache.jetspeed.portlets.rpad.portlet.deployer.PortletDeployer;
import org.apache.jetspeed.portlets.rpad.portlet.util.FacesMessageUtil;

public class DisplayPortletsPage {
    protected static final String SEARCH = "org.apache.jetspeed.portlets.rpad.portlet.web.deployer.Search";
    protected static final String REPOSITORY_NAME = "org.apache.jetspeed.portlets.rpad.portlet.web.deployer.RepositoryNamee";
    private String repositoryName = null;
    private String search = null;
    private RepositoryManager repositoryManager = null;
    private PortletDeployer portletDeployer;

    public DisplayPortletsPage() {
        String search;
        Map sessionMap = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
        String repositoryName = (String)sessionMap.get(REPOSITORY_NAME);
        if (repositoryName != null) {
            this.repositoryName = repositoryName;
        }
        if ((search = (String)sessionMap.get(SEARCH)) != null) {
            this.search = search;
        }
    }

    public RepositoryManager getRepositoryManager() {
        if (this.repositoryManager == null) {
            this.repositoryManager = RepositoryManager.getInstance();
        }
        return this.repositoryManager;
    }

    public String doSearch() {
        Map sessionMap = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
        if (this.getRepositoryName() != null && !this.getRepositoryName().equals("")) {
            sessionMap.put(REPOSITORY_NAME, this.getRepositoryName());
        } else {
            sessionMap.remove(REPOSITORY_NAME);
        }
        if (this.getSearch() != null && !this.getSearch().equals("")) {
            sessionMap.put(SEARCH, this.getSearch());
        } else {
            sessionMap.remove(SEARCH);
        }
        return null;
    }

    public String jumpUpdateRepository() {
        return "deployer_displayRepositories";
    }

    public String doRefresh() {
        return null;
    }

    public String doDeploy() {
        PortletApplication portlet = (PortletApplication)FacesContext.getCurrentInstance().getExternalContext().getRequestMap().get("portlet");
        if (portlet != null) {
            if (this.getPortletDeployer() != null) {
                this.getPortletDeployer().deploy(portlet);
            } else {
                FacesMessageUtil.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Could not find the portlet deployer.", null);
            }
        } else {
            FacesMessageUtil.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Could not find the target portlet.", null);
        }
        return null;
    }

    public SelectItem[] getRepositoryNames() {
        List repos = this.getRepositoryManager().getRepositories();
        SelectItem[] items = new SelectItem[repos.size() + 1];
        items[0] = new SelectItem((Object)"");
        int c = 1;
        Iterator i = repos.iterator();
        while (i.hasNext()) {
            Repository repo = (Repository)i.next();
            items[c] = new SelectItem((Object)repo.getName());
            ++c;
        }
        return items;
    }

    public List getPortlets() {
        if (this.repositoryName != null) {
            return this.getRepositoryManager().getPortletApplications(this.repositoryName);
        }
        return this.getRepositoryManager().getPortletApplications();
    }

    public int getPageSize() {
        return 10;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public String getSearch() {
        return this.search;
    }

    public void setSearch(String search) {
        this.search = search;
    }

    public PortletDeployer getPortletDeployer() {
        return this.portletDeployer;
    }

    public void setPortletDeployer(PortletDeployer portletDeployer) {
        this.portletDeployer = portletDeployer;
    }

    public boolean isDeployable() {
        return this.portletDeployer.getStatus() == 0;
    }
}

