/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.rpad.portlet;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.portlets.rpad.RPADException;
import org.apache.jetspeed.portlets.rpad.RepositoryManager;
import org.apache.portals.bridges.portletfilter.PortletFilter;
import org.apache.portals.bridges.portletfilter.PortletFilterChain;
import org.apache.portals.bridges.portletfilter.PortletFilterConfig;

public class RPADPortletFilter
implements PortletFilter {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$portlets$rpad$portlet$RPADPortletFilter == null ? (class$org$apache$jetspeed$portlets$rpad$portlet$RPADPortletFilter = RPADPortletFilter.class$((String)"org.apache.jetspeed.portlets.rpad.portlet.RPADPortletFilter")) : class$org$apache$jetspeed$portlets$rpad$portlet$RPADPortletFilter));
    protected static final String CONFIG_FILE = "config-file";
    protected static final String DEFAULT_CONFIG_FILE = "/WEB-INF/rpad-config.xml";
    protected static final String WEBAPP_ROOT_PREFIX = "${webapp}";
    static /* synthetic */ Class class$org$apache$jetspeed$portlets$rpad$portlet$RPADPortletFilter;

    public void destroy() {
        try {
            RepositoryManager.getInstance().store();
        }
        catch (RPADException e) {
            log.error((Object)"Could not store the configuration.", (Throwable)e);
        }
    }

    public void init(PortletFilterConfig filterConfig) throws PortletException {
        PortletConfig portletConfig = filterConfig.getPortletConfig();
        PortletContext portletContext = portletConfig.getPortletContext();
        String configFile = portletConfig.getInitParameter(CONFIG_FILE);
        if (configFile == null) {
            configFile = portletContext.getRealPath(DEFAULT_CONFIG_FILE);
        } else if (configFile.startsWith(WEBAPP_ROOT_PREFIX)) {
            configFile = portletContext.getRealPath(configFile.substring(WEBAPP_ROOT_PREFIX.length()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("init(PortletConfig) - configFile=" + configFile));
        }
        try {
            RepositoryManager.init((String)configFile);
        }
        catch (Exception e) {
            throw new PortletException("Could not create RepositoryManager. The config file is " + configFile, (Throwable)e);
        }
    }

    public void processActionFilter(ActionRequest request, ActionResponse response, PortletFilterChain chain) throws PortletException, IOException {
        chain.processActionFilter(request, response);
    }

    public void renderFilter(RenderRequest request, RenderResponse response, PortletFilterChain chain) throws PortletException, IOException {
        chain.renderFilter(request, response);
    }
}

