/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.rpad;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.portlets.rpad.RPADException;
import org.apache.jetspeed.portlets.rpad.Repository;
import org.apache.jetspeed.portlets.rpad.RepositoryConfigHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RepositoryManager {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$portlets$rpad$RepositoryManager == null ? (class$org$apache$jetspeed$portlets$rpad$RepositoryManager = RepositoryManager.class$((String)"org.apache.jetspeed.portlets.rpad.RepositoryManager")) : class$org$apache$jetspeed$portlets$rpad$RepositoryManager));
    private String configFileName;
    private Map repositories;
    private static RepositoryManager repositoryManager;
    static /* synthetic */ Class class$org$apache$jetspeed$portlets$rpad$RepositoryManager;

    public static void init(String configFileName) throws RPADException {
        repositoryManager = new RepositoryManager(configFileName);
    }

    public static RepositoryManager getInstance() {
        if (repositoryManager == null) {
            throw new IllegalStateException("init() needs to be called before getInstance().");
        }
        return repositoryManager;
    }

    public RepositoryManager(String configFileName) throws RPADException {
        this.configFileName = configFileName;
        this.load();
    }

    protected void load() throws RPADException {
        try {
            SAXParserFactory spfactory = SAXParserFactory.newInstance();
            SAXParser parser = spfactory.newSAXParser();
            RepositoryConfigHandler repoConfigHandler = new RepositoryConfigHandler();
            parser.parse(new File(this.configFileName), (DefaultHandler)repoConfigHandler);
            this.repositories = repoConfigHandler.getRepositories();
        }
        catch (ParserConfigurationException e) {
            throw new RPADException("Could not configure a parser.", (Throwable)e);
        }
        catch (SAXException e) {
            throw new RPADException("An exception occurrs on SAX parser.", (Throwable)e);
        }
        catch (IOException e) {
            throw new RPADException("An exception occurrs when accessing a configuration file: " + this.configFileName, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() throws RPADException {
        Map map = this.repositories;
        synchronized (map) {
            this.load();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRepository(String name, Repository repository) throws RPADException {
        Map map = this.repositories;
        synchronized (map) {
            if (this.repositories.containsKey(name)) {
                throw new RPADException(name + "exists.");
            }
            this.repositories.put(name, repository);
            this.store();
        }
    }

    public Repository getRepository(String name) {
        return (Repository)this.repositories.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRepository(String name) throws RPADException {
        Map map = this.repositories;
        synchronized (map) {
            if (!this.repositories.containsKey(name)) {
                throw new RPADException(name + "does not exist.");
            }
            this.repositories.remove(name);
            this.store();
        }
    }

    public List getRepositories() {
        return new ArrayList(this.repositories.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() throws RPADException {
        Map map = this.repositories;
        synchronized (map) {
            BufferedWriter writer = null;
            try {
                try {
                    writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.configFileName), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.configFileName)));
                }
                writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                writer.write("<repositories>\n");
                Iterator i = this.repositories.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Storing a repository: " + entry.getKey()));
                    }
                    Repository repo = (Repository)entry.getValue();
                    writer.write(repo.toXMLString());
                }
                writer.write("</repositories>\n");
                writer.flush();
            }
            catch (FileNotFoundException e) {
                throw new RPADException("Could not find " + this.configFileName, (Throwable)e);
            }
            catch (IOException e) {
                throw new RPADException("Could not write " + this.configFileName, (Throwable)e);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    public List getPortletApplications() {
        ArrayList list = new ArrayList();
        Iterator i = this.repositories.entrySet().iterator();
        while (i.hasNext()) {
            List portlets;
            Map.Entry entry = i.next();
            Repository repo = (Repository)entry.getValue();
            if (!repo.isAvailable() || (portlets = repo.getPortletApplications()) == null) continue;
            list.addAll(portlets);
        }
        return list;
    }

    public List getPortletApplications(String name) {
        List portlets;
        ArrayList list = new ArrayList();
        Repository repo = this.getRepository(name);
        if (repo != null && repo.isAvailable() && (portlets = repo.getPortletApplications()) != null) {
            list.addAll(portlets);
        }
        return list;
    }
}

