/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.registration;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.jetspeed.administration.AdministrationEmailException;
import org.apache.jetspeed.administration.PortalAdministration;
import org.apache.jetspeed.locator.JetspeedTemplateLocator;
import org.apache.jetspeed.locator.LocatorDescriptor;
import org.apache.jetspeed.locator.TemplateDescriptor;
import org.apache.jetspeed.locator.TemplateLocatorException;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.security.UserPrincipal;
import org.apache.portals.bridges.velocity.AbstractVelocityMessagingPortlet;
import org.apache.portals.gems.util.ValidationHelper;
import org.apache.velocity.context.Context;

/*
 * Exception performing whole class analysis ignored.
 */
public class ForgottenPasswordPortlet
extends AbstractVelocityMessagingPortlet {
    private PortalAdministration admin;
    private UserManager userManager;
    private static final String RP_EMAIL_ADDRESS = "email";
    private static final String MSG_MESSAGE = "MSG";
    private static final String MSG_CHANGEDPW_MSG = "CH_PWD_MSD";
    private static final String CTX_EMAIL_ADDRESS = "email";
    private static final String CTX_RETURN_URL = "returnURL";
    private static final String CTX_NEW_PASSWORD = "password";
    private static final String CTX_USER_NAME = "username";
    private static final String CTX_MESSAGE = "MSG";
    private static final String CTX_CHANGEDPW_MSG = "updatedPWMsg";
    private static final String IP_REDIRECT_PATH = "redirectPath";
    private static final String IP_RETURN_URL = "returnURL";
    private static final String IP_TEMPLATE_LOCATION = "emailTemplateLocation";
    private static final String IP_TEMPLATE_NAME = "emailTemplateName";
    private static final String RB_EMAIL_SUBJECT = "email.subject.forgotten.password";
    private static final String PATH_SEPARATOR = "/";
    private String templateLocation;
    private String templateName;
    private JetspeedTemplateLocator templateLocator;
    private String returnUrlPath;
    private String redirectPath;
    private String emailSubject = null;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.admin = (PortalAdministration)this.getPortletContext().getAttribute("cps:PortalAdministration");
        if (null == this.admin) {
            throw new PortletException("Failed to find the Portal Administration on portlet initialization");
        }
        this.userManager = (UserManager)this.getPortletContext().getAttribute("cps:UserManager");
        if (null == this.userManager) {
            throw new PortletException("Failed to find the User Manager on portlet initialization");
        }
        this.returnUrlPath = config.getInitParameter("returnURL");
        this.redirectPath = config.getInitParameter("redirectPath");
        this.templateLocation = config.getInitParameter("emailTemplateLocation");
        if (this.templateLocation == null) {
            this.templateLocation = "/WEB-INF/view/userreg/";
        }
        this.templateLocation = this.getPortletContext().getRealPath(this.templateLocation);
        this.templateName = config.getInitParameter("emailTemplateName");
        if (this.templateName == null) {
            this.templateName = "forgottenPasswdEmail.vm";
        }
        ArrayList<String> roots = new ArrayList<String>(1);
        roots.add(this.templateLocation);
        try {
            this.templateLocator = new JetspeedTemplateLocator(roots, "email", this.getPortletContext().getRealPath("/"));
            this.templateLocator.start();
        }
        catch (FileNotFoundException e) {
            throw new PortletException("Could not start the template locator.", (Throwable)e);
        }
    }

    private boolean isValidGUID(String guid) {
        Map map = this.admin.getNewLoginInfo(guid);
        return map != null;
    }

    private boolean updatePasswordFromGUID(String guid) {
        Map map = this.admin.getNewLoginInfo(guid);
        String userName = (String)map.get("user.name");
        String newPassword = (String)map.get("password");
        try {
            this.userManager.setPassword(userName, null, newPassword);
            this.userManager.setPasswordUpdateRequired(userName, true);
            this.admin.removeNewLoginInfo(guid);
        }
        catch (SecurityException e) {
            return false;
        }
        return true;
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        Context context = this.getContext(request);
        String email = request.getParameter("email");
        String guid = request.getParameter("guid");
        ResourceBundle resource = this.getPortletConfig().getResourceBundle(request.getLocale());
        if (guid != null) {
            if (this.isValidGUID(guid)) {
                try {
                    this.updatePasswordFromGUID(guid);
                    context.put("updatedPWMsg", (Object)resource.getString("forgotten.successful_pw_update"));
                }
                catch (Exception e) {
                    context.put("MSG", (Object)resource.getString("forgotten.unable_to_update_pw"));
                }
            } else {
                context.put("updatedPWMsg", (Object)resource.getString("forgotten.password_update_link_invalid"));
            }
        } else {
            context.put("updatedPWMsg", this.consumeRenderMessage((PortletRequest)request, "CH_PWD_MSD"));
        }
        context.put("email", (Object)email);
        context.put("MSG", this.consumeRenderMessage((PortletRequest)request, "MSG"));
        super.doView(request, response);
    }

    public static String makeGUID(String user, String newpw) {
        long num = (long)user.hashCode() + (long)newpw.hashCode();
        long d = new Date().getTime();
        long val = num * d;
        String retval = Long.toHexString(val);
        return retval;
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        LinkedList<String> errors = new LinkedList<String>();
        String email = request.getParameter("email");
        Locale locale = request.getLocale();
        ResourceBundle resource = this.getPortletConfig().getResourceBundle(locale);
        if (!ValidationHelper.isEmailAddress((String)email, (boolean)true, (int)80)) {
            errors.add(resource.getString("forgotten.invalid_email_format_entered"));
        }
        if (errors.size() > 0) {
            this.publishRenderMessage((PortletRequest)request, "MSG", errors);
            return;
        }
        User user = null;
        try {
            user = this.admin.lookupUserFromEmail(email);
        }
        catch (Exception e) {
            this.publishRenderMessage((PortletRequest)request, "MSG", (Object)this.makeMessage(resource.getString("forgotten.email_address_not_found")));
            return;
        }
        try {
            String userName = this.getUserName(user);
            String newPassword = this.admin.generatePassword();
            String urlGUID = ForgottenPasswordPortlet.makeGUID((String)userName, (String)newPassword);
            Preferences pref = user.getUserAttributes();
            String[] keys = pref.keys();
            HashMap<String, String> userAttributes = new HashMap<String, String>();
            if (keys != null) {
                for (int ix = 0; ix < keys.length; ++ix) {
                    userAttributes.put(keys[ix], pref.get(keys[ix], ""));
                }
            }
            userAttributes.put("returnURL", this.generateReturnURL((PortletRequest)request, (PortletResponse)response, urlGUID));
            userAttributes.put("password", newPassword);
            userAttributes.put("username", userName);
            String templ = this.getTemplatePath(request, response);
            if (templ == null) {
                throw new Exception("email template not available");
            }
            this.admin.sendEmail(this.getPortletConfig(), email, this.getEmailSubject((PortletRequest)request), templ, userAttributes);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("user.name", userName);
            map.put("password", newPassword);
            this.admin.putNewLoginInfo(urlGUID, map);
            this.publishRenderMessage((PortletRequest)request, "CH_PWD_MSD", (Object)this.makeMessage(resource.getString("an_email_has_been_sent")));
            response.sendRedirect(this.generateRedirectURL((PortletRequest)request, (PortletResponse)response));
        }
        catch (AdministrationEmailException e) {
            this.publishRenderMessage((PortletRequest)request, "MSG", (Object)this.makeMessage(e.getMessage()));
        }
        catch (Exception e) {
            this.publishRenderMessage((PortletRequest)request, "MSG", (Object)this.makeMessage(resource.getString("failed_to_send") + e.toString()));
        }
    }

    protected String getEmailSubject(PortletRequest request) {
        ResourceBundle resource = this.getPortletConfig().getResourceBundle(request.getLocale());
        try {
            this.emailSubject = resource.getString("email.subject.forgotten.password");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.emailSubject == null) {
            this.emailSubject = "Password Notification";
        }
        return this.emailSubject;
    }

    protected String generateReturnURL(PortletRequest request, PortletResponse response, String urlGUID) {
        String fullPath = this.returnUrlPath + "?guid=" + urlGUID;
        String url = this.admin.getPortalURL(request, response, fullPath);
        return url;
    }

    protected String generateRedirectURL(PortletRequest request, PortletResponse response) {
        return this.admin.getPortalURL(request, response, this.redirectPath);
    }

    protected String getUserName(User user) {
        Principal principal = null;
        Iterator<Principal> principals = user.getSubject().getPrincipals().iterator();
        while (principals.hasNext()) {
            Principal o = principals.next();
            if (!(o instanceof UserPrincipal)) continue;
            principal = o;
            return ((Object)principal).toString();
        }
        return null;
    }

    protected String getPassword(User user) {
        PasswordCredential credential = null;
        Set<Object> credentials = user.getSubject().getPrivateCredentials();
        Iterator<Object> iter = credentials.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof PasswordCredential)) continue;
            credential = (PasswordCredential)o;
            char[] charar = credential.getPassword();
            return new String(charar);
        }
        return null;
    }

    protected List makeMessage(String msg) {
        LinkedList<String> errors = new LinkedList<String>();
        errors.add(msg);
        return errors;
    }

    protected String getTemplatePath(ActionRequest request, ActionResponse response) {
        if (this.templateLocator == null) {
            return this.templateLocation + "/" + this.templateName;
        }
        RequestContext requestContext = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
        Locale locale = request.getLocale();
        try {
            LocatorDescriptor locator = this.templateLocator.createLocatorDescriptor("email");
            locator.setName(this.templateName);
            locator.setMediaType(requestContext.getMediaType());
            locator.setLanguage(locale.getLanguage());
            locator.setCountry(locale.getCountry());
            TemplateDescriptor template = this.templateLocator.locateTemplate(locator);
            return template.getAppRelativePath();
        }
        catch (TemplateLocatorException e) {
            return this.templateLocation + "/" + this.templateName;
        }
    }
}

