/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.profiler;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.model.SelectItem;
import org.apache.jetspeed.profiler.Profiler;
import org.apache.jetspeed.profiler.ProfilerException;
import org.apache.jetspeed.profiler.rules.ProfilingRule;

public class ProfileRuleForm
implements Serializable {
    private boolean isNew = false;
    private transient Profiler profiler = null;
    private transient ProfilingRule rule = null;
    private static final SelectItem[] CLASSNAMES = new SelectItem[]{new SelectItem((Object)"org.apache.jetspeed.profiler.rules.impl.StandardProfilingRule"), new SelectItem((Object)"org.apache.jetspeed.profiler.rules.impl.RoleFallbackProfilingRule")};

    public boolean getUpdating() {
        return !this.isNew;
    }

    public void listen(ActionEvent event) {
        Map appMap = FacesContext.getCurrentInstance().getExternalContext().getApplicationMap();
        this.profiler = (Profiler)appMap.get("cps:Profiler");
        Map params = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap();
        String selected = (String)params.get("selectedRule");
        if (selected != null && this.profiler != null) {
            this.rule = this.profiler.getRule(selected);
            this.isNew = false;
        }
    }

    public SelectItem[] getClassnames() {
        return CLASSNAMES;
    }

    public String getTitle() {
        if (this.rule == null) {
            return "{empty}";
        }
        return this.rule.getTitle();
    }

    public void setTitle(String title) {
        if (this.rule != null) {
            this.rule.setTitle(title);
        }
    }

    public String getClassname() {
        if (this.rule == null) {
            return "{empty}";
        }
        return this.rule.getClassname();
    }

    public void setClassname(String classname) {
        if (this.rule != null) {
            this.rule.setClassname(classname);
        }
    }

    public String getId() {
        if (this.rule == null) {
            return "{empty}";
        }
        return this.rule.getId();
    }

    public void setId(String id) {
        if (this.rule != null) {
            this.rule.setId(id);
        }
    }

    public String saveProfile() {
        try {
            this.profiler.storeProfilingRule(this.rule);
            this.isNew = false;
        }
        catch (ProfilerException e) {
            System.out.println("Failed to UPDATE: rule = " + this.rule.getId());
        }
        return null;
    }

    public String removeProfile() {
        try {
            this.profiler.deleteProfilingRule(this.rule);
        }
        catch (ProfilerException e) {
            System.out.println("Failed to REMOVE: rule = " + this.rule.getId());
        }
        return null;
    }

    public String createNewProfile() {
        try {
            Class<?> defaultClass = this.profiler.getClass().getClassLoader().loadClass("org.apache.jetspeed.profiler.rules.impl.StandardProfilingRule");
            this.rule = (ProfilingRule)defaultClass.newInstance();
        }
        catch (Exception e) {
            System.out.println("Failed to CREATE NEW: rule = " + this.rule.getId());
        }
        this.setId("");
        this.setTitle("");
        this.setClassname("org.apache.jetspeed.profiler.rules.impl.StandardProfilingRule");
        this.isNew = true;
        return null;
    }

    public Collection getCriteria() {
        return this.rule.getRuleCriteria();
    }
}

