/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.profiler;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.model.SelectItem;
import org.apache.jetspeed.profiler.Profiler;
import org.apache.jetspeed.profiler.rules.ProfilingRule;
import org.apache.jetspeed.profiler.rules.RuleCriterion;

public class ProfileCriterionForm
implements Serializable {
    private boolean isNew = false;
    private transient Profiler profiler = null;
    private transient RuleCriterion criterion = null;
    private transient ProfilingRule rule = null;
    private static final String FALLBACK_CONTINUE = "Continue";
    private static final String FALLBACK_STOP = "Stop";
    private static final String FALLBACK_LOOP = "Loop";
    private static final SelectItem[] RESOLVERS = new SelectItem[]{new SelectItem((Object)"request"), new SelectItem((Object)"session"), new SelectItem((Object)"request.session"), new SelectItem((Object)"hard.coded"), new SelectItem((Object)"group.role.user"), new SelectItem((Object)"user"), new SelectItem((Object)"group"), new SelectItem((Object)"role"), new SelectItem((Object)"mediatype"), new SelectItem((Object)"country"), new SelectItem((Object)"language"), new SelectItem((Object)"roles"), new SelectItem((Object)"path"), new SelectItem((Object)"page"), new SelectItem((Object)"path.session"), new SelectItem((Object)"user.attribute"), new SelectItem((Object)"navigation"), new SelectItem((Object)"ip"), new SelectItem((Object)"hostname")};
    private static final SelectItem[] FALLBACK_TYPES = new SelectItem[]{new SelectItem((Object)"Continue"), new SelectItem((Object)"Loop"), new SelectItem((Object)"Stop")};

    public boolean getUpdating() {
        return !this.isNew;
    }

    public SelectItem[] getResolvers() {
        return RESOLVERS;
    }

    public SelectItem[] getFallbackTypes() {
        return FALLBACK_TYPES;
    }

    public void listen(ActionEvent event) {
        Map appMap = FacesContext.getCurrentInstance().getExternalContext().getApplicationMap();
        this.profiler = (Profiler)appMap.get("cps:Profiler");
        Map params = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap();
        String selectedRule = (String)params.get("selectedRule");
        if (selectedRule != null && this.profiler != null) {
            this.rule = this.profiler.getRule(selectedRule);
            if (this.rule != null) {
                String selected = (String)params.get("selectedCriterion");
                if (selected == null || selected.length() == 0) {
                    this.isNew = true;
                    try {
                        this.criterion = this.profiler.createRuleCriterion();
                    }
                    catch (Exception e) {
                        System.out.println("Failed to CREATE NEW: rule = " + this.rule.getId());
                    }
                } else {
                    Iterator it = this.rule.getRuleCriteria().iterator();
                    while (it.hasNext()) {
                        RuleCriterion c = (RuleCriterion)it.next();
                        if (!c.getName().equals(selected)) continue;
                        this.criterion = c;
                        this.isNew = false;
                        break;
                    }
                }
            }
        }
    }

    public String getName() {
        if (this.criterion == null) {
            return "{empty}";
        }
        return this.criterion.getName();
    }

    public void setName(String name) {
        if (this.criterion != null) {
            this.criterion.setName(name);
        }
    }

    public String getValue() {
        if (this.criterion == null) {
            return "{empty}";
        }
        return this.criterion.getValue();
    }

    public void setValue(String value) {
        if (this.criterion != null) {
            this.criterion.setValue(value);
        }
    }

    public String getResolver() {
        if (this.criterion == null) {
            return "{empty}";
        }
        return this.criterion.getType();
    }

    public void setResolver(String resolver) {
        if (this.criterion != null) {
            this.criterion.setType(resolver);
        }
    }

    public int getFallbackOrder() {
        if (this.criterion == null) {
            return 0;
        }
        return this.criterion.getFallbackOrder();
    }

    public void setFallbackOrder(int order) {
        if (this.criterion != null) {
            this.criterion.setFallbackOrder(order);
        }
    }

    public String getFallbackType() {
        if (this.criterion == null) {
            return FALLBACK_CONTINUE;
        }
        int type = this.criterion.getFallbackType();
        switch (type) {
            case 1: {
                return FALLBACK_CONTINUE;
            }
            case 2: {
                return FALLBACK_LOOP;
            }
        }
        return FALLBACK_STOP;
    }

    public void setFallbackType(String type) {
        if (this.criterion != null) {
            if (type.equals(FALLBACK_CONTINUE)) {
                this.criterion.setFallbackType(1);
            } else if (type.equals(FALLBACK_LOOP)) {
                this.criterion.setFallbackType(2);
            } else {
                this.criterion.setFallbackType(0);
            }
        }
    }

    public String saveCriterion() {
        try {
            String value;
            if (this.isNew) {
                this.criterion.setRuleId(this.rule.getId());
                this.rule.getRuleCriteria().add(this.criterion);
            }
            if ((value = this.criterion.getValue()) != null && (value = value.trim()).equals("")) {
                this.criterion.setValue(null);
            }
            this.profiler.storeProfilingRule(this.rule);
            this.isNew = false;
        }
        catch (Exception e) {
            System.out.println("Failed to UPDATE: rule = " + this.rule.getId());
            return "gotoCriterionForm";
        }
        return "returnFromCriterion";
    }

    public String removeCriterion() {
        try {
            if (!this.isNew) {
                this.rule.getRuleCriteria().remove(this.criterion);
                this.profiler.storeProfilingRule(this.rule);
                this.isNew = true;
            }
        }
        catch (Exception e) {
            System.out.println("Failed to UPDATE: rule = " + this.rule.getId());
            return "gotoCriterionForm";
        }
        return "returnFromCriterion";
    }
}

