/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.pam;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.jetspeed.components.portletregistry.FailedToStorePortletDefinitionException;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.components.portletregistry.RegistryException;
import org.apache.jetspeed.om.common.GenericMetadata;
import org.apache.jetspeed.om.common.LocalizedField;
import org.apache.jetspeed.om.common.MutableDescription;
import org.apache.jetspeed.om.common.MutableDisplayName;
import org.apache.jetspeed.om.common.MutableLanguage;
import org.apache.jetspeed.om.common.ParameterComposite;
import org.apache.jetspeed.om.common.SecurityRoleRefComposite;
import org.apache.jetspeed.om.common.UserAttribute;
import org.apache.jetspeed.om.common.portlet.MutablePortletApplication;
import org.apache.jetspeed.om.common.portlet.PortletApplication;
import org.apache.jetspeed.om.common.portlet.PortletDefinitionComposite;
import org.apache.jetspeed.om.common.preference.PreferenceComposite;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.portlets.pam.beans.PortletApplicationBean;
import org.apache.jetspeed.search.SearchEngine;
import org.apache.pluto.om.common.SecurityRoleRef;
import org.apache.pluto.om.portlet.ContentType;
import org.apache.pluto.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.apache.portals.bridges.beans.TabBean;
import org.apache.portals.bridges.common.GenericServletPortlet;

public class PortletApplicationDetail
extends GenericServletPortlet {
    private static final String PORTLET_ACTION = "portlet_action";
    private final String VIEW_PA = "portletApplication";
    private final String VIEW_PD = "portletDefinition";
    private static final String PORTLET_APP_ACTION_PREFIX = "portlet_app.";
    private static final String PORTLET_ACTION_PREFIX = "portlet.";
    private PortletContext context;
    private PortletRegistry registry;
    private PageManager pageManager;
    private SearchEngine searchEngine;
    private LinkedHashMap paTabMap = new LinkedHashMap();
    private LinkedHashMap pdTabMap = new LinkedHashMap();

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.context = this.getPortletContext();
        this.registry = (PortletRegistry)this.context.getAttribute("cps:PortletRegistryComponent");
        this.searchEngine = (SearchEngine)this.context.getAttribute("cps:SearchComponent");
        this.pageManager = (PageManager)this.context.getAttribute("cps:PageManager");
        if (null == this.registry) {
            throw new PortletException("Failed to find the Portlet Registry on portlet initialization");
        }
        TabBean tb1 = new TabBean("pa_details");
        TabBean tb2 = new TabBean("pa_metadata");
        TabBean tb3 = new TabBean("pa_portlets");
        TabBean tb4 = new TabBean("pa_user_attribtues");
        this.paTabMap.put(tb1.getId(), tb1);
        this.paTabMap.put(tb2.getId(), tb2);
        this.paTabMap.put(tb3.getId(), tb3);
        this.paTabMap.put(tb4.getId(), tb4);
        TabBean tb_1 = new TabBean("pd_details");
        TabBean tb_2 = new TabBean("pd_metadata");
        TabBean tb_3 = new TabBean("pd_preferences");
        TabBean tb_4 = new TabBean("pd_languages");
        TabBean tb_5 = new TabBean("pd_parameters");
        TabBean tb_6 = new TabBean("pd_security");
        TabBean tb_7 = new TabBean("pd_content_type");
        this.pdTabMap.put(tb_1.getId(), tb_1);
        this.pdTabMap.put(tb_2.getId(), tb_2);
        this.pdTabMap.put(tb_3.getId(), tb_3);
        this.pdTabMap.put(tb_4.getId(), tb_4);
        this.pdTabMap.put(tb_5.getId(), tb_5);
        this.pdTabMap.put(tb_6.getId(), tb_6);
        this.pdTabMap.put(tb_7.getId(), tb_7);
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        String paName = (String)request.getPortletSession().getAttribute("org.apache.jetspeed.pam.pa", 1);
        MutablePortletApplication pa = this.registry.getPortletApplication(paName);
        if (null != pa) {
            request.setAttribute("portletApplication", (Object)new PortletApplicationBean((PortletApplication)pa));
            String pdefName = (String)request.getPortletSession().getAttribute("select_portlet", 1);
            PortletDefinitionComposite pdef = (PortletDefinitionComposite)pa.getPortletDefinitionByName(pdefName);
            request.setAttribute("portletDefinition", (Object)pdef);
            request.setAttribute("tabs", this.paTabMap.values());
            request.setAttribute("portlet_tabs", this.pdTabMap.values());
            TabBean selectedTab = (TabBean)request.getPortletSession().getAttribute("selected_tab", 1);
            if (selectedTab == null) {
                selectedTab = (TabBean)this.paTabMap.values().iterator().next();
            }
            if (selectedTab.getId().equals("pa_portlets")) {
                TabBean selectedPortletTab = (TabBean)request.getPortletSession().getAttribute("selected_portlet_tab");
                if (selectedPortletTab == null) {
                    selectedPortletTab = (TabBean)this.pdTabMap.values().iterator().next();
                }
                if (selectedPortletTab.getId().equals("pd_security")) {
                    this.setupSecurityContraintContext(request, null, pdef);
                }
                request.setAttribute("selected_portlet_tab", (Object)selectedPortletTab);
            } else if (selectedTab.getId().equals("pa_details")) {
                this.setupSecurityContraintContext(request, pa, null);
            }
            request.setAttribute("selected_tab", (Object)selectedTab);
        }
        super.doView(request, response);
    }

    private void setupSecurityContraintContext(RenderRequest request, MutablePortletApplication pa, PortletDefinitionComposite pdef) throws PortletException {
        try {
            List securityContraintRefList = this.pageManager.getPageSecurity().getSecurityConstraintsDefs();
            request.setAttribute("securityContraintRefList", (Object)securityContraintRefList);
            if (pdef == null) {
                request.setAttribute("currentSecurityConstraintRef", (Object)pa.getJetspeedSecurityConstraint());
            } else {
                request.setAttribute("currentSecurityConstraintRef", (Object)pdef.getJetspeedSecurityConstraint());
            }
        }
        catch (Exception e) {
            throw new PortletException("Failed to retrieve security constraint references from " + (pdef == null ? "portlet application " + pa.getName() : "portlet definition " + pdef.getName()));
        }
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        String action;
        String selectedPortletTab;
        String selectedTab;
        String paName = (String)actionRequest.getPortletSession().getAttribute("org.apache.jetspeed.pam.pa", 1);
        String selectedPortlet = actionRequest.getParameter("select_portlet");
        if (selectedPortlet != null) {
            actionRequest.getPortletSession().setAttribute("select_portlet", (Object)selectedPortlet, 1);
        }
        if ((selectedTab = actionRequest.getParameter("selected_tab")) != null) {
            TabBean tab = (TabBean)this.paTabMap.get(selectedTab);
            actionRequest.getPortletSession().setAttribute("selected_tab", (Object)tab, 1);
        }
        if ((selectedPortletTab = actionRequest.getParameter("selected_portlet_tab")) != null) {
            TabBean tab = (TabBean)this.pdTabMap.get(selectedPortletTab);
            actionRequest.getPortletSession().setAttribute("selected_portlet_tab", (Object)tab);
        }
        if ((action = actionRequest.getParameter(PORTLET_ACTION)) != null) {
            MutablePortletApplication pa = this.registry.getPortletApplication(paName);
            if (this.isAppAction(action)) {
                if ((action = this.getAction(PORTLET_APP_ACTION_PREFIX, action)).endsWith("metadata")) {
                    this.processMetadataAction(actionRequest, actionResponse, pa, null, action);
                } else if (action.endsWith("user_attribute")) {
                    this.processUserAttributeAction(actionRequest, actionResponse, pa, action);
                } else if (action.endsWith("edit_security_constraint")) {
                    this.processSecurityRef(actionRequest, actionResponse, pa, null, action);
                }
                this.searchEngine.update((Object)pa);
            } else if (this.isPortletAction(action)) {
                action = this.getAction(PORTLET_ACTION_PREFIX, action);
                String pdefName = (String)actionRequest.getPortletSession().getAttribute("select_portlet", 1);
                try {
                    PortletDefinitionComposite pdef = (PortletDefinitionComposite)pa.getPortletDefinitionByName(pdefName);
                    if (action.endsWith("metadata")) {
                        this.processMetadataAction(actionRequest, actionResponse, null, pdef, action);
                    } else if (action.endsWith("portlet")) {
                        this.processPortletAction(actionRequest, actionResponse, pa, pdef, action);
                    } else if (action.endsWith("preference")) {
                        this.processPreferenceAction(actionRequest, actionResponse, pa, pdef, action);
                    } else if (action.endsWith("language")) {
                        this.processLanguage(actionRequest, actionResponse, pa, pdef, action);
                    } else if (action.endsWith("parameter")) {
                        this.processParameter(actionRequest, actionResponse, pa, pdef, action);
                    } else if (action.endsWith("security")) {
                        this.processSecurity(actionRequest, actionResponse, pa, pdef, action);
                    } else if (action.endsWith("content_type")) {
                        this.processContentType(actionRequest, actionResponse, pa, pdef, action);
                    } else if (action.endsWith("edit_security_constraint")) {
                        this.processSecurityRef(actionRequest, actionResponse, null, pdef, action);
                    }
                    this.searchEngine.update((Object)pdef);
                }
                catch (RegistryException e) {
                    throw new PortletException("A Registry action has failed.  " + e.getMessage());
                }
            }
        }
    }

    private boolean isAppAction(String action) {
        return action.startsWith(PORTLET_APP_ACTION_PREFIX);
    }

    private boolean isPortletAction(String action) {
        return action.startsWith(PORTLET_ACTION_PREFIX);
    }

    private String getAction(String prefix, String action) {
        return action.substring(prefix.length());
    }

    private void processUserAttributeAction(ActionRequest actionRequest, ActionResponse actionResponse, MutablePortletApplication mpa, String action) throws PortletException, IOException {
        String[] userAttrNames;
        String userAttrName;
        boolean modified = false;
        if (action.equals("edit_user_attribute")) {
            userAttrName = "";
            Iterator userAttrIter = mpa.getUserAttributes().iterator();
            while (userAttrIter.hasNext()) {
                UserAttribute userAttr = (UserAttribute)userAttrIter.next();
                userAttrName = userAttr.getName();
                String description = actionRequest.getParameter(userAttrName + ":description");
                if (userAttr.getDescription().equals(description)) continue;
                userAttr.setDescription(description);
                modified = true;
            }
        } else if (action.equals("add_user_attribute")) {
            userAttrName = actionRequest.getParameter("user_attr_name");
            String userAttrDesc = actionRequest.getParameter("user_attr_desc");
            if (userAttrName != null && userAttrName.trim().length() > 0) {
                mpa.addUserAttribute(userAttrName.trim(), userAttrDesc);
                modified = true;
            }
        } else if (action.equals("remove_user_attribute") && (userAttrNames = actionRequest.getParameterValues("user_attr_id")) != null) {
            String userAttrName2 = "";
            int count = 0;
            Iterator userAttrIter = mpa.getUserAttributes().iterator();
            block3: while (userAttrIter.hasNext()) {
                UserAttribute userAttr = (UserAttribute)userAttrIter.next();
                for (int ix = 0; ix < userAttrNames.length; ++ix) {
                    userAttrName2 = userAttrNames[ix];
                    if (!userAttr.getName().equals(userAttrName2)) continue;
                    userAttrIter.remove();
                    ++count;
                    continue block3;
                }
            }
            boolean bl = modified = count > 0;
        }
        if (modified) {
            try {
                this.registry.updatePortletApplication((PortletApplicationDefinition)mpa);
            }
            catch (RegistryException e) {
                throw new PortletException("Failed to update portlet application while performing action " + action, (Throwable)e);
            }
        }
    }

    private void processMetadataAction(ActionRequest actionRequest, ActionResponse actionResponse, MutablePortletApplication pa, PortletDefinitionComposite pd, String action) throws PortletException, IOException {
        GenericMetadata meta = null;
        if (pd != null) {
            meta = pd.getMetadata();
        } else if (pa != null) {
            meta = pa.getMetadata();
        }
        if (meta == null) {
            return;
        }
        boolean modified = false;
        if (action.equals("edit_metadata")) {
            Iterator fieldsIter = meta.getFields().iterator();
            while (fieldsIter.hasNext()) {
                LocalizedField field = (LocalizedField)fieldsIter.next();
                String id = field.getId().toString();
                String value = actionRequest.getParameter(id + ":value");
                if (value == null || value.equals(field.getValue())) continue;
                field.setValue(value);
                modified = true;
            }
        } else if (action.equals("remove_metadata")) {
            String[] ids = actionRequest.getParameterValues("metadata_id");
            if (ids != null) {
                Iterator fieldsIter = meta.getFields().iterator();
                int count = 0;
                block3: while (fieldsIter.hasNext()) {
                    LocalizedField field = (LocalizedField)fieldsIter.next();
                    String id = field.getId().toString();
                    for (int i = 0; i < ids.length; ++i) {
                        String mid = ids[i];
                        if (!mid.equals(id)) continue;
                        fieldsIter.remove();
                        ++count;
                        continue block3;
                    }
                }
                modified = count > 0;
            }
        } else if (action.equals("add_metadata")) {
            String name = actionRequest.getParameter("name");
            String value = actionRequest.getParameter("value");
            String localeParam = actionRequest.getParameter("locale");
            if (localeParam == null || name.trim().length() == 0) {
                localeParam = "en";
            }
            Locale locale = new Locale(localeParam);
            if (name != null && name.trim().length() > 0) {
                meta.addField(locale, name, value);
                modified = true;
            }
        }
        if (modified) {
            try {
                if (pd == null) {
                    this.registry.updatePortletApplication((PortletApplicationDefinition)pa);
                } else {
                    this.registry.savePortletDefinition((PortletDefinition)pd);
                }
            }
            catch (RegistryException e) {
                throw new PortletException("Failed to perform action " + action + " on " + (pd == null ? "portlet application " + pa.getName() : "portlet definition " + pd.getName()));
            }
        }
    }

    private void processPortletAction(ActionRequest actionRequest, ActionResponse actionResponse, MutablePortletApplication pa, PortletDefinitionComposite portlet, String action) throws RegistryException {
        if (action.equals("edit_portlet")) {
            String displayNameParam = actionRequest.getParameter("display_name");
            if (displayNameParam == null) {
                int index = 0;
                Iterator displayNameIter = portlet.getDisplayNameSet().iterator();
                while (displayNameIter.hasNext()) {
                    MutableDisplayName displayName = (MutableDisplayName)displayNameIter.next();
                    displayNameParam = actionRequest.getParameter("display_name:" + index);
                    if (displayNameParam != null) {
                        if (displayNameParam.length() == 0) {
                            displayNameIter.remove();
                        } else if (!displayNameParam.equals(displayName.getDisplayName())) {
                            displayName.setDisplayName(displayNameParam);
                        }
                    }
                    ++index;
                }
                String expirationCache = actionRequest.getParameter("expirationCache");
                if (expirationCache != null) {
                    try {
                        Integer.parseInt(expirationCache);
                        portlet.setExpirationCache(expirationCache);
                    }
                    catch (NumberFormatException e) {}
                }
            } else {
                String locale = actionRequest.getParameter("locale");
                portlet.addDisplayName(new Locale(locale), displayNameParam);
            }
        } else if (action.equals("remove_portlet") || action.equals("add_portlet")) {
            // empty if block
        }
        this.registry.savePortletDefinition((PortletDefinition)portlet);
    }

    private void processPreferenceAction(ActionRequest actionRequest, ActionResponse actionResponse, MutablePortletApplication pa, PortletDefinitionComposite portlet, String action) throws RegistryException {
        if (action.equals("add_preference")) {
            String name = actionRequest.getParameter("name");
            String value = actionRequest.getParameter("value");
            PreferenceComposite pref = (PreferenceComposite)portlet.getPreferenceSet().get(name);
            if (pref == null) {
                portlet.addPreference(name, new String[]{value});
            } else {
                pref.addValue(value);
            }
        } else if (action.equals("edit_preference")) {
            String[] prefNames = actionRequest.getParameterValues("pref_edit_id");
            for (int i = 0; i < prefNames.length; ++i) {
                String prefName = prefNames[i];
                PreferenceComposite prefComp = (PreferenceComposite)portlet.getPreferenceSet().get(prefName);
                String[] values = prefComp.getValueArray();
                for (int j = 0; j < values.length; ++j) {
                    String value = values[j];
                    String newValue = actionRequest.getParameter(prefName + ":" + j);
                    if (value.equals(newValue)) continue;
                    prefComp.setValueAt(j, newValue);
                }
            }
        } else if (action.equals("remove_preference")) {
            String[] prefNames = actionRequest.getParameterValues("pref_remove_id");
            Iterator prefIter = portlet.getPreferenceSet().iterator();
            block2: while (prefIter.hasNext()) {
                PreferenceComposite pref = (PreferenceComposite)prefIter.next();
                String name = pref.getName();
                for (int i = 0; i < prefNames.length; ++i) {
                    String prefName = prefNames[i];
                    if (!name.equals(prefName)) continue;
                    prefIter.remove();
                    continue block2;
                }
            }
        }
        this.registry.savePortletDefinition((PortletDefinition)portlet);
    }

    private void processLanguage(ActionRequest actionRequest, ActionResponse actionResponse, MutablePortletApplication pa, PortletDefinitionComposite portlet, String action) throws RegistryException {
        String[] editIds;
        if (action.equals("add_language")) {
            String title = actionRequest.getParameter("title");
            String shortTitle = actionRequest.getParameter("short_title");
            String keywords = actionRequest.getParameter("keyword");
            String locale = actionRequest.getParameter("locale");
            portlet.addLanguage(title, shortTitle, keywords, new Locale(locale));
        } else if (action.equals("remove_language")) {
            String[] removeIds = actionRequest.getParameterValues("language_remove_id");
            if (removeIds != null) {
                int id = 0;
                Iterator langIter = portlet.getLanguageSet().iterator();
                block0: while (langIter.hasNext()) {
                    langIter.next();
                    int currentId = id++;
                    for (int i = 0; i < removeIds.length; ++i) {
                        String removeId = removeIds[i];
                        String tempId = "" + currentId;
                        if (!removeId.equals(tempId)) continue;
                        langIter.remove();
                        continue block0;
                    }
                }
            }
        } else if (action.equals("edit_language") && (editIds = actionRequest.getParameterValues("language_edit_id")) != null) {
            int index = 0;
            Iterator langIter = portlet.getLanguageSet().iterator();
            while (langIter.hasNext()) {
                String id = editIds[index];
                String title = actionRequest.getParameter("title:" + id);
                String shortTitle = actionRequest.getParameter("short_title:" + id);
                MutableLanguage lang = (MutableLanguage)langIter.next();
                if (!lang.getTitle().equals(title)) {
                    lang.setTitle(title);
                }
                Iterator keywordIter = lang.getKeywords();
                int keywordIndex = 0;
                ArrayList<String> keywordList = new ArrayList<String>();
                while (keywordIter.hasNext()) {
                    keywordIter.next();
                    String keywordParam = actionRequest.getParameter("keyword:" + id + ":" + keywordIndex);
                    if (keywordParam != null && keywordParam.length() > 0) {
                        keywordList.add(keywordParam);
                    }
                    ++keywordIndex;
                }
                lang.setKeywords(keywordList);
                if (lang.getShortTitle() == null || !lang.getShortTitle().equals(shortTitle)) {
                    lang.setShortTitle(shortTitle);
                }
                ++index;
            }
        }
        this.registry.savePortletDefinition((PortletDefinition)portlet);
    }

    private void processParameter(ActionRequest actionRequest, ActionResponse actionResponse, MutablePortletApplication pa, PortletDefinitionComposite portlet, String action) throws FailedToStorePortletDefinitionException {
        String[] paramIds;
        if (action.equals("add_parameter")) {
            String name = actionRequest.getParameter("name");
            if (name != null) {
                String description = actionRequest.getParameter("description");
                String locale = actionRequest.getParameter("locale");
                ParameterComposite parameter = (ParameterComposite)portlet.getInitParameterSet().get(name);
                if (parameter == null) {
                    String value = actionRequest.getParameter("value");
                    parameter = portlet.addInitParameter(name, value, description, new Locale(locale));
                } else {
                    parameter.addDescription(new Locale(locale), description);
                }
            }
        } else if (action.equals("edit_parameter")) {
            String[] paramIds2 = actionRequest.getParameterValues("parameter_edit_id");
            if (paramIds2 != null) {
                for (int i = 0; i < paramIds2.length; ++i) {
                    String paramId = paramIds2[i];
                    ParameterComposite param = (ParameterComposite)portlet.getInitParameterSet().get(paramId);
                    String value = actionRequest.getParameter(paramId + ":value");
                    param.setValue(value);
                    int index = 0;
                    Iterator descIter = param.getDescriptionSet().iterator();
                    while (descIter.hasNext()) {
                        MutableDescription description = (MutableDescription)descIter.next();
                        String descParam = actionRequest.getParameter(paramId + ":description:" + index);
                        if (descParam != null) {
                            if (descParam.length() == 0) {
                                descIter.remove();
                            } else if (!descParam.equals(description.getDescription())) {
                                description.setDescription(descParam);
                            }
                        }
                        ++index;
                    }
                }
            }
        } else if (action.equals("remove_parameter") && (paramIds = actionRequest.getParameterValues("parameter_remove_id")) != null) {
            Iterator paramIter = portlet.getInitParameterSet().iterator();
            block2: while (paramIter.hasNext()) {
                ParameterComposite param = (ParameterComposite)paramIter.next();
                for (int i = 0; i < paramIds.length; ++i) {
                    String paramId = paramIds[i];
                    if (!param.getName().equals(paramId)) continue;
                    paramIter.remove();
                    continue block2;
                }
            }
        }
        this.registry.savePortletDefinition((PortletDefinition)portlet);
    }

    private void processSecurity(ActionRequest actionRequest, ActionResponse actionResponse, MutablePortletApplication pa, PortletDefinitionComposite portlet, String action) throws FailedToStorePortletDefinitionException {
        String[] securityIds;
        if (action.equals("add_security")) {
            String name = actionRequest.getParameter("name");
            if (name != null) {
                String description;
                String link = actionRequest.getParameter("link");
                SecurityRoleRefComposite securityRoleRef = (SecurityRoleRefComposite)portlet.getInitSecurityRoleRefSet().get(name);
                if (securityRoleRef == null && link != null) {
                    securityRoleRef = (SecurityRoleRefComposite)portlet.addSecurityRoleRef(name, link);
                }
                if (securityRoleRef != null && (description = actionRequest.getParameter("description")) != null && description.length() > 0) {
                    String locale = actionRequest.getParameter("locale");
                    if (locale == null) {
                        locale = "en";
                    }
                    securityRoleRef.addDescription(new Locale(locale), description);
                }
            }
        } else if (action.equals("edit_security")) {
            Iterator securityIter = portlet.getInitSecurityRoleRefSet().iterator();
            while (securityIter.hasNext()) {
                SecurityRoleRefComposite secRef = (SecurityRoleRefComposite)securityIter.next();
                String name = secRef.getRoleName();
                String link = actionRequest.getParameter(name + ":link");
                if (!secRef.getRoleLink().equals(link)) {
                    secRef.setRoleLink(link);
                }
                int index = 0;
                Iterator descIter = secRef.getDescriptionSet().iterator();
                while (descIter.hasNext()) {
                    MutableDescription description = (MutableDescription)descIter.next();
                    String descParam = actionRequest.getParameter(name + ":description:" + index);
                    if (descParam != null) {
                        if (descParam.length() == 0) {
                            descIter.remove();
                        } else if (!descParam.equals(description.getDescription())) {
                            description.setDescription(descParam);
                        }
                    }
                    ++index;
                }
            }
        } else if (action.equals("remove_security") && (securityIds = actionRequest.getParameterValues("security_remove_id")) != null) {
            for (int i = 0; i < securityIds.length; ++i) {
                String id = securityIds[i];
                SecurityRoleRef secRef = portlet.getInitSecurityRoleRefSet().get(id);
                portlet.getInitSecurityRoleRefSet().remove((Object)secRef);
            }
        }
        this.registry.savePortletDefinition((PortletDefinition)portlet);
    }

    private void processSecurityRef(ActionRequest actionRequest, ActionResponse actionResponse, MutablePortletApplication pa, PortletDefinitionComposite pdef, String action) throws PortletException {
        String ref = actionRequest.getParameter("security-constraint-ref");
        String currentRef = "";
        currentRef = pa != null ? pa.getJetspeedSecurityConstraint() : pdef.getJetspeedSecurityConstraint();
        if (currentRef == null) {
            currentRef = "";
        }
        if (!currentRef.equals(ref)) {
            if (ref.length() == 0) {
                ref = null;
            }
            try {
                if (pa != null) {
                    pa.setJetspeedSecurityConstraint(ref);
                    this.registry.updatePortletApplication((PortletApplicationDefinition)pa);
                } else {
                    pdef.setJetspeedSecurityConstraint(ref);
                    this.registry.savePortletDefinition((PortletDefinition)pdef);
                }
            }
            catch (RegistryException e) {
                throw new PortletException("Failed to perform action " + action + " on " + (pdef == null ? "portlet application " + pa.getName() : "portlet definition " + pdef.getName()));
            }
        }
    }

    private void processContentType(ActionRequest actionRequest, ActionResponse actionResponse, MutablePortletApplication pa, PortletDefinitionComposite portlet, String action) throws FailedToStorePortletDefinitionException {
        String[] contentIds;
        if (action.equals("add_content_type")) {
            String contentType = actionRequest.getParameter("content_type");
            if (contentType != null) {
                ArrayList<Object> allModes = new ArrayList<Object>();
                String[] modes = actionRequest.getParameterValues("mode");
                if (modes != null) {
                    for (int i = 0; i < modes.length; ++i) {
                        String mode = modes[i];
                        allModes.add(new PortletMode(mode));
                    }
                }
                String customModes = actionRequest.getParameter("custom_modes");
                StringTokenizer tok = new StringTokenizer(customModes, ",");
                while (tok.hasMoreTokens()) {
                    allModes.add(tok.nextToken());
                }
                portlet.addContentType(contentType, allModes);
            }
        } else if (action.equals("remove_content_type") && (contentIds = actionRequest.getParameterValues("content_type_remove_id")) != null) {
            Iterator contentIter = portlet.getContentTypeSet().iterator();
            block2: while (contentIter.hasNext()) {
                ContentType contentType = (ContentType)contentIter.next();
                for (int i = 0; i < contentIds.length; ++i) {
                    String id = contentIds[i];
                    if (!contentType.getContentType().equals(id)) continue;
                    contentIter.remove();
                    continue block2;
                }
            }
        }
        this.registry.savePortletDefinition((PortletDefinition)portlet);
    }
}

