/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.pam;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.om.common.portlet.MutablePortletApplication;
import org.apache.jetspeed.om.common.portlet.PortletDefinitionComposite;
import org.apache.jetspeed.search.SearchEngine;
import org.apache.jetspeed.search.SearchResults;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.apache.portals.bridges.beans.TabBean;
import org.apache.portals.bridges.common.GenericServletPortlet;
import org.apache.webapp.admin.TreeControl;
import org.apache.webapp.admin.TreeControlNode;

public class PortletApplicationBrowser
extends GenericServletPortlet {
    private PortletContext context;
    private PortletRegistry registry;
    private SearchEngine searchEngine;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.context = this.getPortletContext();
        this.registry = (PortletRegistry)this.context.getAttribute("cps:PortletRegistryComponent");
        if (null == this.registry) {
            throw new PortletException("Failed to find the Portlet Registry on portlet initialization");
        }
        this.searchEngine = (SearchEngine)this.context.getAttribute("cps:SearchComponent");
        if (null == this.searchEngine) {
            throw new PortletException("Failed to find the Search Engine on portlet initialization");
        }
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        TreeControl control = (TreeControl)request.getPortletSession().getAttribute("j2_tree");
        if (control == null) {
            Collection apps = this.registry.getPortletApplications();
            control = this.buildTree(apps, request.getLocale());
            request.getPortletSession().setAttribute("j2_tree", (Object)control);
        }
        request.setAttribute("j2_tree", (Object)control);
        request.setAttribute("search_results", request.getPortletSession().getAttribute("search_results"));
        super.doView(request, response);
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        TreeControl control = (TreeControl)actionRequest.getPortletSession().getAttribute("j2_tree");
        if (control != null) {
            String selectedNode;
            TreeControlNode controlNode;
            String node;
            String searchString = actionRequest.getParameter("query");
            if (searchString != null) {
                SearchResults results = this.searchEngine.search(searchString);
                actionRequest.getPortletSession().setAttribute("search_results", (Object)results.getResults());
            }
            if ((node = actionRequest.getParameter("node")) != null && (controlNode = control.findNode(node)) != null) {
                controlNode.setExpanded(!controlNode.isExpanded());
            }
            if ((selectedNode = actionRequest.getParameter("select_node")) != null) {
                control.selectNode(selectedNode);
                TreeControlNode child = control.findNode(selectedNode);
                if (child != null) {
                    TreeControlNode parent;
                    MutablePortletApplication pa = null;
                    String domain = child.getDomain();
                    if (domain.equals("PA_APP_DOMAIN")) {
                        pa = this.registry.getPortletApplicationByIdentifier(selectedNode);
                        if (pa != null) {
                            actionRequest.getPortletSession().removeAttribute("select_portlet", 1);
                        }
                    } else if (domain.equals("PD_DOMAIN") && (pa = this.registry.getPortletApplicationByIdentifier((parent = child.getParent()).getName())) != null) {
                        String pdefName = child.getName().substring(pa.getName().length() + 2);
                        PortletDefinition pdef = pa.getPortletDefinitionByName(pdefName);
                        actionRequest.getPortletSession().setAttribute("select_portlet", (Object)pdef.getName(), 1);
                        actionRequest.getPortletSession().setAttribute("selected_tab", (Object)new TabBean("pa_portlets"), 1);
                    }
                    if (pa != null) {
                        actionRequest.getPortletSession().setAttribute("org.apache.jetspeed.pam.pa", (Object)pa.getName(), 1);
                    }
                }
            }
        }
    }

    private TreeControl buildTree(Collection apps, Locale locale) {
        TreeControlNode root = new TreeControlNode("ROOT-NODE", null, "J2_ROOT", "portlet_url", null, true, "J2_DOMAIN");
        TreeControl control = new TreeControl(root);
        TreeControlNode portletApps = new TreeControlNode("APP_ROOT", null, "APP_ROOT", "portlet_url", null, false, "J2_DOMAIN");
        root.addChild(portletApps);
        Iterator it = apps.iterator();
        while (it.hasNext()) {
            MutablePortletApplication pa = (MutablePortletApplication)it.next();
            TreeControlNode appNode = new TreeControlNode(pa.getName(), null, pa.getName(), "portlet_url", null, false, "PA_APP_DOMAIN");
            portletApps.addChild(appNode);
            Iterator pdefIter = pa.getPortletDefinitionList().iterator();
            while (pdefIter.hasNext()) {
                PortletDefinitionComposite portlet = (PortletDefinitionComposite)pdefIter.next();
                TreeControlNode portletNode = new TreeControlNode(pa.getName() + "::" + portlet.getName(), null, portlet.getDisplayNameText(locale), "portlet_url", null, false, "PD_DOMAIN");
                appNode.addChild(portletNode);
            }
        }
        return control;
    }
}

