/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.palm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.components.portletregistry.RegistryException;
import org.apache.jetspeed.factory.PortletFactory;
import org.apache.jetspeed.om.common.portlet.MutablePortletApplication;
import org.apache.jetspeed.om.common.portlet.PortletApplication;
import org.apache.jetspeed.portlets.palm.PortletApplicationStatusBean;
import org.apache.jetspeed.tools.pamanager.PortletApplicationManagement;
import org.apache.jetspeed.tools.pamanager.servletcontainer.ApplicationServerManager;
import org.apache.jetspeed.tools.pamanager.servletcontainer.ApplicationServerManagerResult;
import org.apache.portals.bridges.common.GenericServletPortlet;
import org.apache.portals.gems.util.StatusMessage;
import org.apache.portals.messaging.PortletMessaging;

public class PortletApplicationLifecycleManager
extends GenericServletPortlet {
    private ApplicationServerManager asm;
    private PortletRegistry registry;
    private PortletFactory portletFactory;
    private PortletApplicationManagement pam;
    private boolean serverManagerAvailable;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        PortletContext context = this.getPortletContext();
        this.registry = (PortletRegistry)context.getAttribute("cps:PortletRegistryComponent");
        this.portletFactory = (PortletFactory)context.getAttribute("cps:PortletFactory");
        this.asm = (ApplicationServerManager)context.getAttribute("cps:ApplicationServerManager");
        this.pam = (PortletApplicationManagement)context.getAttribute("cps:PAM");
        if (null == this.registry) {
            throw new PortletException("Failed to find the Portlet Registry on portlet initialization");
        }
        if (null == this.portletFactory) {
            throw new PortletException("Failed to find the Portlet Factory on portlet initialization");
        }
        if (null == this.pam) {
            throw new PortletException("Failed to find the Portlet Application Manager on portlet initialization");
        }
        this.serverManagerAvailable = this.asm != null && this.asm.isConnected();
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        request.setAttribute("serverManagerAvailable", (Object)(this.serverManagerAvailable ? Boolean.TRUE : Boolean.FALSE));
        StatusMessage msg = (StatusMessage)PortletMessaging.consume((PortletRequest)request, (String)"PALM", (String)"status");
        if (msg != null) {
            request.setAttribute("statusMsg", (Object)msg);
        }
        if (request.getPortletSession().getAttribute("list") == null) {
            ArrayList<PortletApplicationStatusBean> list = new ArrayList<PortletApplicationStatusBean>();
            Iterator apps = this.registry.getPortletApplications().iterator();
            while (apps.hasNext()) {
                MutablePortletApplication pa = (MutablePortletApplication)apps.next();
                PortletApplicationStatusBean bean = new PortletApplicationStatusBean(pa, this.portletFactory.isPortletApplicationRegistered((PortletApplication)pa));
                list.add(bean);
            }
            request.getPortletSession().setAttribute("list", list);
        }
        super.doView(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        if (request.getPortletMode() == PortletMode.VIEW) {
            String action = request.getParameter("action");
            String value = request.getParameter("value");
            if (!this.isEmpty(action)) {
                request.getPortletSession().removeAttribute("list");
                if (!action.equals("refresh") && !this.isEmpty(value)) {
                    MutablePortletApplication pa = this.registry.getPortletApplication(value);
                    if (pa == null) {
                        this.publishStatusMessage((PortletRequest)request, "PALM", "status", null, "Portlet Application for lookup value " + value + " no longer exists");
                    } else if (pa.getApplicationType() != 1) {
                        if (action.equals("start")) {
                            this.startPA(request, pa);
                        } else if (action.equals("stop")) {
                            this.stopPA(request, pa);
                        } else if (action.equals("undeploy")) {
                            this.undeployPA(request, pa);
                        } else if (action.equals("delete")) {
                            this.deletePA(request, pa);
                        }
                    }
                }
            }
        }
    }

    protected void publishStatusMessage(PortletRequest request, String portlet, String topic, Throwable e, String message) {
        if (e != null) {
            message = message + ": " + e.toString();
            Throwable cause = e.getCause();
            if (cause != null) {
                message = message + ", " + cause.getMessage();
            }
        }
        StatusMessage sm = new StatusMessage(message, "portlet-msg-error");
        try {
            PortletMessaging.publish((PortletRequest)request, (String)portlet, (String)topic, (Object)sm);
        }
        catch (Exception ee) {
            System.err.println("Failed to publish message: " + message);
        }
    }

    protected void startPA(ActionRequest request, MutablePortletApplication pa) {
        if (this.portletFactory.isPortletApplicationRegistered((PortletApplication)pa)) {
            this.publishStatusMessage((PortletRequest)request, "PALM", "status", null, "Portlet Application " + pa.getName() + " already running");
        } else if (!this.serverManagerAvailable || !this.asm.isConnected()) {
            this.publishStatusMessage((PortletRequest)request, "PALM", "status", null, "Application Server Manager not available");
        } else {
            try {
                ApplicationServerManagerResult result = this.asm.start(pa.getWebApplicationDefinition().getContextRoot());
                if (!result.isOk()) {
                    this.publishStatusMessage((PortletRequest)request, "PALM", "status", null, result.getMessage());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.publishStatusMessage((PortletRequest)request, "PAM", "status", (Throwable)e, "Could not start Portlet Application " + pa.getName());
            }
        }
    }

    protected void stopPA(ActionRequest request, MutablePortletApplication pa) {
        if (!this.portletFactory.isPortletApplicationRegistered((PortletApplication)pa)) {
            this.publishStatusMessage((PortletRequest)request, "PALM", "status", null, "Portlet Application " + pa.getName() + " no longer running");
        } else if (!this.serverManagerAvailable || !this.asm.isConnected()) {
            this.publishStatusMessage((PortletRequest)request, "PALM", "status", null, "Application Server Manager not available");
        } else {
            try {
                ApplicationServerManagerResult result = this.asm.stop(pa.getWebApplicationDefinition().getContextRoot());
                if (!result.isOk()) {
                    this.publishStatusMessage((PortletRequest)request, "PALM", "status", null, result.getMessage());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.publishStatusMessage((PortletRequest)request, "PALM", "status", (Throwable)e, "Could not stop Portlet Application " + pa.getName());
            }
        }
    }

    protected void undeployPA(ActionRequest request, MutablePortletApplication pa) {
        if (!this.serverManagerAvailable || !this.asm.isConnected()) {
            this.publishStatusMessage((PortletRequest)request, "PALM", "status", null, "Application Server Manager not available");
        } else {
            try {
                ApplicationServerManagerResult result = this.asm.undeploy(pa.getWebApplicationDefinition().getContextRoot());
                if (!result.isOk()) {
                    this.publishStatusMessage((PortletRequest)request, "PALM", "status", null, result.getMessage());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.publishStatusMessage((PortletRequest)request, "PALM", "status", (Throwable)e, "Could not undeploy Portlet Application " + pa.getName());
            }
        }
    }

    protected void deletePA(ActionRequest request, MutablePortletApplication pa) {
        if (this.portletFactory.isPortletApplicationRegistered((PortletApplication)pa)) {
            this.publishStatusMessage((PortletRequest)request, "PALM", "status", null, "Portlet Application " + pa.getName() + " is still running");
        } else {
            try {
                this.pam.unregisterPortletApplication(pa.getName());
            }
            catch (RegistryException e) {
                e.printStackTrace();
                this.publishStatusMessage((PortletRequest)request, "PALM", "status", (Throwable)e, "Could not delete Portlet Application " + pa.getName());
            }
        }
    }

    private boolean isEmpty(String s) {
        if (s == null) {
            return true;
        }
        return s.trim().equals("");
    }
}

