/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.entityeditor;

import java.io.IOException;
import java.util.Collection;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.jetspeed.components.portletentity.PortletEntityAccessComponent;
import org.apache.jetspeed.components.portletentity.PortletEntityNotStoredException;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.om.common.portlet.MutablePortletEntity;
import org.apache.jetspeed.request.RequestContext;
import org.apache.pluto.om.entity.PortletEntity;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.apache.portals.bridges.velocity.GenericVelocityPortlet;
import org.apache.velocity.context.Context;

public class PortletEntityBrowserPortlet
extends GenericVelocityPortlet {
    private PortletEntityAccessComponent entityAccess;
    private PortletRegistry registry;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        PortletContext context = this.getPortletContext();
        this.entityAccess = (PortletEntityAccessComponent)context.getAttribute("cps:EntityAccessor");
        this.registry = (PortletRegistry)context.getAttribute("cps:PortletRegistryComponent");
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        Collection portletApps = this.registry.getPortletApplications();
        Context context = this.getContext(request);
        context.put("portletApps", (Object)portletApps);
        context.put("entityAccess", (Object)this.entityAccess);
        context.put("portletContext", (Object)this.getPortletContext());
        RequestContext requestContext = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
        context.put("jetspeedContextPath", (Object)requestContext.getRequest().getContextPath());
        super.doView(request, response);
    }

    protected final void doCreate(ActionRequest request, ActionResponse response) throws PortletException {
        try {
            PortletDefinition pd = this.getPortletDefintion(request);
            String newId = request.getParameter("newEntityId");
            MutablePortletEntity entity = null;
            entity = newId != null ? this.entityAccess.newPortletEntityInstance(pd, newId) : this.entityAccess.newPortletEntityInstance(pd);
            this.entityAccess.storePortletEntity((PortletEntity)entity);
        }
        catch (PortletEntityNotStoredException e) {
            throw new PortletException(e.getMessage(), (Throwable)e);
        }
        catch (PortletException e) {
            throw new PortletException(e.getMessage(), (Throwable)e);
        }
    }

    protected final PortletDefinition getPortletDefintion(ActionRequest request) throws PortletException {
        String portletUniqueName = request.getParameter("selectedPortlet");
        if (portletUniqueName == null) {
            throw new PortletException("There was no 'portletUniqueName' parameter specified in the request.");
        }
        return this.registry.getPortletDefinitionByUniqueName(portletUniqueName);
    }

    public void processAction(ActionRequest request, ActionResponse actionResponse) throws PortletException, IOException {
        String action = request.getParameter("action");
        if (action == null) {
            throw new PortletException("Requires that action either be 'edit' or 'create'");
        }
        if (!action.equals("create")) {
            throw new PortletException("Requires that action to be 'create'");
        }
        this.doCreate(request, actionResponse);
    }
}

