/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.custom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.jetspeed.om.common.SecurityConstraint;
import org.apache.jetspeed.om.common.SecurityConstraints;
import org.apache.jetspeed.om.page.Fragment;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.page.PageManager;
import org.apache.portals.bridges.velocity.GenericVelocityPortlet;
import org.springframework.util.StringUtils;

public class CustomConfigModePortlet
extends GenericVelocityPortlet {
    private static final PortletMode CONFIG_MODE = new PortletMode("config");
    private static final String DELIMITERS = "[],; ";
    private PageManager pageManager;
    private String configPage;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.configPage = config.getInitParameter("ConfigPage");
        PortletContext context = this.getPortletContext();
        this.pageManager = (PageManager)context.getAttribute("cps:PageManager");
        if (this.pageManager == null) {
            throw new PortletException("Could not get instance of pageManager component");
        }
    }

    protected void doDispatch(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (!request.getWindowState().equals((Object)WindowState.MINIMIZED)) {
            PortletMode curMode = request.getPortletMode();
            if (CONFIG_MODE.equals((Object)curMode)) {
                List securityContraintRefList = null;
                try {
                    securityContraintRefList = this.pageManager.getPageSecurity().getSecurityConstraintsDefs();
                }
                catch (Exception e) {
                    throw new PortletException("Cannot find page security constraint definitions.", (Throwable)e);
                }
                if (securityContraintRefList != null) {
                    request.setAttribute("securityContraintRefList", (Object)securityContraintRefList);
                }
                request.setAttribute("EditPage", (Object)this.configPage);
                this.doEdit(request, response);
            } else {
                super.doDispatch(request, response);
            }
        }
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        String action = request.getParameter("action");
        if ("addConstraint".equals(action)) {
            this.addSecurityConstraint(request, response);
        } else if ("removeConstraint".equals(action)) {
            this.removeSecurityConstraint(request, response);
        } else if ("updateConstraintRefs".equals(action)) {
            this.updateSecurityConstraintRefs(request, response);
        }
    }

    private void addSecurityConstraint(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        try {
            String path = request.getParameter("path");
            String fragmentId = request.getParameter("fragment");
            String type = request.getParameter("type");
            String roles = request.getParameter("roles");
            String groups = request.getParameter("groups");
            String users = request.getParameter("users");
            String permissions = request.getParameter("permissions");
            Page page = this.pageManager.getPage(path);
            Fragment fragment = page.getFragmentById(fragmentId);
            if (fragment == null) {
                throw new IllegalStateException("Cannot find fragment: " + fragmentId);
            }
            SecurityConstraints constraints = fragment.getSecurityConstraints();
            if (constraints == null) {
                constraints = fragment.newSecurityConstraints();
            }
            SecurityConstraint constraint = fragment.newSecurityConstraint();
            Set roleSet = this.convertToSet(roles, DELIMITERS);
            Set groupSet = this.convertToSet(groups, DELIMITERS);
            Set userSet = this.convertToSet(users, DELIMITERS);
            if (!roleSet.isEmpty()) {
                constraint.setRoles(new ArrayList(roleSet));
            }
            if (!groupSet.isEmpty()) {
                constraint.setGroups(new ArrayList(groupSet));
            }
            if (!userSet.isEmpty()) {
                constraint.setUsers(new ArrayList(userSet));
            }
            Set permissionSet = this.convertToSet(permissions, DELIMITERS);
            constraint.setPermissions(new ArrayList(permissionSet));
            ArrayList<SecurityConstraint> constraintList = constraints.getSecurityConstraints();
            if (constraintList == null) {
                constraintList = new ArrayList<SecurityConstraint>();
            }
            constraintList.add(constraint);
            constraints.setSecurityConstraints(constraintList);
            fragment.setSecurityConstraints(constraints);
            this.pageManager.updatePage(page);
        }
        catch (Exception e) {
            throw new PortletException("Failed to add security constraint.", (Throwable)e);
        }
    }

    private void removeSecurityConstraint(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        try {
            String path = request.getParameter("path");
            String fragmentId = request.getParameter("fragment");
            String roles = request.getParameter("roles");
            String groups = request.getParameter("groups");
            String users = request.getParameter("users");
            String permissions = request.getParameter("permissions");
            Page page = this.pageManager.getPage(path);
            Fragment fragment = page.getFragmentById(fragmentId);
            if (fragment == null) {
                throw new IllegalStateException("Cannot find fragment: " + fragmentId);
            }
            SecurityConstraints constraints = fragment.getSecurityConstraints();
            List constraintList = null;
            if (constraints != null && (constraintList = constraints.getSecurityConstraints()) != null) {
                Iterator it = constraintList.iterator();
                while (it.hasNext()) {
                    SecurityConstraint constraint = (SecurityConstraint)it.next();
                    Set removeRoleSet = this.convertToSet(roles, DELIMITERS);
                    Set removeGroupSet = this.convertToSet(groups, DELIMITERS);
                    Set removeUserSet = this.convertToSet(users, DELIMITERS);
                    List roleList = constraint.getRoles();
                    List groupList = constraint.getGroups();
                    List userList = constraint.getUsers();
                    if (!this.equalsSetAndList(removeRoleSet, roleList) || !this.equalsSetAndList(removeGroupSet, groupList) || !this.equalsSetAndList(removeUserSet, userList)) continue;
                    it.remove();
                    break;
                }
            }
            if (constraints != null && constraintList != null) {
                constraints.setSecurityConstraints(constraintList);
            }
            fragment.setSecurityConstraints(constraints.isEmpty() ? null : constraints);
            this.pageManager.updatePage(page);
        }
        catch (Exception e) {
            throw new PortletException("Failed to remove security constraint.", (Throwable)e);
        }
    }

    private void updateSecurityConstraintRefs(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        try {
            String path = request.getParameter("path");
            String fragmentId = request.getParameter("fragment");
            String[] securityConstraintRefs = request.getParameterValues("securityConstraintRef");
            Page page = this.pageManager.getPage(path);
            Fragment fragment = page.getFragmentById(fragmentId);
            if (fragment == null) {
                throw new IllegalStateException("Cannot find fragment: " + fragmentId);
            }
            SecurityConstraints constraints = fragment.getSecurityConstraints();
            if (constraints == null) {
                constraints = fragment.newSecurityConstraints();
            }
            HashSet<String> constraintRefSet = new HashSet<String>();
            if (securityConstraintRefs != null) {
                for (int i = 0; i < securityConstraintRefs.length; ++i) {
                    if ("".equals(securityConstraintRefs[i])) continue;
                    constraintRefSet.add(securityConstraintRefs[i]);
                }
            }
            constraints.setSecurityConstraintsRefs((List)(constraintRefSet.isEmpty() ? null : new ArrayList(constraintRefSet)));
            fragment.setSecurityConstraints(constraints.isEmpty() ? null : constraints);
            this.pageManager.updatePage(page);
        }
        catch (Exception e) {
            throw new PortletException("Failed to remove security constraint.", (Throwable)e);
        }
    }

    private Set convertToSet(String s, String delimiters) {
        HashSet<String> set = new HashSet<String>();
        String[] tokens = StringUtils.tokenizeToStringArray((String)s, (String)delimiters, (boolean)true, (boolean)true);
        if (tokens != null) {
            for (int i = 0; i < tokens.length; ++i) {
                set.add(tokens[i]);
            }
        }
        return set;
    }

    private boolean equalsSetAndList(Set set, List list) {
        if (set == null) {
            return list == null || list.isEmpty();
        }
        if (list == null) {
            return set.isEmpty();
        }
        return ((Object)set).equals(new HashSet(list));
    }
}

