/*
 * Decompiled with CFR 0.152.
 */
package com.google.step2.xmlsimplesign;

import com.google.step2.util.EncodingUtil;
import java.io.ByteArrayInputStream;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;

public class CertUtil {
    public static X509Certificate getCertFromBase64Bytes(String b64cert) throws GeneralSecurityException {
        return CertUtil.getCertFromBytes(EncodingUtil.decodeBase64(b64cert));
    }

    public static X509Certificate getCertFromBytes(byte[] derCert) throws GeneralSecurityException {
        CertificateFactory fac = CertificateFactory.getInstance("X509");
        ByteArrayInputStream in = new ByteArrayInputStream(derCert);
        X509Certificate cert = (X509Certificate)fac.generateCertificate(in);
        return cert;
    }

    public static PrivateKey getPrivateKeyFromBytes(byte[] derKey) throws GeneralSecurityException {
        KeyFactory fac = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(derKey);
        return fac.generatePrivate(privKeySpec);
    }
}

