/*
 * Decompiled with CFR 0.152.
 */
package com.google.step2.util;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.DOMBuilder;
import org.xml.sax.SAXException;

public class XmlUtil {
    public static org.w3c.dom.Document getDocument(InputStream input) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = XmlUtil.getSecureDocumentBuilderFactory();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(input);
    }

    public static Document getJdomDocument(InputStream input) throws JDOMException, IOException {
        try {
            return new DOMBuilder().build(XmlUtil.getDocument(input));
        }
        catch (SAXException e) {
            throw new JDOMException("couldn't parse xml", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new JDOMException("could not configure parser", (Throwable)e);
        }
    }

    static DocumentBuilderFactory getSecureDocumentBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        return factory;
    }
}

