/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polygene.library.servlet.lifecycle;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.polygene.api.PolygeneAPI;
import org.apache.polygene.api.common.InvalidApplicationException;
import org.apache.polygene.api.structure.Application;
import org.apache.polygene.api.structure.ApplicationDescriptor;
import org.apache.polygene.bootstrap.ApplicationAssembler;
import org.apache.polygene.bootstrap.Energy4Java;
import org.apache.polygene.library.servlet.PolygeneServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPolygeneServletBootstrap
implements ServletContextListener,
ApplicationAssembler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)PolygeneServlet.class.getPackage().getName());
    protected PolygeneAPI api;
    protected Energy4Java polygene;
    protected ApplicationDescriptor applicationModel;
    protected Application application;

    public final void contextInitialized(ServletContextEvent sce) {
        try {
            ServletContext context = sce.getServletContext();
            LOGGER.trace("Assembling Application");
            this.polygene = new Energy4Java();
            this.applicationModel = this.polygene.newApplicationModel((ApplicationAssembler)this);
            LOGGER.trace("Instanciating and activating Application");
            this.application = this.applicationModel.newInstance(this.polygene.api(), new Object[0]);
            this.api = this.polygene.api();
            this.beforeApplicationActivation(this.application);
            this.application.activate();
            this.afterApplicationActivation(this.application);
            LOGGER.trace("Storing Application in ServletContext");
            context.setAttribute("polygene-application-servlet-context-attribute", (Object)this.application);
        }
        catch (Exception ex) {
            if (this.application != null) {
                try {
                    this.beforeApplicationPassivation(this.application);
                    this.application.passivate();
                    this.afterApplicationPassivation(this.application);
                }
                catch (Exception ex1) {
                    LOGGER.warn("Application not null and could not passivate it.", (Throwable)ex1);
                }
            }
            throw new InvalidApplicationException("Unexpected error during ServletContext initialization, see previous log for errors.", (Throwable)ex);
        }
    }

    protected void beforeApplicationActivation(Application app) {
    }

    protected void afterApplicationActivation(Application app) {
    }

    public final void contextDestroyed(ServletContextEvent sce) {
        try {
            if (this.application != null) {
                this.beforeApplicationPassivation(this.application);
                this.application.passivate();
                this.afterApplicationPassivation(this.application);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Unable to passivate Polygene Application.", (Throwable)ex);
        }
    }

    protected void beforeApplicationPassivation(Application app) {
    }

    protected void afterApplicationPassivation(Application app) {
    }
}

