/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polygene.library.invocationcache;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.polygene.api.common.AppliesTo;
import org.apache.polygene.api.concern.ConcernOf;
import org.apache.polygene.api.injection.scope.This;
import org.apache.polygene.library.invocationcache.Cached;
import org.apache.polygene.library.invocationcache.InvocationCache;

@AppliesTo(value={Cached.class})
public class ReturnCachedValueOnExceptionConcern
extends ConcernOf<InvocationHandler>
implements InvocationHandler {
    @This
    private InvocationCache cache;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        boolean voidReturnType = method.getReturnType().equals(Void.TYPE);
        if (this.cache != null || voidReturnType) {
            String cacheName = method.getName();
            if (args != null) {
                cacheName = cacheName + Arrays.asList(args);
            }
            try {
                Object result = ((InvocationHandler)this.next).invoke(proxy, method, args);
                this.cache.setCachedValue(cacheName, result);
                return result;
            }
            catch (Exception e) {
                return this.cache.cachedValue(cacheName);
            }
        }
        return ((InvocationHandler)this.next).invoke(proxy, method, args);
    }
}

