/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hmef.dev;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.poi.hmef.Attribute;
import org.apache.poi.hmef.MAPIAttribute;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public final class HMEFDumper {
    private InputStream inp;
    private boolean truncatePropertyData;

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            throw new IllegalArgumentException("Filename must be given");
        }
        boolean truncatePropData = true;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("--full")) {
                truncatePropData = false;
                continue;
            }
            HMEFDumper dumper = new HMEFDumper(new FileInputStream(args[i]));
            dumper.setTruncatePropertyData(truncatePropData);
            dumper.dump();
        }
    }

    public HMEFDumper(InputStream inp) throws IOException {
        this.inp = inp;
        long sig = LittleEndian.readInt((InputStream)inp);
        if (sig != 574529400L) {
            throw new IllegalArgumentException("TNEF signature not detected in file, expected 574529400 but got " + sig);
        }
        LittleEndian.readUShort((InputStream)inp);
    }

    public void setTruncatePropertyData(boolean truncate) {
        this.truncatePropertyData = truncate;
    }

    private void dump() throws IOException {
        int level;
        while ((level = this.inp.read()) != -1) {
            Attribute attr = new Attribute(this.inp);
            System.out.println("Level " + level + " : Type " + attr.getType() + " : ID " + attr.getId().toString());
            String indent = "  ";
            System.out.println(indent + "Data of length " + attr.getData().length);
            if (attr.getData().length > 0) {
                int loops;
                int len = attr.getData().length;
                if (this.truncatePropertyData) {
                    len = Math.min(attr.getData().length, 48);
                }
                if ((loops = len / 16) == 0) {
                    loops = 1;
                }
                for (int i = 0; i < loops; ++i) {
                    int thisLen = 16;
                    int offset = i * 16;
                    if (i == loops - 1) {
                        thisLen = len - offset;
                    }
                    byte[] data = new byte[thisLen];
                    System.arraycopy(attr.getData(), offset, data, 0, thisLen);
                    System.out.print(indent + HexDump.dump((byte[])data, (long)0L, (int)0));
                }
            }
            System.out.println();
            if (attr.getId() != Attribute.ID_MAPIPROPERTIES) continue;
            List<MAPIAttribute> attrs = MAPIAttribute.create(attr);
            for (MAPIAttribute ma : attrs) {
                System.out.println(indent + indent + ma);
            }
            System.out.println();
        }
    }
}

