/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hmef;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.poi.hmef.CompressedRTF;
import org.apache.poi.hmef.MAPIAttribute;
import org.apache.poi.hsmf.datatypes.MAPIProperty;
import org.apache.poi.util.StringUtil;

public final class MAPIRtfAttribute
extends MAPIAttribute {
    private final String data;

    public MAPIRtfAttribute(MAPIProperty property, int type, byte[] data) throws IOException {
        super(property, type, data);
        CompressedRTF rtf = new CompressedRTF();
        byte[] decomp = rtf.decompress(new ByteArrayInputStream(data));
        this.data = StringUtil.getFromCompressedUnicode((byte[])decomp, (int)0, (int)decomp.length);
    }

    public String getDataString() {
        return this.data;
    }

    public String toString() {
        return this.getProperty().toString() + " " + this.data;
    }
}

