/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hmef;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndian;

public final class Attribute {
    public static final int TYPE_TRIPLES = 0;
    public static final int TYPE_STRING = 1;
    public static final int TYPE_TEXT = 2;
    public static final int TYPE_DATE = 3;
    public static final int TYPE_SHORT = 4;
    public static final int TYPE_LONG = 5;
    public static final int TYPE_BYTE = 6;
    public static final int TYPE_WORD = 7;
    public static final int TYPE_DWORD = 8;
    public static final int TYPE_MAX = 9;
    public static final int PTYPE_APPTIME = 7;
    public static final int PTYPE_BINARY = 258;
    public static final int PTYPE_BOOLEAN = 11;
    public static final int PTYPE_CLASSID = 72;
    public static final int PTYPE_CURRENCY = 6;
    public static final int PTYPE_DOUBLE = 5;
    public static final int PTYPE_ERROR = 10;
    public static final int PTYPE_I2 = 2;
    public static final int PTYPE_I8 = 20;
    public static final int PTYPE_LONG = 3;
    public static final int PTYPE_MULTIVALUED = 4096;
    public static final int PTYPE_NULL = 1;
    public static final int PTYPE_OBJECT = 13;
    public static final int PTYPE_R4 = 4;
    public static final int PTYPE_STRING8 = 30;
    public static final int PTYPE_SYSTIME = 64;
    public static final int PTYPE_UNICODE = 31;
    public static final int PTYPE_UNSPECIFIED = 0;
    public static final int LEVEL_MESSAGE = 1;
    public static final int LEVEL_ATTACHMENT = 2;
    public static final int LEVEL_END_OF_FILE = -1;
    public static final AttributeID ID_AIDOWNER = new AttributeID(8, 5, "AidOwner", "PR_OWNER_APPT_ID");
    public static final AttributeID ID_ATTACHCREATEDATE = new AttributeID(32786, 3, "AttachCreateDate", "PR_CREATION_TIME");
    public static final AttributeID ID_ATTACHDATA = new AttributeID(32783, 6, "AttachData", "PR_ATTACH_DATA_BIN");
    public static final AttributeID ID_ATTACHMENT = new AttributeID(36869, 6, "Attachment", null);
    public static final AttributeID ID_ATTACHMETAFILE = new AttributeID(32785, 6, "AttachMetaFile", "PR_ATTACH_RENDERING");
    public static final AttributeID ID_ATTACHMODIFYDATE = new AttributeID(32787, 3, "AttachModifyDate", "PR_LAST_MODIFICATION_TIME");
    public static final AttributeID ID_ATTACHRENDERDATA = new AttributeID(36866, 6, "AttachRenderData", "attAttachRenddata");
    public static final AttributeID ID_ATTACHTITLE = new AttributeID(32784, 1, "AttachTitle", "PR_ATTACH_FILENAME");
    public static final AttributeID ID_ATTACHTRANSPORTFILENAME = new AttributeID(36865, 6, "AttachTransportFilename", "PR_ATTACH_TRANSPORT_NAME");
    public static final AttributeID ID_BODY = new AttributeID(32780, 2, "Body", "PR_BODY");
    public static final AttributeID ID_CONVERSATIONID = new AttributeID(32779, 1, "ConversationId", "PR_CONVERSATION_KEY");
    public static final AttributeID ID_DATEEND = new AttributeID(7, 3, "DateEnd", "PR_END_DATE");
    public static final AttributeID ID_DATEMODIFIED = new AttributeID(32800, 3, "DateModified", "PR_LAST_MODIFICATION_TIME ");
    public static final AttributeID ID_DATERECEIVED = new AttributeID(32774, 3, "DateReceived", "PR_MESSAGE_DELIVERY_TIME ");
    public static final AttributeID ID_DATESENT = new AttributeID(32773, 3, "DateSent", "PR_CLIENT_SUBMIT_TIME ");
    public static final AttributeID ID_DATESTART = new AttributeID(6, 3, "DateStart", "PR_START_DATE ");
    public static final AttributeID ID_DELEGATE = new AttributeID(2, 6, "Delegate", "PR_RCVD_REPRESENTING_xxx ");
    public static final AttributeID ID_FROM = new AttributeID(32768, 1, "From", "PR_SENDER_ENTRYID");
    public static final AttributeID ID_MAPIPROPERTIES = new AttributeID(36867, 6, "MapiProperties", null);
    public static final AttributeID ID_MESSAGECLASS = new AttributeID(32776, 7, "MessageClass", "PR_MESSAGE_CLASS ");
    public static final AttributeID ID_MESSAGEID = new AttributeID(32777, 1, "MessageId", "PR_SEARCH_KEY");
    public static final AttributeID ID_MESSAGESTATUS = new AttributeID(32775, 6, "MessageStatus", "PR_MESSAGE_FLAGS");
    public static final AttributeID ID_NULL = new AttributeID(0, -1, "Null", null);
    public static final AttributeID ID_OEMCODEPAGE = new AttributeID(36871, 6, "OemCodepage", "AttOemCodepage");
    public static final AttributeID ID_ORIGINALMESSAGECLASS = new AttributeID(6, 7, "OriginalMessageClass", "PR_ORIG_MESSAGE_CLASS");
    public static final AttributeID ID_OWNER = new AttributeID(0, 6, "Owner", "PR_RCVD_REPRESENTING_xxx");
    public static final AttributeID ID_PARENTID = new AttributeID(32778, 1, "ParentId", "PR_PARENT_KEY");
    public static final AttributeID ID_PRIORITY = new AttributeID(32781, 4, "Priority", "PR_IMPORTANCE");
    public static final AttributeID ID_RECIPIENTTABLE = new AttributeID(36868, 6, "RecipientTable", "PR_MESSAGE_RECIPIENTS");
    public static final AttributeID ID_REQUESTRESPONSE = new AttributeID(9, 4, "RequestResponse", "PR_RESPONSE_REQUESTED");
    public static final AttributeID ID_SENTFOR = new AttributeID(1, 6, "SentFor", "PR_SENT_REPRESENTING_xxx");
    public static final AttributeID ID_SUBJECT = new AttributeID(32772, 1, "Subject", "PR_SUBJECT");
    public static final AttributeID ID_TNEFVERSION = new AttributeID(36870, 8, "TnefVersion", "attTnefVersion");
    public static final AttributeID ID_UNKNOWN = new AttributeID(-1, -1, "Unknown", null);
    private final AttributeID id;
    private final int type;
    private final byte[] data;
    private final int checksum;

    public Attribute(InputStream inp) throws IOException {
        int id = LittleEndian.readUShort((InputStream)inp);
        this.type = LittleEndian.readUShort((InputStream)inp);
        int length = LittleEndian.readInt((InputStream)inp);
        this.id = AttributeID.getBest(id, this.type);
        this.data = new byte[length];
        IOUtils.readFully((InputStream)inp, (byte[])this.data);
        this.checksum = LittleEndian.readUShort((InputStream)inp);
    }

    public AttributeID getId() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }

    public byte[] getData() {
        return this.data;
    }

    public String toString() {
        return "Attachment " + this.getId().toString() + ", type=" + this.type + ", data length=" + this.data.length;
    }

    public static class AttributeID {
        private static Map<Integer, List<AttributeID>> attributes = new HashMap<Integer, List<AttributeID>>();
        public final int id;
        public final int usualType;
        public final String name;
        public final String mapiProperty;

        private AttributeID(int id, int usualType, String name, String mapiProperty) {
            this.id = id;
            this.usualType = usualType;
            this.name = name;
            this.mapiProperty = mapiProperty;
            if (!attributes.containsKey(id)) {
                attributes.put(id, new ArrayList());
            }
            attributes.get(id).add(this);
        }

        public static AttributeID getBest(int id, int type) {
            List<AttributeID> attrs = attributes.get(id);
            if (attrs == null) {
                return ID_UNKNOWN;
            }
            if (attrs.size() == 1) {
                return attrs.get(0);
            }
            for (AttributeID attr : attrs) {
                if (attr.usualType != type) continue;
                return attr;
            }
            return attrs.get(0);
        }

        public String toString() {
            StringBuffer str = new StringBuffer();
            str.append(this.name);
            str.append(" [");
            str.append(this.id);
            str.append("]");
            if (this.mapiProperty != null) {
                str.append(" (");
                str.append(this.mapiProperty);
                str.append(")");
            }
            return str.toString();
        }
    }
}

