/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.POIXMLException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.model.XSSFWritableModel;

public class XSSFActiveXData
implements PictureData,
XSSFWritableModel {
    private PackagePart packagePart;
    private String originalId;

    public XSSFActiveXData(PackagePart packagePart, String originalId) {
        this(packagePart);
        this.originalId = originalId;
    }

    public XSSFActiveXData(PackagePart packagePart) {
        this.packagePart = packagePart;
    }

    public String getOriginalId() {
        return this.originalId;
    }

    public PackagePart getPart() {
        return this.packagePart;
    }

    public void writeTo(OutputStream out) throws IOException {
        IOUtils.copy((InputStream)this.packagePart.getInputStream(), (OutputStream)out);
    }

    public byte[] getData() {
        try {
            return IOUtils.toByteArray((InputStream)this.packagePart.getInputStream());
        }
        catch (IOException e) {
            throw new POIXMLException(e);
        }
    }

    public String suggestFileExtension() {
        return this.packagePart.getPartName().getExtension();
    }
}

