/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.df1.field;

import java.util.Collections;
import java.util.List;
import org.apache.plc4x.java.api.model.ArrayInfo;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.df1.types.DataType;

public class Df1Tag
implements PlcTag {
    private final int address;
    private final int size;
    private final DataType dataType;
    private final AddressType addressType;

    public Df1Tag(int address, int size, DataType dataType, AddressType addressType) {
        this.address = address;
        this.size = size;
        this.dataType = dataType;
        this.addressType = addressType;
    }

    public String getAddressString() {
        return String.format("%d:%s", this.address, this.addressType.toString());
    }

    public PlcValueType getPlcValueType() {
        return this.dataType.getPlcValueType();
    }

    public List<ArrayInfo> getArrayInfo() {
        return Collections.emptyList();
    }

    public int getAddress() {
        return this.address;
    }

    public int getSize() {
        return this.size;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public AddressType getAddressType() {
        return this.addressType;
    }

    public static PlcTag of(String fieldQuery) {
        String[] tmp = fieldQuery.split(":");
        return new Df1Tag(Integer.parseInt(tmp[0]), DataType.valueOf(tmp[1]).getLength(), DataType.valueOf(tmp[1]), AddressType.OFFSET);
    }

    public static enum AddressType {
        OFFSET,
        LOGICAL;

    }
}

