/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.df1.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class DF1Symbol implements Message {

  // Abstract accessors for discriminator values.
  public abstract Short getSymbolType();

  // Constant values.
  public static final Short MESSAGESTART = 0x10;

  public DF1Symbol() {
    super();
  }

  public short getMessageStart() {
    return MESSAGESTART;
  }

  protected abstract void serializeDF1SymbolChild(WriteBuffer writeBuffer)
      throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("DF1Symbol");

    // Const Field (messageStart)
    writeConstField(
        "messageStart",
        MESSAGESTART,
        writeUnsignedShort(writeBuffer, 8),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Discriminator Field (symbolType) (Used as input to a switch field)
    writeDiscriminatorField(
        "symbolType",
        getSymbolType(),
        writeUnsignedShort(writeBuffer, 8),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Switch field (Serialize the sub-type)
    serializeDF1SymbolChild(writeBuffer);

    writeBuffer.popContext("DF1Symbol");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    DF1Symbol _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Const Field (messageStart)
    lengthInBits += 8;

    // Discriminator Field (symbolType)
    lengthInBits += 8;

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static DF1Symbol staticParse(ReadBuffer readBuffer, Object... args) throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static DF1Symbol staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("DF1Symbol");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short messageStart =
        readConstField(
            "messageStart",
            readUnsignedShort(readBuffer, 8),
            DF1Symbol.MESSAGESTART,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    short symbolType =
        readDiscriminatorField(
            "symbolType",
            readUnsignedShort(readBuffer, 8),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    DF1SymbolBuilder builder = null;
    if (EvaluationHelper.equals(symbolType, (short) 0x02)) {
      builder = DF1SymbolMessageFrame.staticParseDF1SymbolBuilder(readBuffer);
    } else if (EvaluationHelper.equals(symbolType, (short) 0x06)) {
      builder = DF1SymbolMessageFrameACK.staticParseDF1SymbolBuilder(readBuffer);
    } else if (EvaluationHelper.equals(symbolType, (short) 0x15)) {
      builder = DF1SymbolMessageFrameNAK.staticParseDF1SymbolBuilder(readBuffer);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "symbolType="
              + symbolType
              + "]");
    }

    readBuffer.closeContext("DF1Symbol");
    // Create the instance
    DF1Symbol _dF1Symbol = builder.build();
    return _dF1Symbol;
  }

  public interface DF1SymbolBuilder {
    DF1Symbol build();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof DF1Symbol)) {
      return false;
    }
    DF1Symbol that = (DF1Symbol) o;
    return true;
  }

  @Override
  public int hashCode() {
    return Objects.hash();
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
