/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.df1.readwrite.utils;

import com.github.snksoft.crc.CRC;
import org.apache.plc4x.java.df1.readwrite.DF1Command;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;

public class StaticHelper {
    public static int crcCheck(short destinationAddress, short sourceAddress, DF1Command command) {
        CRC crc = new CRC(new CRC.Parameters(16, 32773L, 0L, true, true, 0L));
        long df1crc = crc.init();
        df1crc = crc.update(df1crc, new byte[]{(byte)destinationAddress, (byte)sourceAddress});
        WriteBufferByteBased writeBuffer = new WriteBufferByteBased(command.getLengthInBytes(), ByteOrder.BIG_ENDIAN);
        try {
            command.serialize((WriteBuffer)writeBuffer);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        df1crc = crc.update(df1crc, writeBuffer.getData());
        df1crc = crc.update(df1crc, new byte[]{3});
        return crc.finalCRC16(df1crc) & 0xFFFF;
    }

    public static boolean dataTerminate(ReadBuffer io) {
        ReadBufferByteBased rbbb = (ReadBufferByteBased)io;
        try {
            if (rbbb.peekByte(0) == 16 && rbbb.peekByte(1) == 3) {
                return true;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return false;
    }

    public static short readData(ReadBuffer io) {
        ReadBufferByteBased rbbb = (ReadBufferByteBased)io;
        try {
            if (rbbb.peekByte(0) == 16 && rbbb.peekByte(1) == 16) {
                io.readByte();
            }
            return io.readUnsignedShort(8);
        }
        catch (ParseException e) {
            throw new RuntimeException("Error parsing data", e);
        }
    }

    public static void writeData(WriteBuffer io, short data) {
        try {
            if (data == 16) {
                io.writeUnsignedShort(8, (short)16);
            }
            io.writeUnsignedShort(8, data);
        }
        catch (SerializationException e) {
            throw new RuntimeException("Error parsing data", e);
        }
    }

    public static int dataLength(byte[] data) {
        int i = 0;
        byte[] byArray = data;
        int n = byArray.length;
        for (int j = 0; j < n; ++j) {
            short dataByte = byArray[j];
            if (dataByte == 16) {
                ++i;
            }
            ++i;
        }
        return i;
    }
}

