/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.df1.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.df1.readwrite.DF1Command;
import org.apache.plc4x.java.df1.readwrite.DF1Symbol;
import org.apache.plc4x.java.df1.readwrite.utils.StaticHelper;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class DF1SymbolMessageFrame
extends DF1Symbol
implements Message {
    public static final Short MESSAGEEND = 16;
    public static final Short ENDTRANSACTION = 3;
    protected final short destinationAddress;
    protected final short sourceAddress;
    protected final DF1Command command;

    @Override
    public Short getSymbolType() {
        return (short)2;
    }

    public DF1SymbolMessageFrame(short destinationAddress, short sourceAddress, DF1Command command) {
        this.destinationAddress = destinationAddress;
        this.sourceAddress = sourceAddress;
        this.command = command;
    }

    public short getDestinationAddress() {
        return this.destinationAddress;
    }

    public short getSourceAddress() {
        return this.sourceAddress;
    }

    public DF1Command getCommand() {
        return this.command;
    }

    public short getMessageEnd() {
        return MESSAGEEND;
    }

    public short getEndTransaction() {
        return ENDTRANSACTION;
    }

    @Override
    protected void serializeDF1SymbolChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("DF1SymbolMessageFrame", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"destinationAddress", (Object)this.destinationAddress, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        FieldWriterFactory.writeSimpleField((String)"sourceAddress", (Object)this.sourceAddress, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        FieldWriterFactory.writeSimpleField((String)"command", (Object)this.command, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        FieldWriterFactory.writeConstField((String)"messageEnd", (Object)MESSAGEEND, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeConstField((String)"endTransaction", (Object)ENDTRANSACTION, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeChecksumField((String)"crc", (Object)StaticHelper.crcCheck(this.destinationAddress, this.sourceAddress, this.command), (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("DF1SymbolMessageFrame", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        DF1SymbolMessageFrame _value = this;
        lengthInBits += 8;
        lengthInBits += 8;
        lengthInBits += this.command.getLengthInBits();
        lengthInBits += 8;
        lengthInBits += 8;
        return lengthInBits += 16;
    }

    public static DF1SymbolMessageFrameBuilder staticParseBuilder(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("DF1SymbolMessageFrame", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        short destinationAddress = (Short)FieldReaderFactory.readSimpleField((String)"destinationAddress", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        short sourceAddress = (Short)FieldReaderFactory.readSimpleField((String)"sourceAddress", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        DF1Command command = (DF1Command)FieldReaderFactory.readSimpleField((String)"command", (DataReader)new DataReaderComplexDefault(() -> DF1Command.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        short messageEnd = (Short)FieldReaderFactory.readConstField((String)"messageEnd", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (Object)MESSAGEEND, (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        short endTransaction = (Short)FieldReaderFactory.readConstField((String)"endTransaction", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (Object)ENDTRANSACTION, (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        int crc = (Integer)FieldReaderFactory.readChecksumField((String)"crc", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (Object)StaticHelper.crcCheck(destinationAddress, sourceAddress, command), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        readBuffer.closeContext("DF1SymbolMessageFrame", new WithReaderArgs[0]);
        return new DF1SymbolMessageFrameBuilder(destinationAddress, sourceAddress, command);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DF1SymbolMessageFrame)) {
            return false;
        }
        DF1SymbolMessageFrame that = (DF1SymbolMessageFrame)o;
        return this.getDestinationAddress() == that.getDestinationAddress() && this.getSourceAddress() == that.getSourceAddress() && this.getCommand() == that.getCommand() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getDestinationAddress(), this.getSourceAddress(), this.getCommand());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class DF1SymbolMessageFrameBuilder
    implements DF1Symbol.DF1SymbolBuilder {
        private final short destinationAddress;
        private final short sourceAddress;
        private final DF1Command command;

        public DF1SymbolMessageFrameBuilder(short destinationAddress, short sourceAddress, DF1Command command) {
            this.destinationAddress = destinationAddress;
            this.sourceAddress = sourceAddress;
            this.command = command;
        }

        @Override
        public DF1SymbolMessageFrame build() {
            DF1SymbolMessageFrame dF1SymbolMessageFrame = new DF1SymbolMessageFrame(this.destinationAddress, this.sourceAddress, this.command);
            return dF1SymbolMessageFrame;
        }
    }
}

