/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.df1.protocol;

import io.netty.channel.ChannelHandlerContext;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcRequest;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.df1.field.Df1Field;
import org.apache.plc4x.java.df1.readwrite.DF1Command;
import org.apache.plc4x.java.df1.readwrite.DF1Symbol;
import org.apache.plc4x.java.df1.readwrite.DF1SymbolMessageFrame;
import org.apache.plc4x.java.df1.readwrite.DF1SymbolMessageFrameACK;
import org.apache.plc4x.java.df1.readwrite.DF1SymbolMessageFrameNAK;
import org.apache.plc4x.java.df1.readwrite.DF1UnprotectedReadRequest;
import org.apache.plc4x.java.df1.readwrite.DF1UnprotectedReadResponse;
import org.apache.plc4x.java.spi.PlcMessageToMessageCodec;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.spi.messages.PlcRequestContainer;
import org.apache.plc4x.java.spi.messages.utils.ResponseItem;
import org.apache.plc4x.java.spi.values.PlcDINT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class Plc4XDf1Protocol
extends PlcMessageToMessageCodec<DF1Symbol, PlcRequestContainer> {
    private static final Logger logger = LoggerFactory.getLogger(Plc4XDf1Protocol.class);
    private final AtomicInteger transactionId = new AtomicInteger(1);
    private Map<Integer, PlcRequestContainer> requests = new ConcurrentHashMap<Integer, PlcRequestContainer>();

    protected void encode(ChannelHandlerContext ctx, PlcRequestContainer msg, List<Object> out) throws Exception {
        logger.trace("Received Request {} to send out", (Object)msg);
        if (msg.getRequest() instanceof PlcReadRequest) {
            for (PlcField field : ((PlcReadRequest)msg.getRequest()).getFields()) {
                if (!(field instanceof Df1Field)) {
                    throw new IllegalArgumentException("Invalid field type found inside Df1 Request");
                }
                int address = ((Df1Field)field).getAddress();
                short size = ((Df1Field)field).getDataType().getLength();
                int transactionId = this.transactionId.getAndIncrement();
                while ((transactionId & 0xFF) == 16 || (transactionId >>> 8 & 0xFF) == 16) {
                    transactionId = this.transactionId.getAndIncrement();
                }
                logger.debug("Creating request for offset {}, with length {} and transaction id {}", new Object[]{address, size, transactionId});
                this.requests.put(transactionId, msg);
                switch (((Df1Field)field).getAddress_type()) {
                    case OFFSET: {
                        out.add(new DF1UnprotectedReadRequest(0, (short)transactionId, address, size));
                        break;
                    }
                    case LOGICAL: {
                        throw new NotImplementedException("not yet implemented in mspec");
                    }
                }
            }
        } else {
            throw new IllegalStateException("This should not happen!");
        }
    }

    protected void decode(ChannelHandlerContext ctx, DF1Symbol msg, List<Object> out) throws Exception {
        logger.debug("Received DF1 Command incoming {}", (Object)msg);
        if (msg instanceof DF1SymbolMessageFrameNAK) {
            logger.warn("Received a response NAK, notify all requests");
            for (Map.Entry<Integer, PlcRequestContainer> entry : this.requests.entrySet()) {
                entry.getValue().getResponseFuture().complete(new DefaultPlcReadResponse((PlcReadRequest)entry.getValue().getRequest(), Collections.singletonMap("erster", new ResponseItem(PlcResponseCode.INTERNAL_ERROR, (Object)new PlcDINT(-1)))));
            }
            return;
        }
        if (msg instanceof DF1SymbolMessageFrameACK) {
            logger.warn("Received a response ACK :D");
            return;
        }
        assert (msg instanceof DF1SymbolMessageFrame);
        DF1Command command = ((DF1SymbolMessageFrame)msg).getCommand();
        int transactionId = command.getTransactionCounter();
        if (!this.requests.containsKey(transactionId)) {
            logger.warn("Received a response to unknown transaction id {}", (Object)transactionId);
            ctx.fireExceptionCaught((Throwable)new RuntimeException("Received a response to unknown transaction id"));
            ctx.close();
            return;
        }
        PlcRequestContainer requestContainer = this.requests.remove(transactionId);
        PlcRequest request = requestContainer.getRequest();
        DefaultPlcReadResponse response = null;
        if (request instanceof PlcReadRequest) {
            String fieldName = (String)((PlcReadRequest)request).getFieldNames().iterator().next();
            PlcResponseCode responseCode = PlcResponseCode.OK;
            Df1Field field = (Df1Field)((PlcReadRequest)request).getField(fieldName);
            PlcDINT responseItem = null;
            byte[] data = ((DF1UnprotectedReadResponse)command).getData();
            switch (field.getDataType()) {
                case BIT: {
                    break;
                }
                case INTEGER: {
                    responseItem = new PlcDINT(data[0] + (data[1] << 8));
                    break;
                }
                case FLOAT: {
                    break;
                }
                case BIT_STRING: {
                    break;
                }
                case ARRAY: {
                    break;
                }
                default: {
                    throw new NotImplementedException("The DataType " + String.valueOf((Object)field.getDataType()) + " is currently not implemented!");
                }
            }
            response = new DefaultPlcReadResponse((PlcReadRequest)request, Collections.singletonMap(fieldName, new ResponseItem(responseCode, responseItem)));
        } else if (request instanceof PlcWriteRequest) {
            logger.warn("Writing is currently not implemented but received a write response?!");
            ctx.close();
            throw new NotImplementedException("This is currently not implemented!");
        }
        if (response != null) {
            requestContainer.getResponseFuture().complete(response);
        }
    }
}

