/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.df1.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import java.util.List;
import org.apache.plc4x.java.api.exceptions.PlcProtocolException;
import org.apache.plc4x.java.df1.readwrite.DF1Command;
import org.apache.plc4x.java.df1.readwrite.DF1Symbol;
import org.apache.plc4x.java.df1.readwrite.DF1SymbolMessageFrame;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class Df1Protocol
extends ByteToMessageCodec<DF1Command> {
    private static final Logger logger = LoggerFactory.getLogger(Df1Protocol.class);
    private final short localAddr;
    private final short remoteAddr;

    public Df1Protocol(short localAddr, short remoteAddr) {
        this.localAddr = localAddr;
        this.remoteAddr = remoteAddr;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
    }

    protected void encode(ChannelHandlerContext ctx, DF1Command msg, ByteBuf out) throws Exception {
        DF1SymbolMessageFrame frame = new DF1SymbolMessageFrame(this.remoteAddr, this.localAddr, msg);
        WriteBufferByteBased writeBuffer = new WriteBufferByteBased(frame.getLengthInBytes());
        frame.serialize((WriteBuffer)writeBuffer);
        byte[] data = writeBuffer.getData();
        out.writeBytes(data);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        in.markReaderIndex();
        boolean size = false;
        if (in.readableBytes() > 1) {
            if (in.getUnsignedByte(0) != 16) {
                logger.warn("Expecting DF1 magic number: {}", (Object)16);
                if (logger.isDebugEnabled()) {
                    logger.debug("Got Data: {}", (Object)ByteBufUtil.hexDump((ByteBuf)in));
                }
                this.exceptionCaught(ctx, (Throwable)new PlcProtocolException(String.format("Expecting DF1 magic number: %02X", 16)));
                return;
            }
            short symbolType = in.getUnsignedByte(1);
            switch (symbolType) {
                case 2: {
                    if (in.readableBytes() < 5) {
                        return;
                    }
                    short commandType = in.getUnsignedByte(4);
                    switch (commandType) {
                        case 1: {
                            if (in.readableBytes() >= 11) break;
                            return;
                        }
                    }
                    break;
                }
                case 3: {
                    if (in.readableBytes() >= 4) break;
                    return;
                }
            }
        }
        byte[] data = new byte[in.readableBytes()];
        in.readBytes(data);
        ReadBufferByteBased readBuffer = new ReadBufferByteBased(data);
        DF1Symbol resp = DF1Symbol.staticParse((ReadBuffer)readBuffer);
        out.add(resp);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.warn("exception caught", cause);
        ctx.close();
    }
}

