/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.protocol.bacnetip;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.plc4x.plugins.codegenerator.protocol.TypeContext;
import org.apache.plc4x.plugins.codegenerator.types.definitions.ComplexTypeDefinition;
import org.apache.plc4x.plugins.codegenerator.types.definitions.DiscriminatedComplexTypeDefinition;
import org.apache.plc4x.plugins.codegenerator.types.definitions.EnumTypeDefinition;
import org.apache.plc4x.plugins.codegenerator.types.definitions.TypeDefinition;
import org.apache.plc4x.plugins.codegenerator.types.definitions.TypeDefinitionConversions;
import org.apache.plc4x.plugins.codegenerator.types.enums.EnumValue;
import org.apache.plc4x.plugins.codegenerator.types.fields.FieldConversions;
import org.apache.plc4x.plugins.codegenerator.types.fields.ValidationField;
import org.apache.plc4x.protocol.bacnetip.BACnetObjectsDefinitions;
import org.apache.plc4x.protocol.bacnetip.BacNetIpProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DynamicContainer;
import org.junit.jupiter.api.DynamicNode;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestFactory;
import org.opentest4j.TestAbortedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectPropertyDeDuplicationTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectPropertyDeDuplicationTest.class);
    public static final String BACNET_OBJECT_TYPE_TYPE_NAME = "BACnetObjectType";
    public static final String BACNET_PROPERTY_IDENTIFIER_TYPE_NAME = "BACnetPropertyIdentifier";
    Map<String, TypeDefinition> typeDefinitions;

    @BeforeEach
    void setUp() throws Exception {
        TypeContext typeContext = new BacNetIpProtocol().getTypeContext();
        this.typeDefinitions = typeContext.getTypeDefinitions();
    }

    @TestFactory
    Collection<DynamicNode> testThatEveryObjectIsMapped() {
        LinkedList<DynamicNode> tests = new LinkedList<DynamicNode>();
        TypeDefinition baCnetObjectType = this.typeDefinitions.get(BACNET_OBJECT_TYPE_TYPE_NAME);
        Assertions.assertNotNull((Object)baCnetObjectType, (String)"We could not find essential type BACnetObjectType");
        EnumTypeDefinition baCnetObjectTypeEnumTypeDefinition = (EnumTypeDefinition)baCnetObjectType;
        for (EnumValue enumValue : baCnetObjectTypeEnumTypeDefinition.getEnumValues()) {
            String objectName = enumValue.getName();
            if ("VENDOR_PROPRIETARY_VALUE".equals(objectName)) continue;
            tests.add((DynamicNode)DynamicTest.dynamicTest((String)("Test definition for " + objectName), () -> {
                Assertions.assertNotNull((Object)objectName);
                Assertions.assertNotNull((Object)BACnetObjectsDefinitions.objectNameToBacNetObjectMap.get(objectName), (String)(String.valueOf(objectName) + " has no definition"));
            }));
        }
        return tests;
    }

    @TestFactory
    Collection<DynamicNode> testThatEveryPropertyIsUsed() {
        LinkedList<DynamicNode> tests = new LinkedList<DynamicNode>();
        TypeDefinition baCnetPropertyIdentifier = this.typeDefinitions.get(BACNET_PROPERTY_IDENTIFIER_TYPE_NAME);
        Assertions.assertNotNull((Object)baCnetPropertyIdentifier, (String)"We could not find essential type BACnetObjectType");
        EnumTypeDefinition baCnetPropertyIdentifierEnumTypeDefinition = (EnumTypeDefinition)baCnetPropertyIdentifier;
        for (EnumValue enumValue : baCnetPropertyIdentifierEnumTypeDefinition.getEnumValues()) {
            String propertyIdentifier = enumValue.getName();
            if ("VENDOR_PROPRIETARY_VALUE".equals(propertyIdentifier)) continue;
            tests.add((DynamicNode)DynamicTest.dynamicTest((String)("Test definition for " + propertyIdentifier), () -> {
                switch (propertyIdentifier) {
                    case "ALL": 
                    case "PROCESS_IDENTIFIER": 
                    case "REQUIRED": 
                    case "OPTIONAL": 
                    case "LOG_DEVICE_OBJECT_PROPERTY": 
                    case "PROTOCOL_CONFORMANCE_CLASS": {
                        throw new TestAbortedException(String.valueOf(propertyIdentifier) + " not in use");
                    }
                }
                Assertions.assertNotNull((Object)propertyIdentifier);
                Assertions.assertTrue((boolean)BACnetObjectsDefinitions.propertyIdToPropertyNameMap.containsKey(propertyIdentifier), (String)(String.valueOf(propertyIdentifier) + " has no usage"));
            }));
        }
        return tests;
    }

    @TestFactory
    Collection<DynamicNode> testUniqueUsagesAreMappedGeneric() {
        LinkedList<DynamicNode> tests = new LinkedList<DynamicNode>();
        new LinkedList<Map.Entry<String, List<String>>>(BACnetObjectsDefinitions.propertyToObjectNamesMap.entrySet()).stream().filter(propertyToObjectNamesEntry -> ((List)propertyToObjectNamesEntry.getValue()).size() == 1).sorted(Comparator.comparing(stringListEntry -> (String)((List)stringListEntry.getValue()).get(0))).forEach(propertyToObjectNameEntry -> {
            String propertyIdentifier = (String)propertyToObjectNameEntry.getKey();
            String bacNetObjectName = (String)((List)propertyToObjectNameEntry.getValue()).get(0);
            tests.add((DynamicNode)DynamicTest.dynamicTest((String)(String.valueOf(bacNetObjectName) + " uses property " + propertyIdentifier + " uniquely"), () -> {
                String searchedTypeName = "BACnetConstructedData" + propertyIdentifier;
                switch (searchedTypeName = searchedTypeName.replaceAll("_", "")) {
                    case "BACnetConstructedDataOutofService": {
                        searchedTypeName = "BACnetConstructedDataOutOfService";
                    }
                }
                Assertions.assertNotNull((Object)this.typeDefinitions.get(searchedTypeName), (String)(String.valueOf(searchedTypeName) + " not found"));
            }));
        });
        return tests;
    }

    @TestFactory
    Collection<DynamicNode> testNonUniqueUsagesAreMappedGeneric() {
        LinkedList<DynamicNode> tests = new LinkedList<DynamicNode>();
        new LinkedList<Map.Entry<BACnetObjectsDefinitions.PropertyTypeCombination, List<String>>>(BACnetObjectsDefinitions.propertyTypeCombinationToObjectNameMap.entrySet()).stream().sorted(Map.Entry.comparingByKey()).forEach(propertyTypeCombinationToObjectNameEntry -> {
            BACnetObjectsDefinitions.PropertyTypeCombination propertyTypeCombination = (BACnetObjectsDefinitions.PropertyTypeCombination)propertyTypeCombinationToObjectNameEntry.getKey();
            ((List)propertyTypeCombinationToObjectNameEntry.getValue()).forEach(bacNetObjectName -> {
                String propertyIdentifier = propertyTypeCombination.propertyIdentifier;
                Set<String> listOfTypes = BACnetObjectsDefinitions.propertyToPropertyTypesMaps.get(propertyIdentifier);
                if (listOfTypes.size() < 2) {
                    tests.add((DynamicNode)DynamicTest.dynamicTest((String)(propertyTypeCombination + " is used by " + bacNetObjectName + " uses property shared with all having the same type"), () -> {
                        String searchedTypeName = "BACnetConstructedData" + propertyIdentifier;
                        switch (searchedTypeName = searchedTypeName.replaceAll("_", "")) {
                            case "BACnetConstructedDataOutofService": {
                                searchedTypeName = "BACnetConstructedDataOutOfService";
                            }
                        }
                        Assertions.assertNotNull((Object)this.typeDefinitions.get(searchedTypeName), (String)("shared " + searchedTypeName + " not found (" + propertyTypeCombination + ")"));
                    }));
                } else {
                    boolean isThisCombinationTheMostCommon = true;
                    Integer numberOfOccurences = BACnetObjectsDefinitions.propertyTypeCombinationCount.get(propertyTypeCombination);
                    for (String otherType : listOfTypes) {
                        Integer otherOccurence;
                        if (otherType.equals(propertyTypeCombination.propertyDataType) || (otherOccurence = BACnetObjectsDefinitions.propertyTypeCombinationCount.get(new BACnetObjectsDefinitions.PropertyTypeCombination(propertyIdentifier, otherType))) < numberOfOccurences) continue;
                        isThisCombinationTheMostCommon = false;
                        break;
                    }
                    if (isThisCombinationTheMostCommon) {
                        tests.add((DynamicNode)DynamicTest.dynamicTest((String)(propertyTypeCombination + " is used by " + bacNetObjectName + " uses property shared with " + numberOfOccurences + " using the same type"), () -> {
                            String searchedTypeName = "BACnetConstructedData" + propertyIdentifier;
                            searchedTypeName = searchedTypeName.replaceAll("_", "");
                            Assertions.assertNotNull((Object)this.typeDefinitions.get(searchedTypeName), (String)("shared " + searchedTypeName + " not found (most occurring case with " + numberOfOccurences + " occurrences)"));
                        }));
                    } else {
                        tests.add((DynamicNode)DynamicTest.dynamicTest((String)(propertyTypeCombination + " is used by " + bacNetObjectName + " uses property shared with this type in the minority."), () -> {
                            String searchedTypeName = "BACnetConstructedData" + bacNetObjectName + propertyIdentifier;
                            searchedTypeName = searchedTypeName.replaceAll("[_ ]", "");
                            Pattern pattern = Pattern.compile("-([a-z])");
                            Matcher matcher = pattern.matcher(searchedTypeName);
                            StringBuilder result = new StringBuilder();
                            while (matcher.find()) {
                                matcher.appendReplacement(result, matcher.group(1).toUpperCase());
                            }
                            matcher.appendTail(result);
                            searchedTypeName = result.toString();
                            Assertions.assertNotNull((Object)this.typeDefinitions.get(searchedTypeName), (String)("dedicated " + searchedTypeName + " not found (this occurrence: " + numberOfOccurences + ", other variants " + listOfTypes + ")."));
                        }));
                    }
                }
            });
        });
        return tests;
    }

    @TestFactory
    Collection<DynamicContainer> testArrayIndexesAreHandled() {
        LinkedList<DynamicContainer> tests = new LinkedList<DynamicContainer>();
        String bacnetArrayIdentifierPrefix = "BACnetARRAY";
        String bacnetListIdentifierPrefix = "BACnetLIST";
        new LinkedList<Map.Entry<BACnetObjectsDefinitions.PropertyTypeCombination, List<String>>>(BACnetObjectsDefinitions.propertyTypeCombinationToObjectNameMap.entrySet()).stream().filter(propertyTypeCombinationListEntry -> ((BACnetObjectsDefinitions.PropertyTypeCombination)propertyTypeCombinationListEntry.getKey()).propertyDataType.startsWith(bacnetArrayIdentifierPrefix) || ((BACnetObjectsDefinitions.PropertyTypeCombination)propertyTypeCombinationListEntry.getKey()).propertyDataType.startsWith(bacnetListIdentifierPrefix)).sorted(Map.Entry.comparingByKey()).forEach(propertyTypeCombinationToObjectNameEntry -> {
            BACnetObjectsDefinitions.PropertyTypeCombination propertyTypeCombination = (BACnetObjectsDefinitions.PropertyTypeCombination)propertyTypeCombinationToObjectNameEntry.getKey();
            ((List)propertyTypeCombinationToObjectNameEntry.getValue()).forEach(bacNetObjectName -> {
                boolean bl = tests.add(DynamicContainer.dynamicContainer((String)(propertyTypeCombination + " for " + bacNetObjectName), () -> {
                    TypeDefinition typeDefinition;
                    String propertyDataType;
                    LinkedList<DynamicTest> nodes;
                    block18: {
                        String searchedTypeName;
                        Set<String> listOfTypes;
                        String propertyIdentifier;
                        block16: {
                            nodes = new LinkedList<DynamicTest>();
                            propertyIdentifier = propertyTypeCombination.propertyIdentifier;
                            propertyDataType = propertyTypeCombination.propertyDataType;
                            listOfTypes = BACnetObjectsDefinitions.propertyToPropertyTypesMaps.get(propertyIdentifier);
                            if (listOfTypes.size() >= 2) break block16;
                            String searchedTypeName2 = "BACnetConstructedData" + propertyIdentifier;
                            switch (searchedTypeName2 = searchedTypeName2.replaceAll("_", "")) {
                                case "BACnetConstructedDataOutofService": {
                                    searchedTypeName2 = "BACnetConstructedDataOutOfService";
                                }
                            }
                            typeDefinition = this.typeDefinitions.get(searchedTypeName2);
                            Assertions.assertNotNull((Object)typeDefinition, (String)("shared " + searchedTypeName2 + " not found (" + propertyTypeCombination + ")"));
                            break block18;
                        }
                        boolean isThisCombinationTheMostCommon = true;
                        Integer numberOfOccurences = BACnetObjectsDefinitions.propertyTypeCombinationCount.get(propertyTypeCombination);
                        for (String otherType : listOfTypes) {
                            Integer otherOccurence;
                            if (otherType.equals(propertyTypeCombination.propertyDataType) || (otherOccurence = BACnetObjectsDefinitions.propertyTypeCombinationCount.get(new BACnetObjectsDefinitions.PropertyTypeCombination(propertyIdentifier, otherType))) < numberOfOccurences) continue;
                            isThisCombinationTheMostCommon = false;
                            break;
                        }
                        if (isThisCombinationTheMostCommon) {
                            searchedTypeName = "BACnetConstructedData" + propertyIdentifier;
                            searchedTypeName = searchedTypeName.replaceAll("_", "");
                            typeDefinition = this.typeDefinitions.get(searchedTypeName);
                            Assertions.assertNotNull((Object)typeDefinition, (String)("shared " + searchedTypeName + " not found (most occurring case with " + numberOfOccurences + " occurrences)"));
                        } else {
                            searchedTypeName = "BACnetConstructedData" + bacNetObjectName + propertyIdentifier;
                            searchedTypeName = searchedTypeName.replaceAll("[_ ]", "");
                            Pattern pattern = Pattern.compile("-([a-z])");
                            Matcher matcher = pattern.matcher(searchedTypeName);
                            StringBuilder result = new StringBuilder();
                            while (matcher.find()) {
                                matcher.appendReplacement(result, matcher.group(1).toUpperCase());
                            }
                            matcher.appendTail(result);
                            searchedTypeName = result.toString();
                            typeDefinition = this.typeDefinitions.get(searchedTypeName);
                            Assertions.assertNotNull((Object)this.typeDefinitions.get(searchedTypeName), (String)("dedicated " + searchedTypeName + " not found (this occurrence: " + numberOfOccurences + ", other variants " + listOfTypes + ")."));
                        }
                    }
                    Assertions.assertTrue((boolean)typeDefinition.isComplexTypeDefinition(), (String)(String.valueOf(typeDefinition.getName()) + " should be complex"));
                    ComplexTypeDefinition complexTypeDefinition = (ComplexTypeDefinition)typeDefinition.asComplexTypeDefinition().orElseThrow();
                    if (propertyDataType.startsWith(bacnetArrayIdentifierPrefix)) {
                        nodes.add(DynamicTest.dynamicTest((String)("Check array count for " + propertyTypeCombination + " for " + typeDefinition.getName()), () -> {
                            Optional numberOfDataElements = complexTypeDefinition.getPropertyFieldByName("numberOfDataElements");
                            Assertions.assertTrue((boolean)numberOfDataElements.isPresent(), (String)("field numberOfDataElements for " + typeDefinition.getName() + " not found"));
                        }));
                        if (propertyDataType.startsWith("BACnetARRAY[") && !propertyDataType.startsWith("BACnetARRAY[N")) {
                            nodes.add(DynamicTest.dynamicTest((String)("Check bounds validation for " + propertyTypeCombination + " for " + typeDefinition.getName()), () -> {
                                Pattern pattern = Pattern.compile("BACnetARRAY\\[(\\d+)]");
                                Matcher matcher = pattern.matcher(propertyDataType);
                                Assertions.assertTrue((boolean)matcher.find(), (String)"we should find the index");
                                String index = matcher.group(1);
                                Optional<ValidationField> validationField = complexTypeDefinition.getFields().stream().filter(FieldConversions::isValidationField).map(ValidationField.class::cast).filter(foundValidationField -> foundValidationField.getValidationExpression().stringRepresentation().contains("COUNT") && foundValidationField.getValidationExpression().stringRepresentation().contains("arrayIndexArgument") && foundValidationField.getValidationExpression().stringRepresentation().contains(index)).findAny();
                                Assertions.assertTrue((boolean)validationField.isPresent(), (String)("No validation for length of " + index + " found for " + typeDefinition.getName()));
                            }));
                        }
                    } else if (propertyDataType.startsWith(bacnetListIdentifierPrefix)) {
                        nodes.add(DynamicTest.dynamicTest((String)("Check no array count for " + propertyTypeCombination + " for " + typeDefinition.getName()), () -> {
                            Optional numberOfDataElements = complexTypeDefinition.getPropertyFieldByName("numberOfDataElements");
                            Assertions.assertFalse((boolean)numberOfDataElements.isPresent(), (String)("field numberOfDataElements for " + typeDefinition.getName() + " found"));
                        }));
                    } else {
                        throw new IllegalStateException("how on earth did we got " + propertyDataType + " here???");
                    }
                    return nodes.iterator();
                }));
            });
        });
        return tests;
    }

    @TestFactory
    Collection<DynamicNode> singleAttributesHaveAnActualValue() {
        LinkedList<DynamicNode> tests = new LinkedList<DynamicNode>();
        ComplexTypeDefinition baCnetConstructedData = (ComplexTypeDefinition)this.typeDefinitions.get("BACnetConstructedData").asComplexTypeDefinition().orElseThrow();
        this.typeDefinitions.values().stream().filter(TypeDefinitionConversions::isDiscriminatedComplexTypeDefinition).filter(typeDefinition -> !typeDefinition.getName().endsWith("All")).filter(typeDefinition -> !typeDefinition.getName().equals("BACnetConstructedDataOptional")).filter(typeDefinition -> !typeDefinition.getName().equals("BACnetConstructedDataRequired")).map(DiscriminatedComplexTypeDefinition.class::cast).filter(discriminatedComplexTypeDefinition -> discriminatedComplexTypeDefinition.getParentType().isPresent()).filter(discriminatedComplexTypeDefinition -> discriminatedComplexTypeDefinition.getParentType().get() == baCnetConstructedData).filter(discriminatedComplexTypeDefinition -> discriminatedComplexTypeDefinition.getPropertyFields().stream().noneMatch(FieldConversions::isArrayField)).forEach(discriminatedComplexTypeDefinition -> {
            boolean bl = tests.add((DynamicNode)DynamicTest.dynamicTest((String)("Test for actualValue on " + discriminatedComplexTypeDefinition.getName()), () -> Assertions.assertTrue((boolean)discriminatedComplexTypeDefinition.getNamedFieldByName("actualValue").isPresent())));
        });
        return tests;
    }

    @Nested
    @Tag(value="just-output")
    class JustOutputs {
        JustOutputs() {
        }

        @Test
        void outputObjectChapters() {
            List<Integer> unrelatedTables = List.of(0, 1, 7, 9, 15, 25, 33, 41, 42, 59, 60, 63, 65, 66, 67, 68, 70, 72, 73, 74);
            int tableNo = 0;
            for (BACnetObjectsDefinitions.BacNetObject bacNetObject : BACnetObjectsDefinitions.bacNetObjects) {
                while (unrelatedTables.contains(tableNo)) {
                    ++tableNo;
                }
                LOGGER.info("Table 12-{}. Properties of the {} Object Type", (Object)tableNo++, (Object)bacNetObject.name);
            }
        }

        @Test
        void outputPropertyUsage() {
            BACnetObjectsDefinitions.propertyToObjectNamesMap.forEach((propertyIdentifier, bacNetObjectNames) -> LOGGER.info("property {} is used by {}", propertyIdentifier, bacNetObjectNames));
        }

        @Test
        void outputTypeCombinationUsage() {
            LinkedList<Map.Entry<BACnetObjectsDefinitions.PropertyTypeCombination, List<String>>> listOfCombinationEntries = new LinkedList<Map.Entry<BACnetObjectsDefinitions.PropertyTypeCombination, List<String>>>(BACnetObjectsDefinitions.propertyTypeCombinationToObjectNameMap.entrySet());
            listOfCombinationEntries.sort(Comparator.comparingInt(v -> ((List)v.getValue()).size()));
            Collections.reverse(listOfCombinationEntries);
            listOfCombinationEntries.forEach(propertyTypeCombinationListEntry -> LOGGER.info("{} appearance of {} in {}", new Object[]{((List)propertyTypeCombinationListEntry.getValue()).size(), propertyTypeCombinationListEntry.getKey(), propertyTypeCombinationListEntry.getValue()}));
        }

        @Test
        void outputTypeCombinationsSorted() {
            Set<BACnetObjectsDefinitions.PropertyTypeCombination> propertyTypeCombinations = BACnetObjectsDefinitions.propertyTypeCombinationToObjectNameMap.keySet();
            propertyTypeCombinations.stream().sorted().forEach(propertyTypeCombination -> LOGGER.info("{}", propertyTypeCombination));
        }

        @Test
        void outputTypeCombinationCountSorted() {
            BACnetObjectsDefinitions.propertyTypeCombinationCount.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(propertyTypeCombinationCount -> LOGGER.info("{}", propertyTypeCombinationCount));
        }

        @Test
        void outputUniqueProperties() {
            BACnetObjectsDefinitions.propertyToObjectNamesMap.forEach((propertyIdentifier, bacNetObjectNames) -> {
                if (bacNetObjectNames.size() > 1) {
                    return;
                }
                LOGGER.info("property {} is used by {} uniquely", propertyIdentifier, bacNetObjectNames.get(0));
            });
        }

        @Test
        void outputNonUniqueProperties() {
            BACnetObjectsDefinitions.propertyToObjectNamesMap.forEach((propertyIdentifier, bacNetObjectNames) -> {
                if (bacNetObjectNames.size() == 1) {
                    return;
                }
                LOGGER.info("property {} is used by {} non uniquely", propertyIdentifier, bacNetObjectNames);
            });
        }

        @Test
        void outputDataConstructedDataChilds() {
            ComplexTypeDefinition baCnetConstructedData = (ComplexTypeDefinition)ObjectPropertyDeDuplicationTest.this.typeDefinitions.get("BACnetConstructedData").asComplexTypeDefinition().orElseThrow();
            Set childsOfConstructedData = ObjectPropertyDeDuplicationTest.this.typeDefinitions.values().stream().filter(TypeDefinitionConversions::isDiscriminatedComplexTypeDefinition).map(DiscriminatedComplexTypeDefinition.class::cast).filter(discriminatedComplexTypeDefinition -> discriminatedComplexTypeDefinition.getParentType().isPresent()).filter(discriminatedComplexTypeDefinition -> discriminatedComplexTypeDefinition.getParentType().get() == baCnetConstructedData).map(TypeDefinition::getName).collect(Collectors.toSet());
            childsOfConstructedData.stream().sorted().forEach(System.out::println);
        }
    }
}

