/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.protocol.bacnetip;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class BACnetObjectsDefinitions {
    static List<BacNetObject> bacNetObjects;
    static Map<String, BacNetObject> objectNameToBacNetObjectMap;
    static Map<String, List<String>> propertyToObjectNamesMap;
    static Map<PropertyTypeCombination, List<String>> propertyTypeCombinationToObjectNameMap;
    static Map<String, String> propertyIdToPropertyNameMap;
    static Map<String, Set<String>> propertyToPropertyTypesMaps;
    static Map<PropertyTypeCombination, Integer> propertyTypeCombinationCount;

    static {
        BACnetObjectsDefinitions.createBacnetObjectsList();
        BACnetObjectsDefinitions.createObjectNameToBacNetObjectMap();
        BACnetObjectsDefinitions.createPropertyToObjectNameMap();
        BACnetObjectsDefinitions.createPropertyTypeCombinationToObjectNameMap();
        BACnetObjectsDefinitions.createPropertyTypeCombinationCount();
        BACnetObjectsDefinitions.createPropertyIdToPropertyNameMap();
        BACnetObjectsDefinitions.createPropertyToPropertyTypesMaps();
    }

    private static void createBacnetObjectsList() {
        bacNetObjects = List.of(BACnetObjectsDefinitions.createAnalogInput(), BACnetObjectsDefinitions.createAnalogOutput(), BACnetObjectsDefinitions.createAnalogValue(), BACnetObjectsDefinitions.createAveraging(), BACnetObjectsDefinitions.createBinarInput(), BACnetObjectsDefinitions.createBinaryOutput(), BACnetObjectsDefinitions.createBinaryValue(), BACnetObjectsDefinitions.createCalendar(), BACnetObjectsDefinitions.createCommand(), BACnetObjectsDefinitions.createDevice(), BACnetObjectsDefinitions.createEventEnrollment(), BACnetObjectsDefinitions.createFile(), BACnetObjectsDefinitions.createGroup(), BACnetObjectsDefinitions.createLifeSafetyPoint(), BACnetObjectsDefinitions.createLifeSafetyZone(), BACnetObjectsDefinitions.createLoop(), BACnetObjectsDefinitions.createMultiStateInput(), BACnetObjectsDefinitions.createMultiStateOutput(), BACnetObjectsDefinitions.createMultiStateValue(), BACnetObjectsDefinitions.createNotificationClass(), BACnetObjectsDefinitions.createProgram(), BACnetObjectsDefinitions.createPulseConverter(), BACnetObjectsDefinitions.createSchedule(), BACnetObjectsDefinitions.createTrendLog(), BACnetObjectsDefinitions.createAccessDoor(), BACnetObjectsDefinitions.createEventLog(), BACnetObjectsDefinitions.createLoadControl(), BACnetObjectsDefinitions.createStructuredView(), BACnetObjectsDefinitions.createTrendLogMultiple(), BACnetObjectsDefinitions.createAccessPoints(), BACnetObjectsDefinitions.createAccessZone(), BACnetObjectsDefinitions.createAccessUser(), BACnetObjectsDefinitions.createAccessRights(), BACnetObjectsDefinitions.createAcessCredential(), BACnetObjectsDefinitions.createCredentialDataInput(), BACnetObjectsDefinitions.createCharacterStringValue(), BACnetObjectsDefinitions.createDateTimeValue(), BACnetObjectsDefinitions.createLargeAnalogValue(), BACnetObjectsDefinitions.createBitStringValue(), BACnetObjectsDefinitions.createOctetStringValue(), BACnetObjectsDefinitions.createTimeValue(), BACnetObjectsDefinitions.createIntegerValue(), BACnetObjectsDefinitions.createPostiveIntegerValue(), BACnetObjectsDefinitions.createDateValue(), BACnetObjectsDefinitions.createDateTimePatternValue(), BACnetObjectsDefinitions.createTimePatternValue(), BACnetObjectsDefinitions.createDatePatternValue(), BACnetObjectsDefinitions.createNetworkSecurity(), BACnetObjectsDefinitions.createGlobalGroup(), BACnetObjectsDefinitions.createNotificationForwarder(), BACnetObjectsDefinitions.createAlertEnrollment(), BACnetObjectsDefinitions.createChannel(), BACnetObjectsDefinitions.createLightingOutput(), BACnetObjectsDefinitions.createBinaryLightingOutput(), BACnetObjectsDefinitions.createNetworkPort(), BACnetObjectsDefinitions.createTimer(), BACnetObjectsDefinitions.createElevatorGroup(), BACnetObjectsDefinitions.createLift(), BACnetObjectsDefinitions.createEscalator(), BACnetObjectsDefinitions.createAccumulator());
    }

    private static BacNetObject createAccumulator() {
        return BACnetObjectsDefinitions.b("Accumulator", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, 1)), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Device_Type", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Scale", "BACnetScale", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Units", "BACnetEngineeringUnits", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Prescale", "BACnetPrescale", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Max_Pres_Value", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Value_Change_Time", "BACnetDateTime", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Value_Before_Change", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 3)), BACnetObjectsDefinitions.p("Value_Set", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 3)), BACnetObjectsDefinitions.p("Logging_Record", "BACnetAccumulatorRecord", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Logging_Object", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Pulse_Rate", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 4, 7)), BACnetObjectsDefinitions.p("High_Limit", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Low_Limit", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Limit_Monitoring_Interval", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 7)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Time_Delay", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Limit_Enable", "BACnetLimitEnable", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit_Ref", "BACnetObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6, 8)), BACnetObjectsDefinitions.p("Time_Delay_Normal", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 9)), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Fault_High_Limit", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 10)), BACnetObjectsDefinitions.p("Fault_Low_Limit", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 10)), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createEscalator() {
        return BACnetObjectsDefinitions.b("Escalator", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Elevator_Group", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Group_ID", "Unsigned8", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Installation_ID", "Unsigned8", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Power_Mode", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Operation_Direction", "BACnetEscalatorOperationDirection", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Escalator_Mode", "BACnetEscalatorMode", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Energy_Meter", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Energy_Meter_Ref", "BACnetDeviceObjectReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Fault_Signals", "BACnetLIST of BACnetEscalatorFault", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Passenger_Alarm", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Time_Delay", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 2)), BACnetObjectsDefinitions.p("Time_Delay_Normal", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 2)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 2)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 2)), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 2)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 2)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 2)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 2)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 3)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit_Ref", "BACnetObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4)), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createLift() {
        return BACnetObjectsDefinitions.b("Lift", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Elevator_Group", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Group_ID", "Unsigned8", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Installation_ID", "Unsigned8", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Floor_Text", "BACnetARRAY[N] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Car_Door_Text", "BACnetARRAY[N] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Assigned_Landing_Calls", "BACnetARRAY[N] of BACnetAssignedLandingCalls", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Making_Car_Call", "BACnetARRAY[N] of Unsigned8", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Registered_Car_Call", "BACnetARRAY[N] of BACnetLiftCarCallList", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Car_Position", "Unsigned8", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Car_Moving_Direction", "BACnetLiftCarDirection", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Car_Assigned_Direction", "BACnetLiftCarDirection", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Car_Door_Status", "BACnetARRAY[N] of BACnetDoorStatus", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Car_Door_Command", "BACnetARRAY[N] of BACnetLiftCarDoorCommand", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Car_Door_Zone", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Car_Mode", "BACnetLiftCarMode", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Car_Load", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Car_Load_Units", "BACnetEngineeringUnits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("Next_Stopping_Floor", "Unsigned8", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Passenger_Alarm", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Time_Delay", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 3)), BACnetObjectsDefinitions.p("Time_Delay_Normal", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Energy_Meter", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Energy_Meter_Ref", "BACnetDeviceObjectReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Car_Drive_Status", "BACnetLiftCarDriveStatus", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Fault_Signals", "BACnetLIST of BACnetLiftFault", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Landing_Door_Status", "BACnetARRAY[N] of BACnetLandingDoorStatus", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Higher_Deck", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Lower_Deck", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 3)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 3)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 3)), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 3)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 3)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 3)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 3)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit_Ref", "BACnetObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 4)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createElevatorGroup() {
        return BACnetObjectsDefinitions.b("Elevator Group", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Machine_Room_ID", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Group_ID", "Unsigned8", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Group_Members", "BACnetARRAY[N] of BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Group_Mode", "BACnetLiftGroupMode", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("Landing_Calls", "BACnetLIST of BACnetLandingCallStatus", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("Landing_Call_Control", "BACnetLandingCallStatus", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createTimer() {
        return BACnetObjectsDefinitions.b("Timer", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, 1)), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Timer_State", "BACnetTimerState", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, 2)), BACnetObjectsDefinitions.p("Timer_Running", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, 2)), BACnetObjectsDefinitions.p("Update_Time", "BACnetDateTime", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Last_State_Change", "BACnetTimerTransition", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Expiration_Time", "BACnetDateTime", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Initial_Timeout", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Default_Timeout", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Min_Pres_Value", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4)), BACnetObjectsDefinitions.p("Max_Pres_Value", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4)), BACnetObjectsDefinitions.p("Resolution", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("State_Change_Values", "BACnetARRAY[7] of BACnetTimerStateChangeValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("List_Of_Object_Property_References", "BACnetLIST of BACnetDeviceObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Priority_For_Writing", "Unsigned(1..16)", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 6)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 6)), BACnetObjectsDefinitions.p("Time_Delay", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 6)), BACnetObjectsDefinitions.p("Time_Delay_Normal", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 6)), BACnetObjectsDefinitions.p("Alarm_Values", "BACnetLIST of BACnetTimerState", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 6)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 6)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 6)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 6)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 6)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit_Ref", "BACnetObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6, 7)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 8)), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createNetworkPort() {
        return BACnetObjectsDefinitions.b("Network Port", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Network_Type", "BACnetNetworkType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Protocol_Level", "BACnetProtocolLevel", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reference_Port", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Network_Number", "Unsigned16", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, 1)), BACnetObjectsDefinitions.p("Network_Number_Quality", "BACnetNetworkNumberQuality", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Changes_Pending", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Command", "BACnetNetworkPortCommand", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("MAC_Address", "OCTET STRING", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("APDU_Length", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Link_Speed", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Link_Speeds", "BACnetARRAY[N] of REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4)), BACnetObjectsDefinitions.p("Link_Speed_Autonegotiate", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Network_Interface_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("BACnet_IP_Mode", "BACnetIPMode", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("IP_Address", "OCTET STRING", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("BACnet_IP_UDP_Port", "Unsigned16", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("IP_Subnet_Mask", "OCTET STRING", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("IP_Default_Gateway", "OCTET STRING", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("BACnet_IP_Multicast_Address", "OCTET STRING", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7)), BACnetObjectsDefinitions.p("IP_DNS_Server", "BACnetARRAY[N] of OCTET STRING", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("IP_DHCP_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 8)), BACnetObjectsDefinitions.p("IP_DHCP_Lease_Time", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("IP_DHCP_Lease_Time_Remaining", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("IP_DHCP_Server", "OCTET STRING", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("BACnet_IP_NAT_Traversal", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 9)), BACnetObjectsDefinitions.p("BACnet_IP_Global_Address", "BACnetHostNPort", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 10)), BACnetObjectsDefinitions.p("BBMD_Broadcast_Distribution_Table", "BACnetLIST of BACnetBDTEntry", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 11)), BACnetObjectsDefinitions.p("BBMD_Accept_FD_Registrations", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 11)), BACnetObjectsDefinitions.p("BBMD_Foreign_Device_Table", "BACnetLIST of BACnetFDTEntry", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 12)), BACnetObjectsDefinitions.p("FD_BBMD_Address", "BACnetHostNPort", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 13)), BACnetObjectsDefinitions.p("FD_Subscription_Lifetime", "Unsigned16", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 13)), BACnetObjectsDefinitions.p("BACnet_IPv6_Mode", "BACnetIPMode", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 14)), BACnetObjectsDefinitions.p("IPv6_Address", "OCTET STRING", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 15)), BACnetObjectsDefinitions.p("IPv6_Prefix_Length", "Unsigned8", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 15)), BACnetObjectsDefinitions.p("BACnet_IPv6_UDP_Port", "Unsigned16", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 14)), BACnetObjectsDefinitions.p("IPv6_Default_Gateway", "OCTET STRING", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 15)), BACnetObjectsDefinitions.p("BACnet_IPv6_Multicast_Address", "OCTET STRING", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 14)), BACnetObjectsDefinitions.p("IPv6_DNS_Server", "BACnetARRAY[N] of OCTET STRING", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 15)), BACnetObjectsDefinitions.p("IPv6_Auto_Addressing_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 16)), BACnetObjectsDefinitions.p("IPv6_DHCP_Lease_Time", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("IPv6_DHCP_Lease_Time_Remaining", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("IPv6_DHCP_Server", "OCTET STRING", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("IPv6_Zone_Index", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 17)), BACnetObjectsDefinitions.p("Max_Master", "Unsigned8(0..127)", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 18)), BACnetObjectsDefinitions.p("Max_Info_Frames", "Unsigned8", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 18)), BACnetObjectsDefinitions.p("Slave_Proxy_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 19)), BACnetObjectsDefinitions.p("Manual_Slave_Address_Binding", "BACnetLIST of BACnetAddressBinding", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 19)), BACnetObjectsDefinitions.p("Auto_Slave_Discovery", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 20)), BACnetObjectsDefinitions.p("Slave_Address_Binding", "BACnetLIST of BACnetAddressBinding", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 21)), BACnetObjectsDefinitions.p("Virtual_MAC_Address_Table", "BACnetLIST of BACnetVMACEntry", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 22)), BACnetObjectsDefinitions.p("Routing_Table", "BACnetLIST of BACnetRouterEntry", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 23, 24)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 23, 24)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 23, 24)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 23, 24)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 23, 24)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 23, 24)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 24)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 24)), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 23)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createBinaryLightingOutput() {
        return BACnetObjectsDefinitions.b("Binary Lighting Output", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "BACnetBinaryLightingPV", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Blink_Warn_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Egress_Time", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Egress_Active", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Feedback_Value", "BACnetBinaryLightingPV", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Priority_Array", "BACnetPriorityArray", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Relinquish_Default", "BACnetBinaryLightingPV", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Power", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Polarity", "BACnetPolarity", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Elapsed_Active_Time", "Unsigned32", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("Time_Of_Active_Time_Reset", "BACnetDateTime", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("Strike_Count", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Time_Of_Strike_Count_Reset", "BACnetDateTime", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 4)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 4)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 4)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 4)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 4)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 4)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Current_Command_Priority", "BACnetOptionalUnsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Value_Source", "BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6, 8, 10)), BACnetObjectsDefinitions.p("Value_Source_Array", "BACnetARRAY[16] of BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7, 9)), BACnetObjectsDefinitions.p("Last_Command_Time", "BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7, 9)), BACnetObjectsDefinitions.p("Command_Time_Array", "BACnetARRAY[16] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 9)), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createLightingOutput() {
        return BACnetObjectsDefinitions.b("Lighting Output", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("Tracking_Value", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Lighting_Command", "BACnetLightingCommand", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("In_Progress", "BACnetLightingInProgress", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Blink_Warn_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Egress_Time", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Egress_Active", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Default_Fade_Time", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Default_Ramp_Rate", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Default_Step_Increment", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Transition", "BACnetLightingTransition", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Feedback_Value", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Priority_Array", "BACnetPriorityArray", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Relinquish_Default", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Power", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Instantaneous_Power", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Min_Actual_Value", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("Max_Actual_Value", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("Lighting_Command_Default_Priority", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("COV_Increment", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Current_Command_Priority", "BACnetOptionalUnsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Value_Source", "BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6, 8)), BACnetObjectsDefinitions.p("Value_Source_Array", "BACnetARRAY[16] of BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5, 7)), BACnetObjectsDefinitions.p("Last_Command_Time", "BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5, 7)), BACnetObjectsDefinitions.p("Command_Time_Array", "BACnetARRAY[16] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7)), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createChannel() {
        return BACnetObjectsDefinitions.b("Channel", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "BACnetChannelValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("Last_Priority", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Write_Status", "BACnetWriteStatus", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("List_Of_Object_Property_References", "BACnetARRAY[N] of BACnetDeviceObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, 1)), BACnetObjectsDefinitions.p("Execution_Delay", "BACnetARRAY[N] of Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("Allow_Group_Delay_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Channel_Number", "Unsigned16", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("Control_Groups", "BACnetARRAY[N] of Unsigned32", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 3)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 3)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 3)), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 3)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 3)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 3)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 3)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4)), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Value_Source", "BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5, 6, 7)), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createAlertEnrollment() {
        return BACnetObjectsDefinitions.b("Alert Enrollment", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit_Ref", "BACnetObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createNotificationForwarder() {
        return BACnetObjectsDefinitions.b("Notification Forwarder", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Recipient_List", "BACnetLIST of BACnetDestination", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Subscribed_Recipients", "BACnetLIST of BACnetEventNotificationSubscription", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("Process_Identifier_Filter", "BACnetProcessIdSelection", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Port_Filter", "BACnetARRAY[N] of BACnetPortPermission", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("Local_Forwarding_Only", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createGlobalGroup() {
        return BACnetObjectsDefinitions.b("Global Group", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Group_Members", "BACnetARRAY[N] of BACnetDeviceObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Group_Member_Names", "BACnetARRAY[N] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "BACnetARRAY[N] of BACnetPropertyAccessResult", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Member_Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Out_of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Update_Interval", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Requested_Update_Interval", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("COV_Resubscription_Interval", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Client_COV_Increment", "BACnetClientCOV", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Time_Delay", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 4)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 4)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 4)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 4)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 4)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 4)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4)), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 4)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit_Ref", "BACnetObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Time_Delay_Normal", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4)), BACnetObjectsDefinitions.p("COVU_Period", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("COVU_Recipients", "BACnetLIST of BACnetRecipient", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createNetworkSecurity() {
        return BACnetObjectsDefinitions.b("Network Security", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Base_Device_Security_Policy", "BACnetSecurityLevel", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("Network_Access_Security_Policies", "BACnetARRAY[N] of BACnetNetworkSecurityPolicy", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("Security_Time_Window", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("Packet_Reorder_Time", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("Distribution_Key_Revision", "Unsigned8", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Key_Sets", "BACnetARRAY[2] of BACnetSecurityKeySet", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Last_Key_Server", "BACnetAddressBinding", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("Security_PDU_Timeout", "Unsigned16", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("Update_Key_Set_Timeout", "Unsigned16", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Supported_Security_Algorithms", "BACnetLIST of Unsigned8", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Do_Not_Hide", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createDatePatternValue() {
        return BACnetObjectsDefinitions.b("Date Pattern Value", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "Date", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, 1)), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Priority_Array", "BACnetPriorityArray", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Relinquish_Default", "Date", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Current_Command_Priority", "BACnetOptionalUnsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Value_Source", "BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6, 8, 10)), BACnetObjectsDefinitions.p("Value_Source_Array", "BACnetARRAY[16] of BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7, 9)), BACnetObjectsDefinitions.p("Last_Command_Time", "BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7, 9)), BACnetObjectsDefinitions.p("Command_Time_Array", "BACnetARRAY[16] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 9)), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createTimePatternValue() {
        return BACnetObjectsDefinitions.b("Time Pattern Value", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "Time", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, 1)), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Priority_Array", "BACnetPriorityArray", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Relinquish_Default", "Time", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Current_Command_Priority", "BACnetOptionalUnsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Value_Source", "BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6, 8, 10)), BACnetObjectsDefinitions.p("Value_Source_Array", "BACnetARRAY[16] of BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7, 9)), BACnetObjectsDefinitions.p("Last_Command_Time", "BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7, 9)), BACnetObjectsDefinitions.p("Command_Time_Array", "BACnetARRAY[16] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 9)), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createDateTimePatternValue() {
        return BACnetObjectsDefinitions.b("DateTime Pattern Value", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "BACnetDateTime", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, 1)), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Is_UTC", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Priority_Array", "BACnetPriorityArray", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Relinquish_Default", "BACnetDateTime", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Current_Command_Priority", "BACnetOptionalUnsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Value_Source", "BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6, 8, 10)), BACnetObjectsDefinitions.p("Value_Source_Array", "BACnetARRAY[16] of BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7, 9)), BACnetObjectsDefinitions.p("Last_Command_Time", "BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7, 9)), BACnetObjectsDefinitions.p("Command_Time_Array", "BACnetARRAY[16] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 9)), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createDateValue() {
        return BACnetObjectsDefinitions.b("Date Value", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "Date", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, 1)), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Priority_Array", "BACnetPriorityArray", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Relinquish_Default", "Date", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Current_Command_Priority", "BACnetOptionalUnsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Value_Source", "BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6, 8, 10)), BACnetObjectsDefinitions.p("Value_Source_Array", "BACnetARRAY[16] of BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7, 9)), BACnetObjectsDefinitions.p("Last_Command_Time", "BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7, 9)), BACnetObjectsDefinitions.p("Command_Time_Array", "BACnetARRAY[16] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 9)), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createPostiveIntegerValue() {
        return BACnetObjectsDefinitions.b("Positive Integer Value", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, 1)), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4)), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Units", "BACnetEngineeringUnits", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Priority_Array", "BACnetPriorityArray", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Relinquish_Default", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("COV_Increment", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Time_Delay", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("High_Limit", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Low_Limit", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Deadband", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Limit_Enable", "BACnetLimitEnable", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit_Ref", "BACnetObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6, 7)), BACnetObjectsDefinitions.p("Time_Delay_Normal", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 8)), BACnetObjectsDefinitions.p("Min_Pres_Value", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Max_Pres_Value", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Resolution", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Fault_High_Limit", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 9)), BACnetObjectsDefinitions.p("Fault_Low_Limit", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 9)), BACnetObjectsDefinitions.p("Current_Command_Priority", "BACnetOptionalUnsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Value_Source", "BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 10, 12, 14)), BACnetObjectsDefinitions.p("Value_Source_Array", "BACnetARRAY[16] of BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 11, 13)), BACnetObjectsDefinitions.p("Last_Command_Time", "BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 11, 13)), BACnetObjectsDefinitions.p("Command_Time_Array", "BACnetARRAY[16] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 13)), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createIntegerValue() {
        return BACnetObjectsDefinitions.b("Integer Value", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "INTEGER", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, 1)), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4)), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Units", "BACnetEngineeringUnits", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Priority_Array", "BACnetPriorityArray", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Relinquish_Default", "INTEGER", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("COV_Increment", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Time_Delay", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("High_Limit", "INTEGER", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Low_Limit", "INTEGER", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Deadband", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Limit_Enable", "BACnetLimitEnable", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit_Ref", "BACnetObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6, 7)), BACnetObjectsDefinitions.p("Time_Delay_Normal", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 8)), BACnetObjectsDefinitions.p("Min_Pres_Value", "INTEGER", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Max_Pres_Value", "INTEGER", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Resolution", "INTEGER", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Fault_High_Limit", "INTEGER", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 9)), BACnetObjectsDefinitions.p("Fault_Low_Limit", "INTEGER", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 9)), BACnetObjectsDefinitions.p("Current_Command_Priority", "BACnetOptionalUnsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Value_Source", "BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 10, 12, 14)), BACnetObjectsDefinitions.p("Value_Source_Array", "BACnetARRAY[16] of BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 11, 13)), BACnetObjectsDefinitions.p("Last_Command_Time", "BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 11, 13)), BACnetObjectsDefinitions.p("Command_Time_Array", "BACnetARRAY[16] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 13)), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createTimeValue() {
        return BACnetObjectsDefinitions.b("Time Value", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "Time", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, 1)), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Priority_Array", "BACnetPriorityArray", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Relinquish_Default", "Time", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Current_Command_Priority", "BACnetOptionalUnsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Value_Source", "BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6, 8, 10)), BACnetObjectsDefinitions.p("Value_Source_Array", "BACnetARRAY[16] of BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7, 9)), BACnetObjectsDefinitions.p("Last_Command_Time", "BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7, 9)), BACnetObjectsDefinitions.p("Command_Time_Array", "BACnetARRAY[16] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 9)), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createOctetStringValue() {
        return BACnetObjectsDefinitions.b("OctetString Value", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "OCTET STRING", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, 1)), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Priority_Array", "BACnetPriorityArray", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Relinquish_Default", "OCTET STRING", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Current_Command_Priority", "BACnetOptionalUnsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Value_Source", "BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6, 8)), BACnetObjectsDefinitions.p("Value_Source_Array", "BACnetARRAY[16] of BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5, 7)), BACnetObjectsDefinitions.p("Last_Command_Time", "BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5, 7)), BACnetObjectsDefinitions.p("Command_Time_Array", "BACnetARRAY[16] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7)), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createBitStringValue() {
        return BACnetObjectsDefinitions.b("BitString Value", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "BIT STRING", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, 1)), BACnetObjectsDefinitions.p("Bit_Text", "BACnetARRAY[N] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Priority_Array", "BACnetPriorityArray", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Relinquish_Default", "BIT STRING", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Time_Delay", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Alarm_Values", "BACnetARRAY[N] of BIT STRING", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Bit_Mask", "BIT STRING", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit_Ref", "BACnetObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5, 6)), BACnetObjectsDefinitions.p("Time_Delay_Normal", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7)), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Current_Command_Priority", "BACnetOptionalUnsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Value_Source", "BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Value_Source_Array", "BACnetARRAY[16] of BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Last_Command_Time", "BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Command_Time_Array", "BACnetARRAY[16] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createLargeAnalogValue() {
        return BACnetObjectsDefinitions.b("Large Analog Value", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "Double", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, 1)), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4)), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Units", "BACnetEngineeringUnits", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Priority_Array", "BACnetPriorityArray", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Relinquish_Default", "Double", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("COV_Increment", "Double", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Time_Delay", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("High_Limit", "Double", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Low_Limit", "Double", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Deadband", "Double", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Limit_Enable", "BACnetLimitEnable", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit_Ref", "BACnetObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6, 7)), BACnetObjectsDefinitions.p("Time_Delay_Normal", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 8)), BACnetObjectsDefinitions.p("Min_Pres_Value", "Double", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Max_Pres_Value", "Double", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Resolution", "Double", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Fault_High_Limit", "Double", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 9)), BACnetObjectsDefinitions.p("Fault_Low_Limit", "Double", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 9)), BACnetObjectsDefinitions.p("Current_Command_Priority", "BACnetOptionalUnsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Value_Source", "BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 10, 12, 14)), BACnetObjectsDefinitions.p("Value_Source_Array", "BACnetARRAY[16] of BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 11, 13)), BACnetObjectsDefinitions.p("Last_Command_Time", "BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 11, 13)), BACnetObjectsDefinitions.p("Command_Time_Array", "BACnetARRAY[16] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 13)), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createDateTimeValue() {
        return BACnetObjectsDefinitions.b("DateTime Value", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "BACnetDateTime", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, 1)), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Priority_Array", "BACnetPriorityArray", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Relinquish_Default", "BACnetDateTime", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Is_UTC", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Current_Command_Priority", "BACnetOptionalUnsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Value_Source", "BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6, 8, 10)), BACnetObjectsDefinitions.p("Value_Source_Array", "BACnetARRAY[16] of BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7, 9)), BACnetObjectsDefinitions.p("Last_Command_Time", "BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7, 9)), BACnetObjectsDefinitions.p("Command_Time_Array", "BACnetARRAY[16] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 9)), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createCharacterStringValue() {
        return BACnetObjectsDefinitions.b("CharacterString Value", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, 1)), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Priority_Array", "BACnetPriorityArray", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Relinquish_Default", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Time_Delay", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Alarm_Values", "BACnetARRAY[N] of BACnetOptionalCharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Fault_Values", "BACnetARRAY[N] of BACnetOptionalCharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit_Ref", "BACnetObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5, 6)), BACnetObjectsDefinitions.p("Time_Delay_Normal", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7)), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Current_Command_Priority", "BACnetOptionalUnsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Value_Source", "BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 8, 10, 12)), BACnetObjectsDefinitions.p("Value_Source_Array", "BACnetARRAY[16] of BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 9, 11)), BACnetObjectsDefinitions.p("Last_Command_Time", "BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 9, 11)), BACnetObjectsDefinitions.p("Command_Time_Array", "BACnetARRAY[16] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 11)), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createCredentialDataInput() {
        return BACnetObjectsDefinitions.b("Credential Data Input", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "BACnetAuthenticationFactor", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, 1)), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, 1)), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Supported_Formats", "BACnetARRAY[N] of BACnetAuthenticationFactorFormat", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Supported_Format_Classes", "BACnetARRAY[N] of Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Update_Time", "BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 4)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 4)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 4)), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 4)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 4)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 4)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 4)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createAcessCredential() {
        return BACnetObjectsDefinitions.b("Access Credential", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Global_Identifier", "Unsigned32", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Credential_Status", "BACnetBinaryPV", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reason_For_Disable", "BACnetLIST of BACnetAccessCredentialDisableReason", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Authentication_Factors", "BACnetARRAY[N] of BACnetCredentialAuthenticationFactor", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Activation_Time", "BACnetDateTime", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Expiration_Time", "BACnetDateTime", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Credential_Disable", "BACnetAccessCredentialDisable", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Days_Remaining", "INTEGER", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("Uses_Remaining", "INTEGER", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Absentee_Limit", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("Belongs_To", "BACnetDeviceObjectReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Assigned_Access_Rights", "BACnetARRAY[N] of BACnetAssignedAccessRights", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Last_Access_Point", "BACnetDeviceObjectReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Last_Access_Event", "BACnetAccessEvent", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Last_Use_Time", "BACnetDateTime", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Trace_Flag", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Threat_Authority", "BACnetAccessThreatLevel", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Extended_Time_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Authorization_Exemptions", "BACnetLIST of BACnetAuthorizationExemption", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createAccessRights() {
        return BACnetObjectsDefinitions.b("Access Rights", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Global_Identifier", "Unsigned32", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Negative_Access_Rules", "BACnetARRAY[N] of BACnetAccessRule", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Positive_Access_Rules", "BACnetARRAY[N] of BACnetAccessRule", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Accompaniment", "BACnetDeviceObjectReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createAccessUser() {
        return BACnetObjectsDefinitions.b("Access User", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Global_Identifier", "Unsigned32", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("User_Type", "BACnetAccessUserType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("User_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("User_External_Identifier", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("User_Information_Reference", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Members", "BACnetLIST of BACnetDeviceObjectReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Member_Of", "BACnetLIST of BACnetDeviceObjectReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Credentials", "BACnetLIST of BACnetDeviceObjectReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createAccessZone() {
        return BACnetObjectsDefinitions.b("Access Zone", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Global_Identifier", "Unsigned32", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("Occupancy_State", "BACnetAccessZoneOccupancyState", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, 1)), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Occupancy_Count", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 3, 4)), BACnetObjectsDefinitions.p("Occupancy_Count_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 4)), BACnetObjectsDefinitions.p("Adjust_Value", "INTEGER", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 4, 5)), BACnetObjectsDefinitions.p("Occupancy_Upper_Limit", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Occupancy_Lower_Limit", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Credentials_In_Zone", "BACnetLIST of BACnetDeviceObjectReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Last_Credential_Added", "BACnetDeviceObjectReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Last_Credential_Added_Time", "BACnetDateTime", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Last_Credential_Removed", "BACnetDeviceObjectReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Last_Credential_Removed_Time", "BACnetDateTime", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Passback_Mode", "BACnetAccessPassbackMode", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Passback_Timeout", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Entry_Points", "BACnetLIST of BACnetDeviceObjectReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Exit_Points", "BACnetLIST of BACnetDeviceObjectReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Time_Delay", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 7)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 7)), BACnetObjectsDefinitions.p("Alarm_Values", "BACnetLIST of BACnetAccessZoneOccupancyState", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 7)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 7)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 7)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 7)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 7)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7)), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 7)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit_Ref", "BACnetObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7, 8)), BACnetObjectsDefinitions.p("Time_Delay_Normal", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createAccessPoints() {
        return BACnetObjectsDefinitions.b("Access Point", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Authentication_Status", "BACnetAuthenticationStatus", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Active_Authentication_Policy", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Number_Of_Authentication_Policies", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Authentication_Policy_List", "BACnetARRAY[N] of BACnetAuthenticationPolicy", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("Authentication_Policy_Names", "BACnetARRAY[N] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("Authorization_Mode", "BACnetAuthorizationMode", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Verification_Time", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Lockout", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Lockout_Relinquish_Time", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Failed_Attempts", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Failed_Attempt_Events", "BACnetLIST of BACnetAccessEvent", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Max_Failed_Attempts", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Failed_Attempts_Time", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Threat_Level", "BACnetAccessThreatLevel", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Occupancy_Upper_Limit_Enforced", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Occupancy_Lower_Limit_Enforced", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Occupancy_Count_Adjust", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Accompaniment_Time", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Access_Event", "BACnetAccessEvent", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Access_Event_Tag", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Access_Event_Time", "BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Access_Event_Credential", "BACnetDeviceObjectReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Access_Event_Authentication_Factor", "BACnetAuthenticationFactor", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Access_Doors", "BACnetARRAY[N] of BACnetDeviceObjectReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Priority_For_Writing", "Unsigned(1..16)", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Muster_Point", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Zone_To", "BACnetDeviceObjectReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Zone_From", "BACnetDeviceObjectReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Transaction_Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Access_Alarm_Events", "BACnetLIST of BACnetAccessEvent", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Access_Transaction_Events", "BACnetLIST of BACnetAccessEvent", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit_Ref", "BACnetObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6, 7)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createTrendLogMultiple() {
        return BACnetObjectsDefinitions.b("Trend Log Multiple", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("Start_Time", "BACnetDateTime", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("Stop_Time", "BACnetDateTime", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("Log_DeviceObjectProperty", "BACnetARRAY[N] of BACnetDeviceObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Logging_Type", "BACnetLoggingType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Log_Interval", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, 2)), BACnetObjectsDefinitions.p("Align_Intervals", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Interval_Offset", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Trigger", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Stop_When_Full", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Buffer_Size", "Unsigned32", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Log_Buffer", "BACnetLIST of BACnetLogMultipleRecord", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Record_Count", "Unsigned32", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("Total_Record_Count", "Unsigned32", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Notification_Threshold", "Unsigned32", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Records_Since_Notification", "Unsigned32", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Last_Notify_Record", "Unsigned32", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit_Ref", "BACnetObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6, 7)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 8)), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createStructuredView() {
        return BACnetObjectsDefinitions.b("Structured View", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Node_Type", "BACnetNodeType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Node_Subtype", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Subordinate_List", "BACnetARRAY[N] of BACnetDeviceObjectReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Subordinate_Annotations", "BACnetARRAY[N] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Subordinate_Tags", "BACnetARRAY[N] of BACnetNameValueCollection", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Subordinate_Node_Types", "BACnetARRAY[N] of BACnetNodeType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Subordinate_Relationships", "BACnetARRAY[N] of BACnetRelationship", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Default_Subordinate_Relationship", "BACnetRelationship", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Represents", "BACnetDeviceObjectReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createLoadControl() {
        return BACnetObjectsDefinitions.b("Load Control", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "BACnetShedState", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("State_Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Requested_Shed_Level", "BACnetShedLevel", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("Start_Time", "BACnetDateTime", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("Shed_Duration", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("Duty_Window", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("Full_Duty_Baseline", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Expected_Shed_Level", "BACnetShedLevel", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Actual_Shed_Level", "BACnetShedLevel", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Shed_Levels", "BACnetARRAY[N] of Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, 1)), BACnetObjectsDefinitions.p("Shed_Level_Descriptions", "BACnetARRAY[N] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 4)), BACnetObjectsDefinitions.p("Time_Delay", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 4)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 4)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 4)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 4)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 4)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4)), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 4)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit_Ref", "BACnetObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Time_Delay_Normal", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Value_Source", "BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7, 8, 9)), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createEventLog() {
        return BACnetObjectsDefinitions.b("Event Log", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("Start_Time", "BACnetDateTime", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 2)), BACnetObjectsDefinitions.p("Stop_Time", "BACnetDateTime", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 2)), BACnetObjectsDefinitions.p("Stop_When_Full", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Buffer_Size", "Unsigned32", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Log_Buffer", "BACnetLIST of BACnetEventLogRecord", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Record_Count", "Unsigned32", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("Total_Record_Count", "Unsigned32", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Notification_Threshold", "Unsigned32", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Records_Since_Notification", "Unsigned32", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Last_Notify_Record", "Unsigned32", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit_Ref", "BACnetObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5, 6)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7)), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createAccessDoor() {
        return BACnetObjectsDefinitions.b("Access Door", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "BACnetDoorValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Priority_Array", "BACnetPriorityArray", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Relinquish_Default", "BACnetDoorValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Door_Status", "BACnetDoorStatus", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 2)), BACnetObjectsDefinitions.p("Lock_Status", "BACnetLockStatus", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("Secured_Status", "BACnetDoorSecuredStatus", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Door_Members", "BACnetARRAY[N] of BACnetDeviceObjectReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Door_Pulse_Time", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Door_Extended_Pulse_Time", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Door_Unlock_Delay_Time", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Door_Open_Too_Long_Time", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Door_Alarm_State", "BACnetDoorAlarmState", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 3)), BACnetObjectsDefinitions.p("Masked_Alarm_Values", "BACnetLIST of BACnetDoorAlarmState", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Maintenance_Required", "BACnetMaintenance", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Time_Delay", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Alarm_Values", "BACnetLIST of BACnetDoorAlarmState", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Fault_Values", "BACnetLIST of BACnetDoorAlarmState", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit_Ref", "BACnetObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5, 6)), BACnetObjectsDefinitions.p("Time_Delay_Normal", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Current_Command_Priority", "BACnetOptionalUnsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Value_Source", "BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7, 9, 11)), BACnetObjectsDefinitions.p("Value_Source_Array", "BACnetARRAY[16] of BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 8, 10)), BACnetObjectsDefinitions.p("Last_Command_Time", "BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 8, 10)), BACnetObjectsDefinitions.p("Command_Time_Array", "BACnetARRAY[16] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 10)), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createTrendLog() {
        return BACnetObjectsDefinitions.b("Trend Log", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("Start_Time", "BACnetDateTime", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 2)), BACnetObjectsDefinitions.p("Stop_Time", "BACnetDateTime", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 2)), BACnetObjectsDefinitions.p("Log_DeviceObjectProperty", "BACnetDeviceObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 8)), BACnetObjectsDefinitions.p("Log_Interval", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 3)), BACnetObjectsDefinitions.p("COV_Resubscription_Interval", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Client_COV_Increment", "BACnetClientCOV", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Stop_When_Full", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Buffer_Size", "Unsigned32", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Log_Buffer", "BACnetLIST of BACnetLogRecord", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Record_Count", "Unsigned32", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("Total_Record_Count", "Unsigned32", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Logging_Type", "BACnetLoggingType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Align_Intervals", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Interval_Offset", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Trigger", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Notification_Threshold", "Unsigned32", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 7)), BACnetObjectsDefinitions.p("Records_Since_Notification", "Unsigned32", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 7)), BACnetObjectsDefinitions.p("Last_Notify_Record", "Unsigned32", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 7)), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 7)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 7)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 7)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 7)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 7)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7)), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 7)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit_Ref", "BACnetObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7, 9)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 10)), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createSchedule() {
        return BACnetObjectsDefinitions.b("Schedule", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "Any", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Effective_Period", "BACnetDateRange", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Weekly_Schedule", "BACnetARRAY[7] of BACnetDailySchedule", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("Exception_Schedule", "BACnetARRAY[N] of BACnetSpecialEvent", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("Schedule_Default", "Any", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("List_Of_Object_Property_References", "BACnetLIST of BACnetDeviceObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Priority_For_Writing", "Unsigned(1..16)", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 3)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 3)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 3)), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 3)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 3)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 3)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 3)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createPulseConverter() {
        return BACnetObjectsDefinitions.b("Pulse Converter", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, 1)), BACnetObjectsDefinitions.p("Input_Reference", "BACnetObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Units", "BACnetEngineeringUnits", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Scale_Factor", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Adjust_Value", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("Count", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Update_Time", "BACnetDateTime", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Count_Change_Time", "BACnetDateTime", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Count_Before_Change", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("COV_Increment", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("COV_Period", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Time_Delay", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("High_Limit", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Low_Limit", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Deadband", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Limit_Enable", "BACnetLimitEnable", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit_Ref", "BACnetObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5, 6)), BACnetObjectsDefinitions.p("Time_Delay_Normal", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7)), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createProgram() {
        return BACnetObjectsDefinitions.b("Program", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Program_State", "BACnetProgramState", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Program_Change", "BACnetProgramRequest", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("Reason_For_Halt", "BACnetProgramError", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("Description_Of_Halt", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("Program_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Instance_Of", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 3)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 3)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 3)), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 3)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 3)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 3)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 3)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4)), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createNotificationClass() {
        return BACnetObjectsDefinitions.b("Notification Class", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Priority", "BACnetARRAY[3] of Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Ack_Required", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Recipient_List", "BACnetLIST of BACnetDestination", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 2)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 2)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 2)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 2)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 2)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createMultiStateValue() {
        return BACnetObjectsDefinitions.b("Multi-state Value", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, 1)), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Number_Of_States", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("State_Text", "BACnetARRAY[N] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Priority_Array", "BACnetPriorityArray", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Relinquish_Default", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Time_Delay", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Alarm_Values", "BACnetLIST of Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Fault_Values", "BACnetLIST of Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 8)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit_Ref", "BACnetObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6, 7)), BACnetObjectsDefinitions.p("Time_Delay_Normal", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 8)), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Current_Command_Priority", "BACnetOptionalUnsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Value_Source", "BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 9, 11, 13)), BACnetObjectsDefinitions.p("Value_Source_Array", "BACnetARRAY[16] of BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 10, 12)), BACnetObjectsDefinitions.p("Last_Command_Time", "BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 10, 12)), BACnetObjectsDefinitions.p("Command_Time_Array", "BACnetARRAY[16] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 12)), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createMultiStateOutput() {
        return BACnetObjectsDefinitions.b("Multi-state Output", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Device_Type", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Number_Of_States", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("State_Text", "BACnetARRAY[N] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Priority_Array", "BACnetPriorityArray", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Relinquish_Default", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Time_Delay", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 3)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 3)), BACnetObjectsDefinitions.p("Feedback_Value", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 3)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 3)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 3)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 3)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 3)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit_Ref", "BACnetObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 4)), BACnetObjectsDefinitions.p("Time_Delay_Normal", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Interface_Value", "BACnetOptionalUnsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Current_Command_Priority", "BACnetOptionalUnsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Value_Source", "BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6, 8, 10)), BACnetObjectsDefinitions.p("Value_Source_Array", "BACnetARRAY[16] of BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7, 9)), BACnetObjectsDefinitions.p("Last_Command_Time", "BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7, 9)), BACnetObjectsDefinitions.p("Command_Time_Array", "BACnetARRAY[16] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 9)), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createMultiStateInput() {
        return BACnetObjectsDefinitions.b("Multi-state Input", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, 1)), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Device_Type", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Number_Of_States", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("State_Text", "BACnetARRAY[N] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Time_Delay", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Alarm_Values", "BACnetLIST of Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Fault_Values", "BACnetLIST of Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit_Ref", "BACnetObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5, 6)), BACnetObjectsDefinitions.p("Time_Delay_Normal", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7)), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Interface_Value", "BACnetOptionalUnsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createLoop() {
        return BACnetObjectsDefinitions.b("Loop", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, 7)), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7)), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Update_Interval", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Output_Units", "BACnetEngineeringUnits", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Manipulated_Variable_Reference", "BACnetObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Controlled_Variable_Reference", "BACnetObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Controlled_Variable_Value", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Controlled_Variable_Units", "BACnetEngineeringUnits", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Setpoint_Reference", "BACnetSetpointReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Setpoint", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Action", "BACnetAction", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Proportional_Constant", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("Proportional_Constant_Units", "BACnetEngineeringUnits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("Integral_Constant", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Integral_Constant_Units", "BACnetEngineeringUnits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Derivative_Constant", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Derivative_Constant_Units", "BACnetEngineeringUnits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Bias", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Maximum_Output", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Minimum_Output", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Priority_For_Writing", "Unsigned(1..16)", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("COV_Increment", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4)), BACnetObjectsDefinitions.p("Time_Delay", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5, 8)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5, 8)), BACnetObjectsDefinitions.p("Error_Limit", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5, 8)), BACnetObjectsDefinitions.p("Deadband", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5, 8)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5, 8)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5, 8)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5, 8)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5, 8)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 8)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 8)), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5, 8)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit_Ref", "BACnetObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 8)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 8, 9)), BACnetObjectsDefinitions.p("Time_Delay_Normal", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 8)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 10)), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Low_Diff_Limit", "BACnetOptionalREAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createLifeSafetyZone() {
        return BACnetObjectsDefinitions.b("Life Safety Zone", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "BACnetLifeSafetyState", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Tracking_Value", "BACnetLifeSafetyState", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, 1)), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Device_Type", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, 1)), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Mode", "BACnetLifeSafetyMode", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("Accepted_Modes", "BACnetLIST of BACnetLifeSafetyMode", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Time_Delay", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 4)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 4)), BACnetObjectsDefinitions.p("Life_Safety_Alarm_Values", "BACnetLIST of BACnetLifeSafetyState", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 4)), BACnetObjectsDefinitions.p("Alarm_Values", "BACnetLIST of BACnetLifeSafetyState", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 4)), BACnetObjectsDefinitions.p("Fault_Values", "BACnetLIST of BACnetLifeSafetyState", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 4)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 4)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 4)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 4)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4)), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 4)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit_Ref", "BACnetObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Time_Delay_Normal", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Silenced", "BACnetSilencedState", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Operation_Expected", "BACnetLifeSafetyOperation", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Maintenance_Required", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Zone_Members", "BACnetLIST of BACnetDeviceObjectReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Member_Of", "BACnetLIST of BACnetDeviceObjectReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Value_Source", "BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6, 7, 8)), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createLifeSafetyPoint() {
        return BACnetObjectsDefinitions.b("Life Safety Point", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "BACnetLifeSafetyState", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Tracking_Value", "BACnetLifeSafetyState", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, 1)), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Device_Type", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, 1)), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Mode", "BACnetLifeSafetyMode", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("Accepted_Modes", "BACnetLIST of BACnetLifeSafetyMode", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Time_Delay", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 5)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 5)), BACnetObjectsDefinitions.p("Life_Safety_Alarm_Values", "BACnetLIST of BACnetLifeSafetyState", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 5)), BACnetObjectsDefinitions.p("Alarm_Values", "BACnetLIST of BACnetLifeSafetyState", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 5)), BACnetObjectsDefinitions.p("Fault_Values", "BACnetLIST of BACnetLifeSafetyState", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 5)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 5)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 5)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 5)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 5)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit_Ref", "BACnetObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5, 6)), BACnetObjectsDefinitions.p("Time_Delay_Normal", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Silenced", "BACnetSilencedState", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Operation_Expected", "BACnetLifeSafetyOperation", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Maintenance_Required", "BACnetMaintenance", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Setting", "Unsigned8", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Direct_Reading", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Units", "BACnetEngineeringUnits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Member_Of", "BACnetLIST of BACnetDeviceObjectReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Value_Source", "BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7, 8, 9)), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createGroup() {
        return BACnetObjectsDefinitions.b("Group", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("List_Of_Group_Members", "BACnetLIST of ReadAccessSpecification", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "BACnetLIST of ReadAccessResult", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createFile() {
        return BACnetObjectsDefinitions.b("File", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("File_Type", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("File_Size", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, 1)), BACnetObjectsDefinitions.p("Modification_Date", "BACnetDateTime", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Archive", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("Read_Only", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("File_Access_Method", "BACnetFileAccessMethod", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Record_Count", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createEventEnrollment() {
        return BACnetObjectsDefinitions.b("Event Enrollment", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Event_Type", "BACnetEventType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_Parameters", "BACnetEventParameter", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Property_Reference", "BACnetDeviceObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit_Ref", "BACnetObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Time_Delay_Normal", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Fault_Type", "BACnetFaultType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Fault_Parameters", "BACnetFaultParameter", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createDevice() {
        return BACnetObjectsDefinitions.b("Device", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("System_Status", "BACnetDeviceStatus", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Vendor_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Vendor_Identifier", "Unsigned16", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Model_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Firmware_Revision", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Application_Software_Version", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Protocol_Version", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Protocol_Revision", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Protocol_Services_Supported", "BACnetServicesSupported", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Protocol_Object_Types_Supported", "BACnetObjectTypesSupported", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_List", "BACnetARRAY[N] of BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Structured_Object_List", "BACnetARRAY[N] of BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Max_APDU_Length_Accepted", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Segmentation_Supported", "BACnetSegmentation", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Max_Segments_Accepted", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("VT_Classes_Supported", "BACnetLIST of BACnetVTClass", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Active_VT_Sessions", "BACnetLIST of BACnetVTSession", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Local_Time", "Time", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 4, 15)), BACnetObjectsDefinitions.p("Local_Date", "Date", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 4, 15)), BACnetObjectsDefinitions.p("UTC_Offset", "INTEGER", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4)), BACnetObjectsDefinitions.p("Daylight_Savings_Status", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4)), BACnetObjectsDefinitions.p("APDU_Segment_Timeout", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("APDU_Timeout", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Number_Of_APDU_Retries", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Time_Synchronization_Recipients", "BACnetLIST of BACnetRecipient", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Max_Master", "Unsigned(0..127)", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Max_Info_Frames", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Device_Address_Binding", "BACnetLIST of BACnetAddressBinding", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Database_Revision", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Configuration_Files", "BACnetARRAY[N] of BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7)), BACnetObjectsDefinitions.p("Last_Restore_Time", "BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7)), BACnetObjectsDefinitions.p("Backup_Failure_Timeout", "Unsigned16", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 8)), BACnetObjectsDefinitions.p("Backup_Preparation_Time", "Unsigned16", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 16)), BACnetObjectsDefinitions.p("Restore_Preparation_Time", "Unsigned16", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 16)), BACnetObjectsDefinitions.p("Restore_Completion_Time", "Unsigned16", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 16)), BACnetObjectsDefinitions.p("Backup_And_Restore_State", "BACnetBackupState", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7)), BACnetObjectsDefinitions.p("Active_COV_Subscriptions", "BACnetLIST of BACnetCOVSubscription", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 9)), BACnetObjectsDefinitions.p("Last_Restart_Reason", "BACnetRestartReason", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 13)), BACnetObjectsDefinitions.p("Time_Of_Device_Restart", "BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 13)), BACnetObjectsDefinitions.p("Restart_Notification_Recipients", "BACnetLIST of BACnetRecipient", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 17)), BACnetObjectsDefinitions.p("UTC_Time_Synchronization_Recipients", "BACnetLIST of BACnetRecipient", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Time_Synchronization_Interval", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Align_Intervals", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Interval_Offset", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Serial_Number", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 18)), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 18)), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 18)), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 18, 19)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 18, 19)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 18, 19)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 18, 19)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 18, 19)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 18, 19)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 19)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 19)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 20)), BACnetObjectsDefinitions.p("Active_COV_Multiple_Subscriptions", "BACnetLIST of BACnetCOVMultipleSubscription", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 21)), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Deployed_Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 22)), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createCommand() {
        return BACnetObjectsDefinitions.b("Command", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("In_Process", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("All_Writes_Successful", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Action", "BACnetARRAY[N] of BACnetActionList", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Action_Text", "BACnetARRAY[N] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 2)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 2)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 2)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 2)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 2)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1, 2)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Value_Source", "BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5, 6)), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createCalendar() {
        return BACnetObjectsDefinitions.b("Calendar", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Date_List", "BACnetLIST of BACnetCalendarEntry", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createBinaryValue() {
        return BACnetObjectsDefinitions.b("Binary Value", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "BACnetBinaryPV", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, 1)), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Inactive_Text", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Active_Text", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Change_Of_State_Time", "BACnetDateTime", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Change_Of_State_Count", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Time_Of_State_Count_Reset", "BACnetDateTime", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Elapsed_Active_Time", "Unsigned32", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4)), BACnetObjectsDefinitions.p("Time_Of_Active_Time_Reset", "BACnetDateTime", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4)), BACnetObjectsDefinitions.p("Minimum_Off_Time", "Unsigned32", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Minimum_On_Time", "Unsigned32", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Priority_Array", "BACnetPriorityArray", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Relinquish_Default", "BACnetBinaryPV", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Time_Delay", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6, 8)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6, 8)), BACnetObjectsDefinitions.p("Alarm_Value", "BACnetBinaryPV", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6, 8)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6, 8)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6, 8)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6, 8)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6, 8)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 8)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 8)), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6, 8)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit_Ref", "BACnetObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 8)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 8, 9)), BACnetObjectsDefinitions.p("Time_Delay_Normal", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 8)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 10)), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Current_Command_Priority", "BACnetOptionalUnsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Value_Source", "BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 11, 13, 15)), BACnetObjectsDefinitions.p("Value_Source_Array", "BACnetARRAY[16] of BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 12, 14)), BACnetObjectsDefinitions.p("Last_Command_Time", "BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 12, 14)), BACnetObjectsDefinitions.p("Command_Time_Array", "BACnetARRAY[16] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 14)), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createBinaryOutput() {
        return BACnetObjectsDefinitions.b("Binary Output", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "BACnetBinaryPV", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Device_Type", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Polarity", "BACnetPolarity", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Inactive_Text", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("Active_Text", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("Change_Of_State_Time", "BACnetDateTime", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Change_Of_State_Count", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Time_Of_State_Count_Reset", "BACnetDateTime", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Elapsed_Active_Time", "Unsigned32", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Time_Of_Active_Time_Reset", "BACnetDateTime", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Minimum_Off_Time", "Unsigned32", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Minimum_On_Time", "Unsigned32", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Priority_Array", "BACnetPriorityArray", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Relinquish_Default", "BACnetBinaryPV", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Time_Delay", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Feedback_Value", "BACnetBinaryPV", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 6)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit_Ref", "BACnetObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6, 7)), BACnetObjectsDefinitions.p("Time_Delay_Normal", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 8)), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Interface_Value", "BACnetOptionalBinaryPV", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Current_Command_Priority", "BACnetOptionalUnsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Value_Source", "BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 9, 11, 13)), BACnetObjectsDefinitions.p("Value_Source_Array", "BACnetARRAY[16] of BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 10, 12)), BACnetObjectsDefinitions.p("Last_Command_Time", "BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 10, 12)), BACnetObjectsDefinitions.p("Command_Time_Array", "BACnetARRAY[16] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 12)), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createBinarInput() {
        return BACnetObjectsDefinitions.b("Binary Input", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "BACnetBinaryPV", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, 1)), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Device_Type", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Polarity", "BACnetPolarity", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Inactive_Text", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Active_Text", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Change_Of_State_Time", "BACnetDateTime", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Change_Of_State_Count", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Time_Of_State_Count_Reset", "BACnetDateTime", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3)), BACnetObjectsDefinitions.p("Elapsed_Active_Time", "Unsigned32", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4)), BACnetObjectsDefinitions.p("Time_Of_Active_Time_Reset", "BACnetDateTime", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4)), BACnetObjectsDefinitions.p("Time_Delay", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5, 7)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5, 7)), BACnetObjectsDefinitions.p("Alarm_Value", "BACnetBinaryPV", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5, 7)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5, 7)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5, 7)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5, 7)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5, 7)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7)), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5, 7)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit_Ref", "BACnetObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7, 8)), BACnetObjectsDefinitions.p("Time_Delay_Normal", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 9)), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Interface_Value", "BACnetOptionalBinaryPV", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createAveraging() {
        return BACnetObjectsDefinitions.b("Averaging", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Minimum_Value", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Minimum_Value_Timestamp", "BACnetDateTime", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Average_Value", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Variance_Value", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Maximum_Value", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Maximum_Value_Timestamp", "BACnetDateTime", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Attempted_Samples", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, 1)), BACnetObjectsDefinitions.p("Valid_Samples", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Property_Reference", "BACnetDeviceObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, 1)), BACnetObjectsDefinitions.p("Window_Interval", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, 1)), BACnetObjectsDefinitions.p("Window_Samples", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, 1)), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createAnalogValue() {
        return BACnetObjectsDefinitions.b("Analog Value", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, 4)), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Units", "BACnetEngineeringUnits", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Priority_Array", "BACnetPriorityArray", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("Relinquish_Default", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("COV_Increment", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Time_Delay", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 6)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 6)), BACnetObjectsDefinitions.p("High_Limit", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 6)), BACnetObjectsDefinitions.p("Low_Limit", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 6)), BACnetObjectsDefinitions.p("Deadband", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 6)), BACnetObjectsDefinitions.p("Limit_Enable", "BACnetLimitEnable", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 6)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 6)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 6)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 6)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 6)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 6)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit_Ref", "BACnetObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6, 7)), BACnetObjectsDefinitions.p("Time_Delay_Normal", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 8)), BACnetObjectsDefinitions.p("Min_Pres_Value", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Max_Pres_Value", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Resolution", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Fault_High_Limit", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 9)), BACnetObjectsDefinitions.p("Fault_Low_Limit", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 9)), BACnetObjectsDefinitions.p("Current_Command_Priority", "BACnetOptionalUnsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("Value_Source", "BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 10, 12, 14)), BACnetObjectsDefinitions.p("Value_Source_Array", "BACnetARRAY[16] of BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 11, 13)), BACnetObjectsDefinitions.p("Last_Command_Time", "BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 11, 13)), BACnetObjectsDefinitions.p("Command_Time_Array", "BACnetARRAY[16] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 13)), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createAnalogOutput() {
        return BACnetObjectsDefinitions.b("Analog Output", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.W, new Integer[0])), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Device_Type", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Units", "BACnetEngineeringUnits", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Min_Pres_Value", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Max_Pres_Value", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Resolution", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Priority_Array", "BACnetPriorityArray", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Relinquish_Default", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("COV_Increment", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 1)), BACnetObjectsDefinitions.p("Time_Delay", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 4)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 4)), BACnetObjectsDefinitions.p("High_Limit", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 4)), BACnetObjectsDefinitions.p("Low_Limit", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 4)), BACnetObjectsDefinitions.p("Deadband", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 4)), BACnetObjectsDefinitions.p("Limit_Enable", "BACnetLimitEnable", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 4)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 4)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 4)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 4)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 4)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4)), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2, 4)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit_Ref", "BACnetObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4, 5)), BACnetObjectsDefinitions.p("Time_Delay_Normal", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 4)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 6)), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Interface_Value", "BACnetOptionalREAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Current_Command_Priority", "BACnetOptionalUnsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Value_Source", "BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7, 9, 11)), BACnetObjectsDefinitions.p("Value_Source_Array", "BACnetARRAY[16] of BACnetValueSource", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 8, 10)), BACnetObjectsDefinitions.p("Last_Command_Time", "BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 8, 10)), BACnetObjectsDefinitions.p("Command_Time_Array", "BACnetARRAY[16] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 10)), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static BacNetObject createAnalogInput() {
        return BACnetObjectsDefinitions.b("Analog Input", BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Identifier", "BACnetObjectIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Object_Type", "BACnetObjectType", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Present_Value", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, 1)), BACnetObjectsDefinitions.p("Description", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Device_Type", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Status_Flags", "BACnetStatusFlags", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Event_State", "BACnetEventState", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Reliability", "BACnetReliability", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Out_Of_Service", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Update_Interval", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Units", "BACnetEngineeringUnits", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Min_Pres_Value", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Max_Pres_Value", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Resolution", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("COV_Increment", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 2)), BACnetObjectsDefinitions.p("Time_Delay", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Notification_Class", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("High_Limit", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Low_Limit", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Deadband", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Limit_Enable", "BACnetLimitEnable", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Event_Enable", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Acked_Transitions", "BACnetEventTransitionBits", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Notify_Type", "BACnetNotifyType", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Event_Time_Stamps", "BACnetARRAY[3] of BACnetTimeStamp", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Event_Message_Texts", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Event_Message_Texts_Config", "BACnetARRAY[3] of CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Event_Detection_Enable", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 3, 5)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit_Ref", "BACnetObjectPropertyReference", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Event_Algorithm_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5, 6)), BACnetObjectsDefinitions.p("Time_Delay_Normal", "Unsigned", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 5)), BACnetObjectsDefinitions.p("Reliability_Evaluation_Inhibit", "BOOLEAN", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 7)), BACnetObjectsDefinitions.p("Property_List", "BACnetARRAY[N] of BACnetPropertyIdentifier", BACnetObjectsDefinitions.c(ConformanceCode.Type.R, new Integer[0])), BACnetObjectsDefinitions.p("Interface_Value", "BACnetOptionalREAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Fault_High_Limit", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 8)), BACnetObjectsDefinitions.p("Fault_Low_Limit", "REAL", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, 8)), BACnetObjectsDefinitions.p("Tags", "BACnetARRAY[N] of BACnetNameValue", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Location", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])), BACnetObjectsDefinitions.p("Profile_Name", "CharacterString", BACnetObjectsDefinitions.c(ConformanceCode.Type.O, new Integer[0])));
    }

    private static void createObjectNameToBacNetObjectMap() {
        objectNameToBacNetObjectMap = bacNetObjects.stream().collect(Collectors.toMap(BACnetObjectsDefinitions::mapObjectNameToEnumName, bacNetObject -> bacNetObject));
    }

    static String mapObjectNameToEnumName(BacNetObject bacNetObject) {
        return BACnetObjectsDefinitions.mapObjectNameToEnumName(bacNetObject.name);
    }

    static String mapObjectNameToEnumName(String name) {
        String spacesReplaced;
        String upperCase = name.toUpperCase();
        String minusReplaced = upperCase.replaceAll("-", "_");
        String mappedName = spacesReplaced = minusReplaced.replaceAll(" ", "_");
        switch (spacesReplaced) {
            case "DATE_PATTERN_VALUE": {
                mappedName = "DATEPATTERN_VALUE";
                break;
            }
            case "DATETIME_PATTERN_VALUE": {
                mappedName = "DATETIMEPATTERN_VALUE";
                break;
            }
            case "TIME_PATTERN_VALUE": {
                mappedName = "TIMEPATTERN_VALUE";
            }
        }
        return mappedName;
    }

    private static void createPropertyToObjectNameMap() {
        propertyToObjectNamesMap = new HashMap<String, List<String>>();
        bacNetObjects.forEach(bacNetObject -> {
            String bacNetObjectName = bacNetObject.name;
            bacNetObject.properties.forEach(bacNetProperty -> {
                String propertyIdentifier = bacNetProperty.propertyIdentifier;
                propertyToObjectNamesMap.putIfAbsent(propertyIdentifier, new LinkedList());
                propertyToObjectNamesMap.get(propertyIdentifier).add(bacNetObjectName);
            });
        });
    }

    private static void createPropertyTypeCombinationToObjectNameMap() {
        propertyTypeCombinationToObjectNameMap = new HashMap<PropertyTypeCombination, List<String>>();
        bacNetObjects.forEach(bacNetObject -> {
            String bacNetObjectName = bacNetObject.name;
            bacNetObject.properties.forEach(bacNetProperty -> {
                PropertyTypeCombination propertyTypeCombination = new PropertyTypeCombination((BacNetProperty)bacNetProperty);
                propertyTypeCombinationToObjectNameMap.putIfAbsent(propertyTypeCombination, new LinkedList());
                propertyTypeCombinationToObjectNameMap.get(propertyTypeCombination).add(bacNetObjectName);
            });
        });
    }

    private static void createPropertyTypeCombinationCount() {
        propertyTypeCombinationCount = new HashMap<PropertyTypeCombination, Integer>();
        bacNetObjects.forEach(bacNetObject -> bacNetObject.properties.forEach(bacNetProperty -> {
            PropertyTypeCombination propertyTypeCombination = new PropertyTypeCombination((BacNetProperty)bacNetProperty);
            propertyTypeCombinationCount.putIfAbsent(propertyTypeCombination, 0);
            int count = propertyTypeCombinationCount.get(propertyTypeCombination);
            propertyTypeCombinationCount.put(propertyTypeCombination, ++count);
        }));
    }

    static void createPropertyIdToPropertyNameMap() {
        propertyIdToPropertyNameMap = new HashMap<String, String>();
        propertyToObjectNamesMap.keySet().forEach(propertyName -> {
            String string = propertyIdToPropertyNameMap.put(BACnetObjectsDefinitions.mapPropertyNameToEnumName(propertyName), (String)propertyName);
        });
    }

    static void createPropertyToPropertyTypesMaps() {
        propertyToPropertyTypesMaps = new HashMap<String, Set<String>>();
        propertyTypeCombinationToObjectNameMap.keySet().forEach(propertyTypeCombination -> {
            propertyToPropertyTypesMaps.putIfAbsent(propertyTypeCombination.propertyIdentifier, new HashSet());
            propertyToPropertyTypesMaps.get(propertyTypeCombination.propertyIdentifier).add(propertyTypeCombination.propertyDataType);
        });
    }

    static String mapPropertyNameToEnumName(String propertyName) {
        String spacesReplaced;
        String upperCase = propertyName.toUpperCase();
        String minusReplaced = upperCase.replaceAll("-", "_");
        String mappedName = spacesReplaced = minusReplaced.replaceAll(" ", "_");
        switch (spacesReplaced) {
            case "TODO": {
                mappedName = "TODO";
            }
        }
        return mappedName;
    }

    static BacNetObject b(String name, BacNetProperty ... properties) {
        return new BacNetObject(name, List.of(properties));
    }

    static BacNetProperty p(String propertyIdentifier, String propertyDataType, ConformanceCode conformanceCode) {
        return new BacNetProperty(propertyIdentifier, propertyDataType, conformanceCode);
    }

    static ConformanceCode c(ConformanceCode.Type type, Integer ... footnotes) {
        return new ConformanceCode(type, List.of(footnotes));
    }

    static class BacNetObject {
        final String name;
        final List<BacNetProperty> properties;

        BacNetObject(String name, List<BacNetProperty> properties) {
            this.name = name;
            this.properties = properties;
        }
    }

    static class BacNetProperty {
        final String propertyIdentifier;
        final String propertyDataType;
        final ConformanceCode conformanceCode;

        BacNetProperty(String propertyIdentifier, String propertyDataType, ConformanceCode conformanceCode) {
            this.propertyIdentifier = propertyIdentifier;
            this.propertyDataType = propertyDataType;
            this.conformanceCode = conformanceCode;
        }
    }

    static class ConformanceCode {
        final Type type;
        final List<Integer> additionalFootnotes;

        public ConformanceCode(Type type, List<Integer> additionalFootnotes) {
            this.type = type;
            this.additionalFootnotes = additionalFootnotes;
        }

        static enum Type {
            R,
            W,
            O;

        }
    }

    static class PropertyTypeCombination
    implements Comparable<PropertyTypeCombination> {
        final String propertyIdentifier;
        final String propertyDataType;

        PropertyTypeCombination(BacNetProperty bacNetProperty) {
            this.propertyIdentifier = bacNetProperty.propertyIdentifier;
            this.propertyDataType = bacNetProperty.propertyDataType;
        }

        PropertyTypeCombination(String propertyIdentifier, String propertyDataType) {
            this.propertyIdentifier = propertyIdentifier;
            this.propertyDataType = propertyDataType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PropertyTypeCombination that = (PropertyTypeCombination)o;
            return this.propertyIdentifier.equals(that.propertyIdentifier) && this.propertyDataType.equals(that.propertyDataType);
        }

        public int hashCode() {
            return Objects.hash(this.propertyIdentifier, this.propertyDataType);
        }

        public String toString() {
            return String.valueOf(this.propertyIdentifier) + ':' + this.propertyDataType;
        }

        @Override
        public int compareTo(PropertyTypeCombination propertyTypeCombination) {
            return this.toString().compareTo(propertyTypeCombination.toString());
        }
    }
}

