/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.plugins.codegenerator.language.mspec.protocol;

import java.io.InputStream;
import java.util.Objects;
import org.apache.plc4x.plugins.codegenerator.protocol.Protocol;
import org.apache.plc4x.plugins.codegenerator.types.exceptions.GenerationException;

public interface ProtocolHelpers
extends Protocol {
    default public InputStream getMspecStream() throws GenerationException {
        return this.getMspecStream(this.getName());
    }

    default public InputStream getMspecStream(String mspecName) throws GenerationException {
        Objects.requireNonNull(mspecName, "mspecName must be set");
        String versionSubPath = this.getVersion().map(version -> "/v" + version).orElse("");
        String packageName = this.getPackageName();
        String path = "/protocols/" + packageName + versionSubPath + "/" + mspecName + ".mspec";
        InputStream inputStream = this.getClass().getResourceAsStream(path);
        if (inputStream == null) {
            throw new GenerationException("Error loading " + mspecName + " schema for protocol '" + this.getName() + "' (path " + path + ")");
        }
        return inputStream;
    }

    default public String getSanitizedName() {
        return Objects.requireNonNull(this.getName(), "protocol should return useful value at getName()").replaceAll("-", "");
    }

    default public String getPackageName() {
        return this.getSanitizedName();
    }
}

