/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.plugins.codegenerator.language.mspec.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.apache.plc4x.plugins.codegenerator.language.mspec.MSpecLexer;
import org.apache.plc4x.plugins.codegenerator.language.mspec.MSpecParser;
import org.apache.plc4x.plugins.codegenerator.language.mspec.parser.MessageFormatListener;
import org.apache.plc4x.plugins.codegenerator.language.mspec.protocol.ValidatableTypeContext;
import org.apache.plc4x.plugins.codegenerator.protocol.TypeContext;
import org.apache.plc4x.plugins.codegenerator.types.definitions.TypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageFormatParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageFormatParser.class);

    public ValidatableTypeContext parse(InputStream source) {
        return this.parse(source, null);
    }

    public ValidatableTypeContext parse(InputStream source, TypeContext existingTypeContext) {
        MessageFormatListener listener;
        MSpecLexer lexer;
        LOGGER.debug("Parsing: {}", (Object)source);
        try {
            lexer = new MSpecLexer(CharStreams.fromStream((InputStream)source));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (existingTypeContext == null) {
            listener = new MessageFormatListener();
        } else {
            if (LOGGER.isDebugEnabled()) {
                Map unresolvedTypeReferences;
                Map exitingTypeDefinitions = existingTypeContext.getTypeDefinitions();
                if (exitingTypeDefinitions != null) {
                    LOGGER.debug("Continue with {} exitingTypeDefinitions", (Object)exitingTypeDefinitions.size());
                }
                if ((unresolvedTypeReferences = existingTypeContext.getUnresolvedTypeReferences()) != null) {
                    LOGGER.debug("Continue with {} unresolvedTypeReferences", (Object)unresolvedTypeReferences.size());
                }
            }
            listener = new MessageFormatListener(existingTypeContext);
        }
        new ParseTreeWalker().walk((ParseTreeListener)listener, (ParseTree)new MSpecParser((TokenStream)new CommonTokenStream((TokenSource)lexer)).file());
        LOGGER.info("Checking for open consumers");
        listener.typeDefinitionConsumers.forEach((key, value) -> LOGGER.warn("{} has {} open consumers", key, (Object)value.size()));
        return new ValidatableTypeContext(){

            public Map<String, TypeDefinition> getTypeDefinitions() {
                return listener.types;
            }

            public Map<String, List<Consumer<TypeDefinition>>> getUnresolvedTypeReferences() {
                return listener.typeDefinitionConsumers;
            }
        };
    }
}

