/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.plugins.codegenerator.language.mspec.parser;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.RuleContext;
import org.apache.commons.io.IOUtils;
import org.apache.plc4x.plugins.codegenerator.language.mspec.LazyTypeDefinitionConsumer;
import org.apache.plc4x.plugins.codegenerator.language.mspec.MSpecBaseListener;
import org.apache.plc4x.plugins.codegenerator.language.mspec.MSpecParser;
import org.apache.plc4x.plugins.codegenerator.language.mspec.expression.ExpressionStringParser;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.definitions.DefaultArgument;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.definitions.DefaultComplexTypeDefinition;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.definitions.DefaultDataIoTypeDefinition;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.definitions.DefaultDiscriminatedComplexTypeDefinition;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.definitions.DefaultEnumTypeDefinition;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.definitions.DefaultEnumValue;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.fields.DefaultAbstractField;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.fields.DefaultArrayField;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.fields.DefaultAssertField;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.fields.DefaultChecksumField;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.fields.DefaultConstField;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.fields.DefaultDiscriminatorField;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.fields.DefaultEnumField;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.fields.DefaultField;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.fields.DefaultImplicitField;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.fields.DefaultManualArrayField;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.fields.DefaultManualField;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.fields.DefaultOptionalField;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.fields.DefaultPaddingField;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.fields.DefaultPeekField;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.fields.DefaultReservedField;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.fields.DefaultSimpleField;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.fields.DefaultSwitchField;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.fields.DefaultUnknownField;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.fields.DefaultValidationField;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.fields.DefaultVirtualField;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.references.DefaultArrayTypeReference;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.references.DefaultBooleanTypeReference;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.references.DefaultByteTypeReference;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.references.DefaultComplexTypeReference;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.references.DefaultDataIoTypeReference;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.references.DefaultEnumTypeReference;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.references.DefaultFloatTypeReference;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.references.DefaultIntegerTypeReference;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.references.DefaultStringTypeReference;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.references.DefaultTemporalTypeReference;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.references.DefaultVintegerTypeReference;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.references.DefaultVstringTypeReference;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.terms.WildcardTerm;
import org.apache.plc4x.plugins.codegenerator.protocol.TypeContext;
import org.apache.plc4x.plugins.codegenerator.types.definitions.Argument;
import org.apache.plc4x.plugins.codegenerator.types.definitions.DiscriminatedComplexTypeDefinition;
import org.apache.plc4x.plugins.codegenerator.types.definitions.TypeDefinition;
import org.apache.plc4x.plugins.codegenerator.types.enums.EnumValue;
import org.apache.plc4x.plugins.codegenerator.types.fields.ArrayField;
import org.apache.plc4x.plugins.codegenerator.types.fields.Field;
import org.apache.plc4x.plugins.codegenerator.types.fields.ManualArrayField;
import org.apache.plc4x.plugins.codegenerator.types.fields.SwitchField;
import org.apache.plc4x.plugins.codegenerator.types.references.SimpleTypeReference;
import org.apache.plc4x.plugins.codegenerator.types.references.TypeReference;
import org.apache.plc4x.plugins.codegenerator.types.terms.Literal;
import org.apache.plc4x.plugins.codegenerator.types.terms.NumericLiteral;
import org.apache.plc4x.plugins.codegenerator.types.terms.Term;
import org.apache.plc4x.plugins.codegenerator.types.terms.VariableLiteral;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageFormatListener
extends MSpecBaseListener
implements LazyTypeDefinitionConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageFormatListener.class);
    private Deque<List<Field>> parserContexts;
    private Deque<List<EnumValue>> enumContexts;
    protected final Map<String, TypeDefinition> types;
    protected final Map<String, List<Consumer<TypeDefinition>>> typeDefinitionConsumers;
    private final Stack<Map<String, Term>> batchSetAttributes = new Stack();
    private final Stack<String> currentTypeName = new Stack();

    public Deque<List<Field>> getParserContexts() {
        return this.parserContexts;
    }

    public Deque<List<EnumValue>> getEnumContexts() {
        return this.enumContexts;
    }

    public MessageFormatListener() {
        this.types = new HashMap<String, TypeDefinition>();
        this.typeDefinitionConsumers = new HashMap<String, List<Consumer<TypeDefinition>>>();
    }

    public MessageFormatListener(TypeContext exitingTypeContext) {
        this.types = new HashMap<String, TypeDefinition>(exitingTypeContext.getTypeDefinitions());
        this.typeDefinitionConsumers = new HashMap<String, List<Consumer<TypeDefinition>>>(exitingTypeContext.getUnresolvedTypeReferences());
    }

    @Override
    public void enterFile(MSpecParser.FileContext ctx) {
        this.parserContexts = new LinkedList<List<Field>>();
        this.enumContexts = new LinkedList<List<EnumValue>>();
    }

    @Override
    public void enterComplexType(MSpecParser.ComplexTypeContext ctx) {
        this.currentTypeName.push(this.getIdString(ctx.name));
        HashMap<String, Term> curBatchSetAttributes = new HashMap<String, Term>();
        for (MSpecParser.AttributeContext attributeContext : ctx.attributes.attribute()) {
            Term attributeExpression = this.getExpressionTerm(attributeContext.value);
            curBatchSetAttributes.put(attributeContext.name.getText(), attributeExpression);
        }
        this.batchSetAttributes.push(curBatchSetAttributes);
        if (ctx.enumValues != null) {
            LinkedList enumContext = new LinkedList();
            this.enumContexts.push(enumContext);
        } else {
            LinkedList parserContext = new LinkedList();
            this.parserContexts.push(parserContext);
        }
    }

    @Override
    public void exitComplexType(MSpecParser.ComplexTypeContext ctx) {
        String typeName = this.getIdString(ctx.name);
        List<Argument> parserArguments = null;
        if (ctx.params != null) {
            parserArguments = this.getParserArguments(ctx.params.argument());
        }
        Map<String, Term> attributes = this.batchSetAttributes.peek();
        if (ctx.enumValues != null) {
            SimpleTypeReference type = ctx.type != null ? this.getSimpleTypeReference(ctx.type) : null;
            List<EnumValue> enumValues = this.getEnumValues();
            if (type == null) {
                type = new DefaultIntegerTypeReference(SimpleTypeReference.SimpleBaseType.UINT, 32);
            }
            DefaultEnumTypeDefinition enumType = new DefaultEnumTypeDefinition(typeName, type, attributes, enumValues, parserArguments);
            this.dispatchType(typeName, (TypeDefinition)enumType);
            this.enumContexts.pop();
        } else if (ctx.dataIoTypeSwitch != null) {
            DefaultSwitchField switchField = this.getSwitchField();
            DefaultDataIoTypeDefinition type = new DefaultDataIoTypeDefinition(typeName, attributes, parserArguments, switchField);
            this.dispatchType(typeName, (TypeDefinition)type);
            if (switchField != null) {
                for (DiscriminatedComplexTypeDefinition subtype : switchField.getCases()) {
                    if (!(subtype instanceof DefaultDiscriminatedComplexTypeDefinition)) continue;
                    LOGGER.debug("Setting parent {} for {}", (Object)type, (Object)subtype);
                    ((DefaultDiscriminatedComplexTypeDefinition)subtype).setParentType(type);
                }
            }
            this.parserContexts.pop();
        } else {
            DefaultSwitchField switchField = this.getSwitchField();
            boolean abstractType = switchField != null;
            List<Field> fields = this.parserContexts.pop();
            DefaultComplexTypeDefinition type = new DefaultComplexTypeDefinition(typeName, attributes, parserArguments, abstractType, fields);
            if (fields != null) {
                fields.forEach(field -> ((DefaultField)field).setOwner((TypeDefinition)type));
            }
            this.dispatchType(typeName, (TypeDefinition)type);
            this.setParentRelationship(type);
        }
        this.currentTypeName.pop();
    }

    protected void setParentRelationship(DefaultComplexTypeDefinition type) {
        Optional switchField = type.getSwitchField();
        if (switchField.isPresent()) {
            for (DiscriminatedComplexTypeDefinition subtype : ((SwitchField)switchField.get()).getCases()) {
                if (!(subtype instanceof DefaultDiscriminatedComplexTypeDefinition)) continue;
                LOGGER.debug("Setting parent {} for {}", (Object)type, (Object)subtype);
                ((DefaultDiscriminatedComplexTypeDefinition)subtype).setParentType(type);
                this.setParentRelationship((DefaultDiscriminatedComplexTypeDefinition)subtype);
            }
        }
    }

    @Override
    public void enterBatchSetDefinition(MSpecParser.BatchSetDefinitionContext ctx) {
        HashMap<String, Term> curBatchSetAttributes = new HashMap<String, Term>();
        if (!this.batchSetAttributes.empty()) {
            curBatchSetAttributes.putAll(this.batchSetAttributes.peek());
        }
        for (MSpecParser.AttributeContext attributeContext : ctx.attributes.attribute()) {
            Term attributeExpression = this.getExpressionTerm(attributeContext.value);
            curBatchSetAttributes.put(attributeContext.name.getText(), attributeExpression);
        }
        this.batchSetAttributes.push(curBatchSetAttributes);
    }

    @Override
    public void exitBatchSetDefinition(MSpecParser.BatchSetDefinitionContext ctx) {
        this.batchSetAttributes.pop();
    }

    @Override
    public void enterAbstractField(MSpecParser.AbstractFieldContext ctx) {
        String name = this.getIdString(ctx.name);
        DefaultAbstractField field = new DefaultAbstractField(this.getAttributes((RuleContext)ctx), name);
        this.getTypeReference(ctx.type).whenComplete((typeReference, throwable) -> {
            if (throwable != null) {
                LOGGER.debug("Error setting type for {}", (Object)field, throwable);
                return;
            }
            field.setType((TypeReference)typeReference);
        });
        if (this.parserContexts.peek() != null) {
            this.parserContexts.peek().add((Field)field);
        }
    }

    @Override
    public void enterArrayField(MSpecParser.ArrayFieldContext ctx) {
        String name = this.getIdString(ctx.name);
        ArrayField.LoopType loopType = ArrayField.LoopType.valueOf((String)ctx.loopType.getText().toUpperCase());
        Term loopExpression = this.getExpressionTerm(ctx.loopExpression);
        DefaultArrayField field = new DefaultArrayField(this.getAttributes((RuleContext)ctx), name, loopType, loopExpression);
        this.getTypeReference(ctx.type).whenComplete((typeReference, throwable) -> {
            if (throwable != null) {
                LOGGER.debug("Error setting type for {}", (Object)field, throwable);
                return;
            }
            field.setType((TypeReference)new DefaultArrayTypeReference((TypeReference)typeReference));
        });
        if (this.parserContexts.peek() != null) {
            this.parserContexts.peek().add((Field)field);
        }
    }

    @Override
    public void enterChecksumField(MSpecParser.ChecksumFieldContext ctx) {
        SimpleTypeReference type = this.getSimpleTypeReference(ctx.type);
        String name = this.getIdString(ctx.name);
        Term checksumExpression = this.getExpressionTerm(ctx.checksumExpression);
        DefaultChecksumField field = new DefaultChecksumField(this.getAttributes((RuleContext)ctx), type, name, checksumExpression);
        if (this.parserContexts.peek() != null) {
            this.parserContexts.peek().add((Field)field);
        }
    }

    @Override
    public void enterConstField(MSpecParser.ConstFieldContext ctx) {
        String name = this.getIdString(ctx.name);
        DefaultConstField field = new DefaultConstField(this.getAttributes((RuleContext)ctx), name, this.getValueLiteral(ctx.expected));
        if (ctx.type.dataType() != null) {
            field.setType((TypeReference)this.getSimpleTypeReference(ctx.type.dataType()));
        } else {
            this.getTypeReference(ctx.type).whenComplete((typeReference, throwable) -> {
                if (throwable != null) {
                    LOGGER.debug("Error setting type for {}", (Object)field, throwable);
                    return;
                }
                field.setType((TypeReference)typeReference);
            });
        }
        if (this.parserContexts.peek() != null) {
            this.parserContexts.peek().add((Field)field);
        }
    }

    @Override
    public void enterDiscriminatorField(MSpecParser.DiscriminatorFieldContext ctx) {
        String name = this.getIdString(ctx.name);
        DefaultDiscriminatorField field = new DefaultDiscriminatorField(this.getAttributes((RuleContext)ctx), name);
        this.getTypeReference(ctx.type).whenComplete((typeReference, throwable) -> {
            if (throwable != null) {
                LOGGER.debug("Error setting type for {}", (Object)field, throwable);
                return;
            }
            field.setType((TypeReference)typeReference);
        });
        if (this.parserContexts.peek() != null) {
            this.parserContexts.peek().add((Field)field);
        }
    }

    @Override
    public void enterEnumField(MSpecParser.EnumFieldContext ctx) {
        String typeRefName = ctx.type.complexTypeReference.getText();
        DefaultEnumTypeReference type = new DefaultEnumTypeReference(typeRefName, null);
        this.setOrScheduleTypeDefinitionConsumer(typeRefName, type::setTypeDefinition);
        String name = this.getIdString(ctx.name);
        String fieldName = null;
        if (ctx.fieldName != null) {
            fieldName = this.getIdString(ctx.fieldName);
        }
        DefaultEnumField field = new DefaultEnumField(this.getAttributes((RuleContext)ctx), type, name, fieldName);
        if (this.parserContexts.peek() != null) {
            this.parserContexts.peek().add((Field)field);
        }
    }

    @Override
    public void enterImplicitField(MSpecParser.ImplicitFieldContext ctx) {
        SimpleTypeReference type = this.getSimpleTypeReference(ctx.type);
        String name = this.getIdString(ctx.name);
        Term serializeExpression = this.getExpressionTerm(ctx.serializeExpression);
        DefaultImplicitField field = new DefaultImplicitField(this.getAttributes((RuleContext)ctx), type, name, serializeExpression);
        if (this.parserContexts.peek() != null) {
            this.parserContexts.peek().add((Field)field);
        }
    }

    @Override
    public void enterAssertField(MSpecParser.AssertFieldContext ctx) {
        String name = this.getIdString(ctx.name);
        Term conditionExpression = this.getExpressionTerm(ctx.condition);
        DefaultAssertField field = new DefaultAssertField(this.getAttributes((RuleContext)ctx), name, conditionExpression);
        this.getTypeReference(ctx.type).whenComplete((typeReference, throwable) -> {
            if (throwable != null) {
                LOGGER.debug("Error setting type for {}", (Object)field, throwable);
                return;
            }
            field.setType((TypeReference)typeReference);
        });
        if (this.parserContexts.peek() != null) {
            this.parserContexts.peek().add((Field)field);
        }
    }

    @Override
    public void enterManualArrayField(MSpecParser.ManualArrayFieldContext ctx) {
        String name = this.getIdString(ctx.name);
        ManualArrayField.LoopType loopType = ManualArrayField.LoopType.valueOf((String)ctx.loopType.getText().toUpperCase());
        Term loopExpression = this.getExpressionTerm(ctx.loopExpression);
        Term parseExpression = this.getExpressionTerm(ctx.parseExpression);
        Term serializeExpression = this.getExpressionTerm(ctx.serializeExpression);
        Term lengthExpression = this.getExpressionTerm(ctx.lengthExpression);
        DefaultManualArrayField field = new DefaultManualArrayField(this.getAttributes((RuleContext)ctx), name, loopType, loopExpression, parseExpression, serializeExpression, lengthExpression);
        this.getTypeReference(ctx.type).whenComplete((typeReference, throwable) -> {
            if (throwable != null) {
                LOGGER.debug("Error setting type for {}", (Object)field, throwable);
                return;
            }
            field.setType((TypeReference)new DefaultArrayTypeReference((TypeReference)typeReference));
        });
        if (this.parserContexts.peek() != null) {
            this.parserContexts.peek().add((Field)field);
        }
    }

    @Override
    public void enterManualField(MSpecParser.ManualFieldContext ctx) {
        String name = this.getIdString(ctx.name);
        Term parseExpression = this.getExpressionTerm(ctx.parseExpression);
        Term serializeExpression = this.getExpressionTerm(ctx.serializeExpression);
        Term lengthExpression = this.getExpressionTerm(ctx.lengthExpression);
        DefaultManualField field = new DefaultManualField(this.getAttributes((RuleContext)ctx), name, parseExpression, serializeExpression, lengthExpression);
        this.getTypeReference(ctx.type).whenComplete((typeReference, throwable) -> {
            if (throwable != null) {
                LOGGER.debug("Error setting type for {}", (Object)field, throwable);
                return;
            }
            field.setType((TypeReference)typeReference);
        });
        if (this.parserContexts.peek() != null) {
            this.parserContexts.peek().add((Field)field);
        }
    }

    @Override
    public void enterOptionalField(MSpecParser.OptionalFieldContext ctx) {
        String name = this.getIdString(ctx.name);
        Term conditionExpression = null;
        if (ctx.condition != null) {
            conditionExpression = this.getExpressionTerm(ctx.condition);
        }
        DefaultOptionalField field = new DefaultOptionalField(this.getAttributes((RuleContext)ctx), name, conditionExpression);
        this.getTypeReference(ctx.type).whenComplete((typeReference, throwable) -> {
            if (throwable != null) {
                LOGGER.debug("Error setting type for {}", (Object)field, throwable);
                return;
            }
            field.setType((TypeReference)typeReference);
        });
        if (this.parserContexts.peek() != null) {
            this.parserContexts.peek().add((Field)field);
        }
    }

    @Override
    public void enterPeekField(MSpecParser.PeekFieldContext ctx) {
        String name = this.getIdString(ctx.name);
        Term offsetExpression = null;
        if (ctx.offset != null) {
            offsetExpression = this.getExpressionTerm(ctx.offset);
        }
        DefaultPeekField field = new DefaultPeekField(this.getAttributes((RuleContext)ctx), name, offsetExpression);
        this.getTypeReference(ctx.type).whenComplete((typeReference, throwable) -> {
            if (throwable != null) {
                LOGGER.debug("Error setting type for {}", (Object)field, throwable);
                return;
            }
            field.setType((TypeReference)typeReference);
        });
        if (this.parserContexts.peek() != null) {
            this.parserContexts.peek().add((Field)field);
        }
    }

    @Override
    public void enterPaddingField(MSpecParser.PaddingFieldContext ctx) {
        SimpleTypeReference type = this.getSimpleTypeReference(ctx.type);
        String name = this.getIdString(ctx.name);
        Term paddingValue = this.getExpressionTerm(ctx.paddingValue);
        Term paddingCondition = this.getExpressionTerm(ctx.paddingCondition);
        DefaultPaddingField field = new DefaultPaddingField(this.getAttributes((RuleContext)ctx), type, name, paddingValue, paddingCondition);
        if (this.parserContexts.peek() != null) {
            this.parserContexts.peek().add((Field)field);
        }
    }

    @Override
    public void enterReservedField(MSpecParser.ReservedFieldContext ctx) {
        SimpleTypeReference type = this.getSimpleTypeReference(ctx.type);
        String expected = this.getExprString(ctx.expected);
        DefaultReservedField field = new DefaultReservedField(this.getAttributes((RuleContext)ctx), type, expected);
        if (this.parserContexts.peek() != null) {
            this.parserContexts.peek().add((Field)field);
        }
    }

    @Override
    public void enterSimpleField(MSpecParser.SimpleFieldContext ctx) {
        String name = this.getIdString(ctx.name);
        DefaultSimpleField field = new DefaultSimpleField(this.getAttributes((RuleContext)ctx), name);
        this.getTypeReference(ctx.type).whenComplete((typeReference, throwable) -> {
            if (throwable != null) {
                LOGGER.debug("Error setting type for {}", (Object)field, throwable);
                return;
            }
            field.setType((TypeReference)typeReference);
        });
        if (this.parserContexts.peek() != null) {
            this.parserContexts.peek().add((Field)field);
        }
    }

    @Override
    public void enterTypeSwitchField(MSpecParser.TypeSwitchFieldContext ctx) {
        List<VariableLiteral> variableLiterals = ctx.discriminators.variableLiteral().stream().map(this::getVariableLiteral).collect(Collectors.toList());
        DefaultSwitchField field = new DefaultSwitchField(this.getAttributes((RuleContext)ctx), variableLiterals);
        if (this.parserContexts.peek() != null) {
            this.parserContexts.peek().add((Field)field);
        }
    }

    @Override
    public void enterUnknownField(MSpecParser.UnknownFieldContext ctx) {
        SimpleTypeReference type = this.getSimpleTypeReference(ctx.type);
        DefaultUnknownField field = new DefaultUnknownField(this.getAttributes((RuleContext)ctx), type);
        if (this.parserContexts.peek() != null) {
            this.parserContexts.peek().add((Field)field);
        }
    }

    @Override
    public void enterVirtualField(MSpecParser.VirtualFieldContext ctx) {
        String name = this.getIdString(ctx.name);
        Term valueExpression = this.getExpressionTerm(ctx.valueExpression);
        DefaultVirtualField field = new DefaultVirtualField(this.getAttributes((RuleContext)ctx), name, valueExpression);
        this.getTypeReference(ctx.type).whenComplete((typeReference, throwable) -> {
            if (throwable != null) {
                LOGGER.debug("Error setting type for {}", (Object)field, throwable);
                return;
            }
            field.setType((TypeReference)typeReference);
        });
        if (this.parserContexts.peek() != null) {
            this.parserContexts.peek().add((Field)field);
        }
    }

    @Override
    public void enterValidationField(MSpecParser.ValidationFieldContext ctx) {
        Term validationExpression = this.getExpressionTerm(ctx.validationExpression);
        boolean shouldFail = true;
        if (ctx.shouldFail != null) {
            shouldFail = "true".equalsIgnoreCase(ctx.shouldFail.getText());
        }
        String description = null;
        if (ctx.description != null) {
            description = ctx.description.getText();
        }
        DefaultValidationField field = new DefaultValidationField(this.getAttributes((RuleContext)ctx), validationExpression, description, shouldFail);
        if (this.parserContexts.peek() != null) {
            this.parserContexts.peek().add(field);
        }
    }

    @Override
    public void enterCaseStatement(MSpecParser.CaseStatementContext ctx) {
        LinkedList parserContext = new LinkedList();
        String namePrefix = "";
        if (ctx.nameWildcard != null) {
            namePrefix = this.getCurrentTypeName();
        }
        String typeName = String.valueOf(namePrefix) + ctx.name.getText();
        this.currentTypeName.push(typeName);
        if (ctx.parent.parent instanceof MSpecParser.DataIoDefinitionContext) {
            this.currentTypeName.pop();
        }
        this.parserContexts.push(parserContext);
    }

    @Override
    public void exitCaseStatement(MSpecParser.CaseStatementContext ctx) {
        DefaultSwitchField switchField;
        String typeName = this.currentTypeName.pop();
        if (ctx.parent.parent instanceof MSpecParser.DataIoDefinitionContext) {
            this.currentTypeName.push(typeName);
            typeName = ctx.name.getText();
        }
        boolean abstractType = this.getSwitchField() != null;
        Map<String, Term> attributes = this.batchSetAttributes.peek();
        LinkedList<Argument> parserArguments = new LinkedList<Argument>();
        if (ctx.argumentList() != null) {
            parserArguments.addAll(this.getParserArguments(ctx.argumentList().argument()));
        }
        List<Object> discriminatorValues = ctx.discriminatorValues != null ? ctx.discriminatorValues.expression().stream().map(this::getExpressionTerm).collect(Collectors.toList()) : Collections.emptyList();
        List<Field> fields = this.parserContexts.pop();
        DefaultDiscriminatedComplexTypeDefinition type = new DefaultDiscriminatedComplexTypeDefinition(typeName, attributes, parserArguments, abstractType, fields, discriminatorValues);
        if (fields != null) {
            fields.forEach(field -> ((DefaultField)field).setOwner((TypeDefinition)type));
        }
        if (!(ctx.parent.parent instanceof MSpecParser.DataIoDefinitionContext)) {
            this.dispatchType(typeName, (TypeDefinition)type);
        }
        if ((switchField = this.getSwitchField()) == null) {
            throw new RuntimeException("This shouldn't have happened");
        }
        switchField.addCase(type);
    }

    @Override
    public void enterEnumValueDefinition(MSpecParser.EnumValueDefinitionContext ctx) {
        String value = ctx.valueExpression != null ? this.unquoteString(ctx.valueExpression.getText()) : null;
        String name = ctx.name.getText();
        HashMap<String, String> constants = null;
        if (ctx.constantValueExpressions != null) {
            int numExpressionValues;
            MSpecParser.ComplexTypeContext parentCtx = (MSpecParser.ComplexTypeContext)ctx.parent;
            int numConstantValues = parentCtx.params.argument().size();
            if (numConstantValues != (numExpressionValues = ctx.constantValueExpressions.expression().size())) {
                throw new RuntimeException("Number of constant value expressions doesn't match the number of defined constants. Expecting " + numConstantValues + " but got " + numExpressionValues);
            }
            constants = new HashMap<String, String>();
            int i = 0;
            while (i < numConstantValues) {
                MSpecParser.ArgumentContext argumentContext = parentCtx.params.argument(i);
                String constantName = argumentContext.name.getText();
                MSpecParser.ExpressionContext expression = ctx.constantValueExpressions.expression(i);
                String constant = this.unquoteString(expression.getText());
                if (constant != null && constant.startsWith("\"")) {
                    constant = this.unquoteString(constant);
                }
                constants.put(constantName, constant);
                ++i;
            }
        }
        List<EnumValue> enumValues = Objects.requireNonNull(this.enumContexts.peek());
        if (value == null) {
            String counted = "0";
            if (enumValues.size() > 0) {
                String previousValue = enumValues.get(enumValues.size() - 1).getValue();
                int parsedPreviousValue = Integer.parseInt(previousValue);
                counted = "" + (parsedPreviousValue + 1);
            }
            value = counted;
        }
        DefaultEnumValue enumValue = new DefaultEnumValue(value, name, constants);
        enumValues.add(enumValue);
    }

    private Term getExpressionTerm(MSpecParser.ExpressionContext expressionContext) {
        if (expressionContext.ASTERISK() != null) {
            return WildcardTerm.INSTANCE;
        }
        String expressionString = this.getExprString(expressionContext);
        Objects.requireNonNull(expressionString, "Expression string should not be null");
        InputStream inputStream = IOUtils.toInputStream((String)expressionString, (Charset)Charset.defaultCharset());
        Objects.requireNonNull(this.getCurrentTypeName(), "expression term can only occur within a type");
        ExpressionStringParser parser = new ExpressionStringParser(this, this.getCurrentTypeName());
        try {
            return parser.parse(inputStream);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Error parsing expression: '%s' at line %d column %d", expressionString, expressionContext.start.getLine(), expressionContext.start.getStartIndex()), e);
        }
    }

    private VariableLiteral getVariableLiteral(MSpecParser.VariableLiteralContext variableLiteralContext) {
        String variableLiteral = variableLiteralContext.getText();
        InputStream inputStream = IOUtils.toInputStream((String)variableLiteral, (Charset)Charset.defaultCharset());
        ExpressionStringParser parser = new ExpressionStringParser(this, this.getCurrentTypeName());
        try {
            return (VariableLiteral)parser.parse(inputStream);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Error parsing variable literal: '%s' at line %d column %d", variableLiteral, variableLiteralContext.start.getLine(), variableLiteralContext.start.getStartIndex()), e);
        }
    }

    private Literal getValueLiteral(MSpecParser.ValueLiteralContext valueLiteralContext) {
        String valueLiteralContextText = valueLiteralContext.getText();
        InputStream inputStream = IOUtils.toInputStream((String)valueLiteralContextText, (Charset)Charset.defaultCharset());
        ExpressionStringParser parser = new ExpressionStringParser(this, this.getCurrentTypeName());
        try {
            return (Literal)parser.parse(inputStream);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Error parsing variable literal: '%s' at line %d column %d", valueLiteralContextText, valueLiteralContext.start.getLine(), valueLiteralContext.start.getStartIndex()), e);
        }
    }

    private CompletionStage<TypeReference> getTypeReference(MSpecParser.TypeReferenceContext ctx) {
        if (ctx.simpleTypeReference != null) {
            return CompletableFuture.completedFuture(this.getSimpleTypeReference(ctx.simpleTypeReference));
        }
        CompletableFuture<TypeReference> typeReferenceCompletableFuture = new CompletableFuture<TypeReference>();
        String typeRefName = ctx.complexTypeReference.getText();
        this.setOrScheduleTypeDefinitionConsumer(typeRefName, typeDefinition -> {
            if (typeDefinition.isDataIoTypeDefinition()) {
                DefaultDataIoTypeReference value = new DefaultDataIoTypeReference(typeRefName, this.getParams(typeReferenceContext.params));
                value.setTypeDefinition((TypeDefinition)typeDefinition);
                typeReferenceCompletableFuture.complete((TypeReference)value);
            } else if (typeDefinition.isComplexTypeDefinition()) {
                DefaultComplexTypeReference value = new DefaultComplexTypeReference(typeRefName, this.getParams(typeReferenceContext.params));
                value.setTypeDefinition((TypeDefinition)typeDefinition);
                typeReferenceCompletableFuture.complete((TypeReference)value);
            } else if (typeDefinition.isEnumTypeDefinition()) {
                DefaultEnumTypeReference value = new DefaultEnumTypeReference(typeRefName, this.getParams(typeReferenceContext.params));
                value.setTypeDefinition((TypeDefinition)typeDefinition);
                typeReferenceCompletableFuture.complete((TypeReference)value);
            } else {
                throw new RuntimeException("Support for " + typeDefinition.getClass() + " not implemented yet");
            }
        });
        return typeReferenceCompletableFuture;
    }

    private SimpleTypeReference getSimpleTypeReference(MSpecParser.DataTypeContext ctx) {
        SimpleTypeReference.SimpleBaseType simpleBaseType = SimpleTypeReference.SimpleBaseType.valueOf((String)ctx.base.getText().toUpperCase());
        if (simpleBaseType == SimpleTypeReference.SimpleBaseType.VSTRING) {
            if (ctx.length != null) {
                Term lengthExpression = this.getExpressionTerm(ctx.length);
                return new DefaultVstringTypeReference(simpleBaseType, lengthExpression);
            }
            return new DefaultVstringTypeReference(simpleBaseType, null);
        }
        switch (simpleBaseType) {
            case UINT: 
            case INT: {
                int integerSize = Integer.parseInt(ctx.size.getText());
                return new DefaultIntegerTypeReference(simpleBaseType, integerSize);
            }
            case VINT: {
                Map<String, Term> attributes = this.getAttributes(ctx.parent.parent);
                int propertySizeInBits = 32;
                if (attributes.containsKey("propertySizeInBits")) {
                    Term propertySizeInBitsTerm = attributes.get("propertySizeInBits");
                    if (!(propertySizeInBitsTerm instanceof NumericLiteral)) {
                        throw new RuntimeException("'propertySizeInBits' attribute is required to be a numeric literal");
                    }
                    NumericLiteral propertySizeInBitsLiteral = (NumericLiteral)propertySizeInBitsTerm;
                    propertySizeInBits = propertySizeInBitsLiteral.getNumber().intValue();
                }
                DefaultIntegerTypeReference propertyType = new DefaultIntegerTypeReference(SimpleTypeReference.SimpleBaseType.INT, propertySizeInBits);
                return new DefaultVintegerTypeReference(simpleBaseType, propertyType);
            }
            case VUINT: {
                Map<String, Term> attributes = this.getAttributes(ctx.parent.parent);
                int propertySizeInBits = 32;
                if (attributes.containsKey("propertySizeInBits")) {
                    Term propertySizeInBitsTerm = attributes.get("propertySizeInBits");
                    if (!(propertySizeInBitsTerm instanceof NumericLiteral)) {
                        throw new RuntimeException("'propertySizeInBits' attribute is required to be a numeric literal");
                    }
                    NumericLiteral propertySizeInBitsLiteral = (NumericLiteral)propertySizeInBitsTerm;
                    propertySizeInBits = propertySizeInBitsLiteral.getNumber().intValue();
                }
                DefaultIntegerTypeReference propertyType = new DefaultIntegerTypeReference(SimpleTypeReference.SimpleBaseType.UINT, propertySizeInBits);
                return new DefaultVintegerTypeReference(simpleBaseType, propertyType);
            }
            case FLOAT: 
            case UFLOAT: {
                int floatSize = Integer.parseInt(ctx.size.getText());
                return new DefaultFloatTypeReference(simpleBaseType, floatSize);
            }
            case TIME: 
            case DATE: 
            case DATETIME: {
                return new DefaultTemporalTypeReference(simpleBaseType);
            }
            case BIT: {
                return new DefaultBooleanTypeReference();
            }
            case BYTE: {
                return new DefaultByteTypeReference();
            }
            case STRING: {
                int stringSize = Integer.parseInt(ctx.size.getText());
                return new DefaultStringTypeReference(simpleBaseType, stringSize);
            }
        }
        return new DefaultIntegerTypeReference(simpleBaseType, 1);
    }

    private DefaultSwitchField getSwitchField() {
        for (Field field : Objects.requireNonNull(this.parserContexts.peek())) {
            if (!(field instanceof DefaultSwitchField)) continue;
            return (DefaultSwitchField)field;
        }
        return null;
    }

    private List<EnumValue> getEnumValues() {
        return Objects.requireNonNull(this.enumContexts.peek());
    }

    private List<Argument> getParserArguments(List<MSpecParser.ArgumentContext> params) {
        return params.stream().map(argumentContext -> {
            DefaultArgument argument = new DefaultArgument(this.getIdString(argumentContext.name));
            this.getTypeReference(argumentContext.type).whenComplete((typeReference, throwable) -> {
                if (throwable != null) {
                    LOGGER.debug("Error setting type for {}", (Object)argument, throwable);
                    return;
                }
                argument.setType((TypeReference)typeReference);
            });
            return argument;
        }).collect(Collectors.toList());
    }

    private List<Term> getParams(MSpecParser.MultipleExpressionsContext params) {
        if (params == null) {
            return null;
        }
        return params.expression().stream().map(this::getExprString).map(this::parseExpression).collect(Collectors.toList());
    }

    private Term parseExpression(String expressionString) {
        InputStream inputStream = IOUtils.toInputStream((String)expressionString, (Charset)Charset.defaultCharset());
        ExpressionStringParser parser = new ExpressionStringParser(this, this.getCurrentTypeName());
        try {
            return parser.parse(inputStream);
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing expression: '" + expressionString + "'", e);
        }
    }

    private String getCurrentTypeName() {
        if (this.currentTypeName.isEmpty()) {
            return null;
        }
        return this.currentTypeName.peek();
    }

    private Map<String, Term> getAttributes(RuleContext ctx) {
        HashMap<String, Term> attributes = new HashMap<String, Term>();
        if (!this.batchSetAttributes.empty()) {
            attributes.putAll(this.batchSetAttributes.peek());
        }
        if (ctx.parent.parent instanceof MSpecParser.FieldDefinitionContext) {
            MSpecParser.FieldDefinitionContext fieldDefinitionContext = (MSpecParser.FieldDefinitionContext)ctx.parent.parent;
            for (MSpecParser.AttributeContext attributeContext : fieldDefinitionContext.attributes.attribute()) {
                Term attributeExpression = this.getExpressionTerm(attributeContext.value);
                attributes.put(attributeContext.name.getText(), attributeExpression);
            }
        }
        return attributes;
    }

    private String unquoteString(String quotedString) {
        if (quotedString == null || quotedString.length() < 2) {
            return quotedString;
        }
        return quotedString.substring(1, quotedString.length() - 1);
    }

    private String getIdString(MSpecParser.IdExpressionContext ctx) {
        if (ctx.id == null) {
            return null;
        }
        return ctx.id.getText();
    }

    private String getExprString(MSpecParser.ExpressionContext ctx) {
        if (ctx.expr == null) {
            return null;
        }
        return ctx.expr.getText();
    }

    public void dispatchType(String typeName, TypeDefinition type) {
        LOGGER.debug("dispatching {}:{}", (Object)typeName, (Object)type);
        if (this.types.containsKey(typeName)) {
            LOGGER.warn("{} being overridden", (Object)typeName);
        }
        this.types.put(typeName, type);
        while (((List)this.typeDefinitionConsumers.getOrDefault(typeName, new LinkedList())).size() != 0) {
            this.consumerDispatchType(typeName, type);
        }
        this.typeDefinitionConsumers.remove(typeName);
    }

    private void consumerDispatchType(String typeName, TypeDefinition type) {
        List waitingConsumers = this.typeDefinitionConsumers.getOrDefault(typeName, new LinkedList());
        LOGGER.debug("{} waiting for {}", (Object)waitingConsumers.size(), (Object)typeName);
        Iterator consumerIterator = waitingConsumers.iterator();
        ArrayList<Consumer> removedItems = new ArrayList<Consumer>();
        while (consumerIterator.hasNext()) {
            Consumer setter = (Consumer)consumerIterator.next();
            LOGGER.debug("setting {} for {}", (Object)typeName, (Object)setter);
            removedItems.add(setter);
        }
        waitingConsumers.removeAll(removedItems);
        for (Consumer setter : removedItems) {
            setter.accept(type);
        }
    }

    @Override
    public void setOrScheduleTypeDefinitionConsumer(String typeRefName, Consumer<TypeDefinition> setTypeDefinition) {
        LOGGER.debug("set or schedule {}", (Object)typeRefName);
        TypeDefinition typeDefinition = this.types.get(typeRefName);
        if (typeDefinition != null) {
            LOGGER.debug("{} present so setting for {}", (Object)typeRefName, setTypeDefinition);
            setTypeDefinition.accept(typeDefinition);
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} already waiting for {}", (Object)((List)this.typeDefinitionConsumers.getOrDefault(typeRefName, new LinkedList())).size(), (Object)typeRefName);
            }
            this.typeDefinitionConsumers.putIfAbsent(typeRefName, new LinkedList());
            this.typeDefinitionConsumers.get(typeRefName).add(setTypeDefinition);
        }
    }
}

