/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.plugins.codegenerator.language.mspec.model.terms;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.plc4x.plugins.codegenerator.types.references.TypeReference;
import org.apache.plc4x.plugins.codegenerator.types.terms.Term;
import org.apache.plc4x.plugins.codegenerator.types.terms.VariableLiteral;

public class DefaultVariableLiteral
implements VariableLiteral {
    private final String name;
    private TypeReference typeReference;
    private final List<Term> args;
    private final Integer index;
    private final VariableLiteral child;

    public DefaultVariableLiteral(String name, List<Term> args, Integer index, VariableLiteral child) {
        this.name = Objects.requireNonNull(name);
        this.args = args;
        this.index = index;
        this.child = child;
    }

    public String getName() {
        return this.name;
    }

    public TypeReference getTypeReference() {
        if (this.typeReference == null) {
            throw new IllegalStateException("No type reference set for " + this.name);
        }
        return this.typeReference;
    }

    public void setTypeReference(TypeReference typeReference) {
        Objects.requireNonNull(typeReference);
        this.typeReference = typeReference;
    }

    public Optional<List<Term>> getArgs() {
        return Optional.ofNullable(this.args);
    }

    public Optional<Integer> getIndex() {
        return Optional.ofNullable(this.index);
    }

    public Optional<VariableLiteral> getChild() {
        return Optional.ofNullable(this.child);
    }

    public String stringRepresentation() {
        return String.valueOf(this.name) + this.getChild().map(Term::stringRepresentation).orElse("");
    }

    public String toString() {
        return "DefaultVariableLiteral{name='" + this.name + '\'' + ", typeReference='" + this.typeReference + '\'' + ", args=" + this.args + ", index=" + this.index + ", child=" + this.child + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultVariableLiteral that = (DefaultVariableLiteral)o;
        return Objects.equals(this.index, that.index) && this.name.equals(that.name) && this.typeReference.equals(that.typeReference) && Objects.equals(this.args, that.args) && Objects.equals(this.child, that.child);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.typeReference, this.args, this.index, this.child);
    }
}

