/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.plugins.codegenerator.language.mspec.model.terms;

import java.util.Objects;
import org.apache.plc4x.plugins.codegenerator.types.terms.Term;
import org.apache.plc4x.plugins.codegenerator.types.terms.TernaryTerm;

public class DefaultTernaryTerm
implements TernaryTerm {
    private final Term a;
    private final Term b;
    private final Term c;
    private final String operation;

    public DefaultTernaryTerm(Term a, Term b, Term c, String operation) {
        this.a = Objects.requireNonNull(a);
        this.b = Objects.requireNonNull(b);
        this.c = Objects.requireNonNull(c);
        this.operation = Objects.requireNonNull(operation);
    }

    public Term getA() {
        return this.a;
    }

    public Term getB() {
        return this.b;
    }

    public Term getC() {
        return this.c;
    }

    public String getOperation() {
        return this.operation;
    }

    public String stringRepresentation() {
        return "(" + this.a + ") ? (" + this.b + ") : (" + this.c + ")";
    }

    public String toString() {
        return "DefaultTernaryTerm{a=" + this.a + ", b=" + this.b + ", c=" + this.c + ", operation='" + this.operation + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultTernaryTerm that = (DefaultTernaryTerm)o;
        return this.a.equals(that.a) && this.b.equals(that.b) && this.c.equals(that.c) && this.operation.equals(that.operation);
    }

    public int hashCode() {
        return Objects.hash(this.a, this.b, this.c, this.operation);
    }
}

