/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.plugins.codegenerator.language.mspec.model.references;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.plc4x.plugins.codegenerator.types.definitions.EnumTypeDefinition;
import org.apache.plc4x.plugins.codegenerator.types.definitions.TypeDefinition;
import org.apache.plc4x.plugins.codegenerator.types.references.EnumTypeReference;
import org.apache.plc4x.plugins.codegenerator.types.references.SimpleTypeReference;
import org.apache.plc4x.plugins.codegenerator.types.terms.Term;

public class DefaultEnumTypeReference
implements EnumTypeReference {
    protected final String name;
    protected final List<Term> params;
    protected transient EnumTypeDefinition typeDefinition;

    public DefaultEnumTypeReference(String name, List<Term> params) {
        this.name = Objects.requireNonNull(name);
        this.params = params;
    }

    public String getName() {
        return this.name;
    }

    public Optional<List<Term>> getParams() {
        return Optional.ofNullable(this.params);
    }

    public Optional<SimpleTypeReference> getBaseTypeReference() {
        return this.getEnumTypeDefinition().getType();
    }

    public TypeDefinition getTypeDefinition() {
        return this.getEnumTypeDefinition();
    }

    public void setTypeDefinition(TypeDefinition typeDefinition) {
        Objects.requireNonNull(typeDefinition);
        if (!(typeDefinition instanceof EnumTypeDefinition)) {
            throw new IllegalArgumentException("DefaultEnumTypeReferences only accept instances of EnumTypeDefinitions");
        }
        this.typeDefinition = (EnumTypeDefinition)typeDefinition;
    }

    public EnumTypeDefinition getEnumTypeDefinition() {
        if (this.typeDefinition == null) {
            throw new IllegalStateException("Should not happen as this should be initialized. No type for " + this.name + " set!!!");
        }
        return this.typeDefinition;
    }

    public void setEnumTypeDefinition(EnumTypeDefinition typeDefinition) {
        Objects.requireNonNull(typeDefinition);
        this.typeDefinition = typeDefinition;
    }

    public String toString() {
        return "DefaultEnumTypeReference{name='" + this.name + '\'' + ", params=" + this.params + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultEnumTypeReference that = (DefaultEnumTypeReference)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.params, that.params);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.params);
    }
}

