/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.plugins.codegenerator.language.mspec.model.references;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.plc4x.plugins.codegenerator.types.definitions.ComplexTypeDefinition;
import org.apache.plc4x.plugins.codegenerator.types.definitions.TypeDefinition;
import org.apache.plc4x.plugins.codegenerator.types.references.ComplexTypeReference;
import org.apache.plc4x.plugins.codegenerator.types.terms.Term;

public class DefaultComplexTypeReference
implements ComplexTypeReference {
    protected final String name;
    protected final List<Term> params;
    protected transient ComplexTypeDefinition typeDefinition;

    public DefaultComplexTypeReference(String name, List<Term> params) {
        this.name = Objects.requireNonNull(name);
        this.params = params;
    }

    public String getName() {
        return this.name;
    }

    public Optional<List<Term>> getParams() {
        return Optional.ofNullable(this.params);
    }

    public ComplexTypeDefinition getTypeDefinition() {
        if (this.typeDefinition == null) {
            throw new IllegalStateException("Should not happen as this should be initialized. No type for " + this.name + " set!!!");
        }
        return this.typeDefinition;
    }

    public void setTypeDefinition(TypeDefinition typeDefinition) {
        Objects.requireNonNull(typeDefinition);
        if (!(typeDefinition instanceof ComplexTypeDefinition)) {
            throw new IllegalArgumentException("DefaultComplexTypeReferences only accept instances of ComplexTypeDefinitions. Actual type: " + typeDefinition.getClass());
        }
        this.typeDefinition = (ComplexTypeDefinition)typeDefinition;
    }

    public void setComplexTypeDefinition(ComplexTypeDefinition typeDefinition) {
        Objects.requireNonNull(typeDefinition);
        this.typeDefinition = typeDefinition;
    }

    public String toString() {
        return "DefaultComplexTypeReference{name='" + this.name + '\'' + ", params=" + this.params + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultComplexTypeReference that = (DefaultComplexTypeReference)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.params, that.params);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.params);
    }
}

