/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.plugins.codegenerator.language.mspec.model.fields;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.plc4x.plugins.codegenerator.types.definitions.TypeDefinition;
import org.apache.plc4x.plugins.codegenerator.types.terms.Term;

public abstract class DefaultField {
    protected TypeDefinition owner;
    protected final Map<String, Term> attributes;

    protected DefaultField(Map<String, Term> attributes) {
        this.attributes = Objects.requireNonNull(attributes);
    }

    public void setOwner(TypeDefinition owner) {
        this.owner = owner;
    }

    public TypeDefinition getOwner() {
        return this.owner;
    }

    public Optional<Term> getAttribute(String attributeName) {
        if (this.attributes.containsKey(attributeName)) {
            return Optional.of(this.attributes.get(attributeName));
        }
        return Optional.empty();
    }

    public String toString() {
        return "DefaultField{attributes=" + this.attributes + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultField that = (DefaultField)o;
        return Objects.equals(this.attributes, that.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.attributes);
    }
}

