/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.plugins.codegenerator.language.mspec.model.fields;

import java.util.Map;
import java.util.Objects;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.fields.DefaultTypedNamedField;
import org.apache.plc4x.plugins.codegenerator.types.fields.ArrayField;
import org.apache.plc4x.plugins.codegenerator.types.references.ArrayTypeReference;
import org.apache.plc4x.plugins.codegenerator.types.references.TypeReference;
import org.apache.plc4x.plugins.codegenerator.types.terms.Term;

public class DefaultArrayField
extends DefaultTypedNamedField
implements ArrayField {
    private final ArrayField.LoopType loopType;
    private final Term loopExpression;

    public DefaultArrayField(Map<String, Term> attributes, String name, ArrayField.LoopType loopType, Term loopExpression) {
        super(attributes, name);
        this.loopType = Objects.requireNonNull(loopType);
        this.loopExpression = Objects.requireNonNull(loopExpression);
    }

    public ArrayField.LoopType getLoopType() {
        return this.loopType;
    }

    public Term getLoopExpression() {
        return this.loopExpression;
    }

    @Override
    public void setType(TypeReference typeReference) {
        if (!(typeReference instanceof ArrayTypeReference)) {
            throw new IllegalArgumentException("Array fields can only have ArrayTypeReferences");
        }
        super.setType(typeReference);
    }

    public ArrayTypeReference getType() {
        return (ArrayTypeReference)super.getType();
    }

    @Override
    public String toString() {
        return "DefaultArrayField{loopType=" + this.loopType + ", loopExpression=" + this.loopExpression + "} " + super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultArrayField that = (DefaultArrayField)o;
        return this.loopType == that.loopType && Objects.equals(this.loopExpression, that.loopExpression);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.loopType, this.loopExpression);
    }
}

