/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.plugins.codegenerator.language.mspec.model.definitions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.plc4x.plugins.codegenerator.types.definitions.Argument;
import org.apache.plc4x.plugins.codegenerator.types.terms.Term;

public abstract class DefaultTypeDefinition {
    protected final String name;
    private final Map<String, Term> attributes;
    protected final List<Argument> parserArguments;

    public DefaultTypeDefinition(String name, Map<String, Term> attributes, List<Argument> parserArguments) {
        this.name = Objects.requireNonNull(name);
        this.attributes = attributes;
        this.parserArguments = parserArguments;
    }

    public String getName() {
        return this.name;
    }

    public Optional<Term> getAttribute(String attributeName) {
        if (this.attributes.containsKey(attributeName)) {
            return Optional.of(this.attributes.get(attributeName));
        }
        return Optional.empty();
    }

    public Optional<List<Argument>> getParserArguments() {
        return Optional.ofNullable(this.parserArguments);
    }

    public Optional<List<Argument>> getAllParserArguments() {
        ArrayList<Argument> allArguments = new ArrayList<Argument>();
        if (this.parserArguments != null) {
            allArguments.addAll(this.parserArguments);
        }
        return Optional.of(allArguments);
    }

    public String toString() {
        return "DefaultTypeDefinition{name='" + this.name + '\'' + ", attributes=" + this.attributes + ", parserArguments=" + this.parserArguments + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultTypeDefinition that = (DefaultTypeDefinition)o;
        return this.name.equals(that.name) && Objects.equals(this.attributes, that.attributes) && Objects.equals(this.parserArguments, that.parserArguments);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.attributes, this.parserArguments);
    }
}

